/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.io.NotSerializableException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioError;
import org.biojava.bio.seq.io.SeqIOListener;
import org.biojava.bio.seq.io.StreamParser;
import org.biojava.bio.seq.io.SymbolParser;
import org.biojava.bio.symbol.AbstractSymbolList;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.SingletonAlphabet;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeType;
import org.biojava.utils.SingletonList;
import org.biojava.utils.StaticMemberPlaceHolder;

public class DoubleAlphabet
implements Alphabet,
Serializable {
    private static final DoubleAlphabet INSTANCE = new DoubleAlphabet();
    private static final SymbolParser PARSER = new SymbolParser(){

        public Alphabet getAlphabet() {
            return INSTANCE;
        }

        public Symbol parseToken(String token) {
            return INSTANCE.getSymbol(Double.parseDouble(token));
        }

        public SymbolList parse(String seq) {
            throw new BioError("Pants - haven't implemented this yet");
        }

        public StreamParser parseStream(SeqIOListener l) {
            throw new BioError("Not implemented yet");
        }
    };
    private List alphabets = null;
    static /* synthetic */ Class class$org$biojava$bio$symbol$DoubleAlphabet;

    private Object writeReplace() throws ObjectStreamException {
        try {
            return new StaticMemberPlaceHolder((class$org$biojava$bio$symbol$DoubleAlphabet == null ? (class$org$biojava$bio$symbol$DoubleAlphabet = DoubleAlphabet.class$("org.biojava.bio.symbol.DoubleAlphabet")) : class$org$biojava$bio$symbol$DoubleAlphabet).getField("INSTANCE"));
        }
        catch (NoSuchFieldException nsfe) {
            throw new NotSerializableException(nsfe.getMessage());
        }
    }

    public static SymbolList fromArray(double[] dArray) {
        return new DoubleArray(dArray);
    }

    public static DoubleAlphabet getInstance() {
        return INSTANCE;
    }

    public DoubleSymbol getSymbol(double val) {
        return new DoubleSymbol(val);
    }

    public Annotation getAnnotation() {
        return Annotation.EMPTY_ANNOTATION;
    }

    public boolean contains(Symbol s) {
        return s instanceof DoubleSymbol;
    }

    public void validate(Symbol s) throws IllegalSymbolException {
        if (!this.contains(s)) {
            throw new IllegalSymbolException("Only symbols of type DoubleAlphabet.DoubleSymbol are valid for this alphabet.\n(" + s.getClass() + ") " + s.getName());
        }
    }

    public List getAlphabets() {
        if (this.alphabets == null) {
            this.alphabets = new SingletonList(this);
        }
        return this.alphabets;
    }

    public Symbol getGapSymbol() {
        return AlphabetManager.getGapSymbol(this.getAlphabets());
    }

    public Symbol getAmbiguity(Set syms) throws IllegalSymbolException {
        Iterator i = syms.iterator();
        while (i.hasNext()) {
            Symbol sym = (Symbol)i.next();
            this.validate(sym);
        }
        throw new BioError("Operation not implemented");
    }

    public Symbol getSymbol(List symList) throws IllegalSymbolException {
        if (symList.size() != 1) {
            throw new IllegalSymbolException("Can't build symbol from list " + symList.size() + " long");
        }
        Symbol s = (Symbol)symList.get(0);
        this.validate(s);
        return s;
    }

    public String getName() {
        return "Alphabet of all doubles.";
    }

    public SymbolParser getParser(String name) {
        if (!name.equals("name")) {
            throw new NoSuchElementException("No parsers supported by DoubleAlphabet called " + name);
        }
        return PARSER;
    }

    public void addChangeListener(ChangeListener cl) {
    }

    public void addChangeListener(ChangeListener cl, ChangeType ct) {
    }

    public void removeChangeListener(ChangeListener cl) {
    }

    public void removeChangeListener(ChangeListener cl, ChangeType ct) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class DoubleArray
    extends AbstractSymbolList
    implements Serializable {
        private final double[] dArray;

        public Alphabet getAlphabet() {
            return INSTANCE;
        }

        public Symbol symbolAt(int i) {
            return new DoubleSymbol(this.dArray[i - 1]);
        }

        public int length() {
            return this.dArray.length;
        }

        public DoubleArray(double[] dArray) {
            this.dArray = dArray;
        }
    }

    public static class DoubleSymbol
    implements AtomicSymbol,
    Serializable {
        private final double val;
        private final Alphabet matches;

        public Annotation getAnnotation() {
            return Annotation.EMPTY_ANNOTATION;
        }

        public String getName() {
            return this.val + "";
        }

        public char getToken() {
            return '#';
        }

        public double doubleValue() {
            return this.val;
        }

        public Alphabet getMatches() {
            return this.matches;
        }

        public List getSymbols() {
            return new SingletonList(this);
        }

        public Set getBases() {
            return Collections.singleton(this);
        }

        protected DoubleSymbol(double val) {
            this.val = val;
            this.matches = new SingletonAlphabet(this);
        }

        public void addChangeListener(ChangeListener cl) {
        }

        public void addChangeListener(ChangeListener cl, ChangeType ct) {
        }

        public void removeChangeListener(ChangeListener cl) {
        }

        public void removeChangeListener(ChangeListener cl, ChangeType ct) {
        }
    }
}

