/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.io.NotSerializableException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import org.biojava.bio.BioError;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.SimpleSymbolList;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.StaticMemberPlaceHolder;

public interface Location {
    public static final Location empty = new EmptyLocation();
    public static final LocationComparator naturalOrder = new LocationComparator();

    public Location newInstance(Location var1);

    public Location getDecorator(Class var1);

    public int getMin();

    public int getMax();

    public boolean overlaps(Location var1);

    public boolean contains(Location var1);

    public boolean contains(int var1);

    public boolean equals(Object var1);

    public Location intersection(Location var1);

    public Location union(Location var1);

    public SymbolList symbols(SymbolList var1);

    public Location translate(int var1);

    public boolean isContiguous();

    public Iterator blockIterator();

    public static final class LocationComparator
    implements Comparator,
    Serializable {
        static /* synthetic */ Class class$org$biojava$bio$symbol$Location;

        public int compare(Object o1, Object o2) {
            int d = 0;
            Location l1 = (Location)o1;
            Location l2 = (Location)o2;
            Iterator i1 = l1.blockIterator();
            Iterator i2 = l2.blockIterator();
            while (i1.hasNext() && i2.hasNext()) {
                Location li1 = (Location)i1.next();
                Location li2 = (Location)i2.next();
                d = li1.getMin() - li2.getMin();
                if (d != 0) {
                    return d;
                }
                d = li1.getMax() - li2.getMax();
                if (d == 0) continue;
                return d;
            }
            if (i2.hasNext()) {
                return 1;
            }
            if (i1.hasNext()) {
                return -1;
            }
            return 0;
        }

        public boolean equals(Object obj) {
            return obj == this;
        }

        public boolean areEqual(Location l1, Location l2) {
            Iterator i1 = l1.blockIterator();
            Iterator i2 = l2.blockIterator();
            while (i1.hasNext() && i2.hasNext()) {
                if (i1.next().equals(i2.next())) continue;
                return false;
            }
            return i1.hasNext() || i2.hasNext();
        }

        private Object writeReplace() throws ObjectStreamException {
            try {
                return new StaticMemberPlaceHolder((class$org$biojava$bio$symbol$Location == null ? (class$org$biojava$bio$symbol$Location = LocationComparator.class$("org.biojava.bio.symbol.Location")) : class$org$biojava$bio$symbol$Location).getField("naturalOrder"));
            }
            catch (NoSuchFieldException nsfe) {
                throw new NotSerializableException(nsfe.getMessage());
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    public static final class EmptyLocation
    implements Location,
    Serializable {
        static /* synthetic */ Class class$org$biojava$bio$symbol$Location;

        public Location getDecorator(Class decoratorClass) {
            if (decoratorClass.isInstance(this)) {
                return this;
            }
            return null;
        }

        public Location newInstance(Location loc) {
            return loc;
        }

        public int getMin() {
            return Integer.MAX_VALUE;
        }

        public int getMax() {
            return Integer.MIN_VALUE;
        }

        public boolean overlaps(Location l) {
            return false;
        }

        public boolean contains(Location l) {
            return false;
        }

        public boolean contains(int p) {
            return false;
        }

        public boolean equals(Object o) {
            if (o instanceof Location) {
                if (o instanceof EmptyLocation) {
                    return true;
                }
                return naturalOrder.areEqual(this, (Location)o);
            }
            return false;
        }

        public Location intersection(Location l) {
            return empty;
        }

        public Location union(Location l) {
            return l;
        }

        public SymbolList symbols(SymbolList seq) {
            try {
                return new SimpleSymbolList(seq.getAlphabet(), new ArrayList());
            }
            catch (IllegalSymbolException ex) {
                throw new BioError(ex);
            }
        }

        public Location translate(int dist) {
            return this;
        }

        public boolean isContiguous() {
            return true;
        }

        public Iterator blockIterator() {
            return Collections.EMPTY_SET.iterator();
        }

        private Object writeReplace() throws ObjectStreamException {
            try {
                return new StaticMemberPlaceHolder((class$org$biojava$bio$symbol$Location == null ? (class$org$biojava$bio$symbol$Location = EmptyLocation.class$("org.biojava.bio.symbol.Location")) : class$org$biojava$bio$symbol$Location).getField("empty"));
            }
            catch (NoSuchFieldException nsfe) {
                throw new NotSerializableException(nsfe.getMessage());
            }
        }

        public String toString() {
            return "{}";
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

