/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioError;
import org.biojava.bio.SimpleAnnotation;
import org.biojava.bio.symbol.AbstractSymbol;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.BasisSymbol;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.Symbol;

class SimpleSymbol
extends AbstractSymbol
implements Symbol,
Serializable {
    private final char token;
    private final Annotation annotation;
    protected Alphabet matches;

    protected SimpleSymbol(char token, Annotation annotation) {
        this.token = token;
        this.annotation = new SimpleAnnotation(annotation);
    }

    public SimpleSymbol(char token, Annotation annotation, Alphabet matches) {
        this(token, annotation);
        if (matches == null) {
            throw new NullPointerException("Can't construct SimpleSymbol with a null matches alphabet");
        }
        this.matches = matches;
    }

    public char getToken() {
        return this.token;
    }

    public Annotation getAnnotation() {
        return this.annotation;
    }

    public Alphabet getMatches() {
        if (this.matches == null) {
            this.matches = this.createMatches();
        }
        return this.matches;
    }

    protected Alphabet createMatches() {
        throw new BioError("Assertion Failure: Matches alphabet is null in " + this);
    }

    public String getName() {
        List l;
        if (this instanceof BasisSymbol && (l = ((BasisSymbol)((Object)this)).getSymbols()).size() > 1) {
            Symbol sym;
            StringBuffer sb = new StringBuffer();
            sb.append('(');
            Iterator si = l.iterator();
            if (si.hasNext()) {
                sym = (Symbol)si.next();
                sb.append(sym.getName());
            }
            while (si.hasNext()) {
                sym = (Symbol)si.next();
                sb.append(' ');
                sb.append(sym.getName());
            }
            sb.append(')');
            return sb.toString();
        }
        Alphabet a = this.getMatches();
        if (a instanceof FiniteAlphabet) {
            Symbol sym;
            FiniteAlphabet fa = (FiniteAlphabet)a;
            StringBuffer sb = new StringBuffer();
            sb.append('[');
            Iterator si = fa.iterator();
            if (si.hasNext()) {
                sym = (Symbol)si.next();
                sb.append(sym.getName());
            }
            while (si.hasNext()) {
                sym = (Symbol)si.next();
                sb.append(' ');
                sb.append(sym.getName());
            }
            sb.append(']');
            return sb.toString();
        }
        return "Infinite";
    }
}

