/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.NestedError;

public class ChangeSupport {
    private int listenerCount = 0;
    private int delta;
    private Reference[] listeners;
    private ChangeType[] types;

    public ChangeSupport() {
        this(5);
    }

    public ChangeSupport(int initialSize) {
        this(initialSize, 5);
    }

    public ChangeSupport(int initialSize, int delta) {
        this.listeners = new Reference[initialSize];
        this.types = new ChangeType[initialSize];
        this.delta = delta;
    }

    public void addChangeListener(ChangeListener cl) {
        this.addChangeListener(cl, ChangeType.UNKNOWN);
    }

    public synchronized void addChangeListener(ChangeListener cl, ChangeType ct) {
        if (ct == null) {
            throw new NestedError("Since 1.2, listeners registered for the null changetype are not meaningful.  Please register a listener for ChangeType.UNKNOWN instead");
        }
        this.growIfNecessary();
        this.types[this.listenerCount] = ct;
        this.listeners[this.listenerCount] = new WeakReference<ChangeListener>(cl);
        ++this.listenerCount;
    }

    protected void growIfNecessary() {
        if (this.listenerCount == this.listeners.length) {
            int newLength = this.listenerCount + this.delta;
            Reference[] newList = new Reference[newLength];
            ChangeType[] newTypes = new ChangeType[newLength];
            System.arraycopy(this.listeners, 0, newList, 0, this.listenerCount);
            System.arraycopy(this.types, 0, newTypes, 0, this.listenerCount);
            this.listeners = newList;
            this.types = newTypes;
        }
    }

    public void removeChangeListener(ChangeListener cl) {
        this.removeChangeListener(cl, ChangeType.UNKNOWN);
    }

    public void removeChangeListener(ChangeListener cl, ChangeType ct) {
        int i = 0;
        while (i < this.listenerCount) {
            if (this.listeners[i].get() == cl && this.types[i] == ct) {
                --this.listenerCount;
                System.arraycopy(this.listeners, i + 1, this.listeners, i, this.listenerCount - i);
                System.arraycopy(this.types, i + 1, this.types, i, this.listenerCount - i);
                return;
            }
            ++i;
        }
    }

    protected void reapGarbageListeners() {
        int pp = 0;
        int p = 0;
        while (p < this.listenerCount) {
            Reference r = this.listeners[p];
            if (r.get() != null) {
                this.types[pp] = this.types[p];
                this.listeners[pp] = r;
                ++pp;
            }
            ++p;
        }
        this.listenerCount = pp;
    }

    public void firePreChangeEvent(ChangeEvent ce) throws ChangeVetoException {
        boolean needToReap = false;
        ChangeType ct = ce.getType();
        int listenerCount = this.listenerCount;
        ChangeType[] types = new ChangeType[listenerCount];
        System.arraycopy(this.types, 0, types, 0, listenerCount);
        Reference[] listeners = new Reference[listenerCount];
        System.arraycopy(this.listeners, 0, listeners, 0, listenerCount);
        int i = 0;
        while (i < listenerCount) {
            ChangeType lt = types[i];
            if (ct.isMatchingType(lt)) {
                ChangeListener cl = (ChangeListener)listeners[i].get();
                if (cl != null) {
                    cl.preChange(ce);
                } else {
                    needToReap = true;
                }
            }
            ++i;
        }
        if (needToReap) {
            this.reapGarbageListeners();
        }
    }

    public void firePostChangeEvent(ChangeEvent ce) {
        boolean needToReap = false;
        ChangeType ct = ce.getType();
        int listenerCount = this.listenerCount;
        ChangeType[] types = new ChangeType[listenerCount];
        System.arraycopy(this.types, 0, types, 0, listenerCount);
        Reference[] listeners = new Reference[listenerCount];
        System.arraycopy(this.listeners, 0, listeners, 0, listenerCount);
        int i = 0;
        while (i < listenerCount) {
            ChangeType lt = types[i];
            if (ct.isMatchingType(lt)) {
                ChangeListener cl = (ChangeListener)listeners[i].get();
                if (cl != null) {
                    cl.postChange(ce);
                } else {
                    needToReap = true;
                }
            }
            ++i;
        }
        if (needToReap) {
            this.reapGarbageListeners();
        }
    }
}

