/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils.query;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Iterator;
import org.biojava.utils.query.Filter;
import org.biojava.utils.query.Follow;
import org.biojava.utils.query.JavaType;
import org.biojava.utils.query.OperationException;
import org.biojava.utils.query.PermutedTuple;
import org.biojava.utils.query.QueryTools;
import org.biojava.utils.query.Queryable;
import org.biojava.utils.query.SimpleTuple;
import org.biojava.utils.query.Type;
import org.biojava.utils.query.TypeCastException;

public interface Tuple {
    public Object getObject(int var1);

    public TypeList getTypeList();

    public static class FollowMethod
    extends Follow {
        private final Method method;
        private final TypeList inputTypeList;
        private final TypeList outputTypeList;
        private final int indx;

        public Method getMethod() {
            return this.method;
        }

        public FollowMethod(Method method, TypeList typeList) {
            this.method = method;
            this.inputTypeList = typeList;
            Type methodType = JavaType.getType(method.getDeclaringClass());
            Type paramTypes = JavaType.getType(method.getParameterTypes());
            Type returnType = JavaType.getType(method.getReturnType());
            TypeList tl = paramTypes instanceof TypeList ? (TypeList)paramTypes : null;
            this.indx = typeList.size() - (tl == null ? 1 : tl.size());
            if (!methodType.isAssignableFrom(typeList.getType(this.indx - 1))) {
                throw new IllegalArgumentException("Can't apply " + method + " to " + methodType + " at index " + (this.indx - 1) + " in " + typeList);
            }
            if (tl == null) {
                if (!paramTypes.isAssignableFrom(typeList.getType(this.indx))) {
                    throw new TypeCastException("Illegal argument type in " + method + " at index " + this.indx + " in " + typeList);
                }
            } else {
                int i = this.indx;
                while (i < tl.size()) {
                    if (!tl.getType(i - this.indx).isAssignableFrom(typeList.getType(this.indx))) {
                        throw new TypeCastException("Illegal argument type in " + method + " at index " + i + " in " + typeList);
                    }
                    ++i;
                }
            }
            Type[] typeArray = new Type[this.indx];
            int i = 0;
            while (i < this.indx - 1) {
                typeArray[i] = typeList.getType(i);
                ++i;
            }
            typeArray[this.indx - 1] = returnType;
            this.outputTypeList = new SimpleTuple.TypeList(typeArray);
        }

        public Queryable follow(Object item) throws OperationException {
            Object val;
            Tuple tup = (Tuple)item;
            Object[] params = new Object[this.method.getParameterTypes().length];
            int i = 0;
            while (i < params.length) {
                params[i] = tup.getObject(i + this.indx);
                ++i;
            }
            try {
                val = this.method.invoke(tup.getObject(this.indx - 1), params);
            }
            catch (InvocationTargetException ite) {
                throw new OperationException(ite, "Couldn't invoke method " + this.method + " on " + tup.getObject(this.indx - 1));
            }
            catch (IllegalAccessException iae) {
                throw new OperationException(iae, "Couldn't access method" + this.method + " on " + tup.getObject(this.indx - 1));
            }
            catch (IllegalArgumentException iae) {
                throw new OperationException(iae, "Wrong arguments for\n\tmethod " + this.method + "\n\ton " + tup.getObject(this.indx - 1) + "\n\tin tuple of type " + tup.getTypeList() + "\n\ton tuple " + tup + "\n\twith index " + this.indx);
            }
            if (this.indx == 1) {
                return QueryTools.createSingleton(val);
            }
            Object[] items = new Object[this.indx];
            int i2 = 0;
            while (i2 < this.indx - 1) {
                items[i2] = tup.getObject(i2);
                ++i2;
            }
            items[this.indx - 1] = val;
            return QueryTools.createSingleton(new SimpleTuple(items, this.outputTypeList));
        }

        public Type getInputType() {
            return this.inputTypeList;
        }

        public Type getOutputType() {
            if (this.indx == 1) {
                return this.outputTypeList.getType(0);
            }
            return this.outputTypeList;
        }

        public int hashCode() {
            return this.method.hashCode() ^ this.getInputType().hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof FollowMethod) {
                FollowMethod that = (FollowMethod)o;
                return that.getInputType().equals(this.getInputType()) && that.getMethod().equals(this.getMethod());
            }
            return false;
        }

        public String toString() {
            return "Tuple.FollowMethod: " + this.method + " type: " + this.inputTypeList;
        }
    }

    public static class FollowTupleTo
    extends Follow {
        private final Follow follow;
        private final int indx;
        private final TypeList inputTypeList;
        private final TypeList outputTypeList;

        public Follow getFollow() {
            return this.follow;
        }

        public int getIndex() {
            return this.indx;
        }

        public FollowTupleTo(int indx, Follow follow, TypeList typeList) {
            this.indx = indx;
            this.follow = follow;
            this.inputTypeList = typeList;
            Type[] types = new Type[typeList.size()];
            int i = 0;
            while (i < types.length) {
                types[i] = i == indx ? follow.getOutputType() : typeList.getType(i);
                ++i;
            }
            this.outputTypeList = new SimpleTuple.TypeList(types);
        }

        public Queryable follow(Object item) throws OperationException {
            Tuple tup = (Tuple)item;
            if (!this.inputTypeList.isAssignableFrom(tup.getTypeList())) {
                throw new TypeCastException("Can't apply " + tup.getTypeList() + " to " + this.inputTypeList);
            }
            Queryable res = this.follow.follow(tup.getObject(this.indx));
            HashSet<SimpleTuple> items = new HashSet<SimpleTuple>();
            Iterator ri = res.iterator();
            while (ri.hasNext()) {
                Object o = ri.next();
                Object[] values = new Object[this.outputTypeList.size()];
                int i = 0;
                while (i < values.length) {
                    values[i] = i == this.indx ? o : tup.getObject(i);
                    ++i;
                }
                items.add(new SimpleTuple(values, this.outputTypeList));
            }
            return QueryTools.createQueryable(items, this.getOutputType());
        }

        public Type getInputType() {
            return this.inputTypeList;
        }

        public Type getOutputType() {
            return this.outputTypeList;
        }

        public int hashCode() {
            return this.follow.hashCode() ^ this.inputTypeList.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof FollowTupleTo) {
                FollowTupleTo that = (FollowTupleTo)o;
                return this.getFollow().equals(that.getFollow()) && this.getInputType().equals(that.getInputType()) && this.getIndex() == that.getIndex();
            }
            return false;
        }

        public String toString() {
            return "FollowTupleTo index: " + this.indx + " follow: " + this.follow;
        }
    }

    public static class FilterByIndex
    extends Filter {
        private final Filter filter;
        private final int indx;
        private final TypeList typeList;

        public Filter getFilter() {
            return this.filter;
        }

        public int getIndex() {
            return this.indx;
        }

        public FilterByIndex(Filter filter, int indx, TypeList typeList) {
            this.filter = filter;
            this.indx = indx;
            this.typeList = typeList;
        }

        public boolean accept(Object item) throws OperationException {
            Tuple tup = (Tuple)item;
            return this.filter.accept(tup.getObject(this.indx));
        }

        public Type getInputType() {
            return this.typeList;
        }

        public Type getOutputType() {
            return this.typeList;
        }

        public int hashCode() {
            return this.filter.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof FilterByIndex) {
                FilterByIndex that = (FilterByIndex)o;
                return that.indx == this.indx && that.filter.equals(this.filter);
            }
            return false;
        }

        public String toString() {
            return "Tuple.FilterByIndex[index=" + this.indx + " filter=" + this.filter + "]";
        }
    }

    public static class FollowToTuple
    extends Follow {
        private final Follow follow;
        private final TypeList typeList;

        public FollowToTuple(Follow follow) {
            this.follow = follow;
            this.typeList = new SimpleTuple.TypeList(new Type[]{follow.getInputType(), follow.getOutputType()});
        }

        public Queryable follow(Object item) throws OperationException {
            Queryable res = this.follow.follow(item);
            HashSet<SimpleTuple> items = new HashSet<SimpleTuple>();
            Iterator i = res.iterator();
            while (i.hasNext()) {
                Object o = i.next();
                items.add(new SimpleTuple(new Object[]{item, o}, this.typeList));
            }
            return QueryTools.createQueryable(items, this.getOutputType());
        }

        public Type getInputType() {
            return this.follow.getInputType();
        }

        public Type getOutputType() {
            return this.typeList;
        }
    }

    public static class Permutate
    extends Follow {
        private final int[] order;
        private final TypeList input;
        private final PermutedTuple.TypeList output;

        public Permutate(int[] order, TypeList inputTypeList) {
            this.order = order;
            this.input = inputTypeList;
            this.output = new PermutedTuple.TypeList(order, this.input);
        }

        public Queryable follow(Object item) {
            Tuple ti = (Tuple)item;
            return QueryTools.createSingleton(new PermutedTuple(ti, this.output));
        }

        public Type getInputType() {
            return this.input;
        }

        public Type getOutputType() {
            return this.output;
        }
    }

    public static class FollowObject
    extends Follow {
        private final int indx;
        private final TypeList typeList;

        public FollowObject(TypeList typeList, int indx) {
            this.typeList = typeList;
            this.indx = indx;
        }

        public Queryable follow(Object item) {
            Tuple ti = (Tuple)item;
            return QueryTools.createSingleton(ti.getObject(this.indx));
        }

        public Type getInputType() {
            return this.typeList;
        }

        public Type getOutputType() {
            return this.typeList.getType(this.indx);
        }

        public int getIndex() {
            return this.indx;
        }

        public TypeList getTypeList() {
            return this.typeList;
        }
    }

    public static abstract class TypeList
    implements Type {
        public abstract Type getType(int var1);

        public abstract int size();

        public boolean isInstance(Object obj) {
            if (obj instanceof Tuple) {
                Tuple tup = (Tuple)obj;
                return this.isAssignableFrom(tup.getTypeList());
            }
            return false;
        }

        public boolean isAssignableFrom(Type type) {
            if (type instanceof TypeList) {
                TypeList typeList = (TypeList)type;
                if (this.size() != typeList.size()) {
                    return false;
                }
                int i = 0;
                if (i < this.size()) {
                    return this.getType(i).equals(typeList.getType(i));
                }
            }
            return false;
        }

        public int hashCode() {
            int hc = this.getType(0).hashCode();
            int i = 1;
            while (i < this.size()) {
                hc ^= this.getType(i).hashCode();
                ++i;
            }
            return hc;
        }

        public boolean equals(Object o) {
            if (o instanceof TypeList) {
                TypeList tl = (TypeList)o;
                if (this.size() == tl.size()) {
                    int i = 0;
                    while (i < this.size()) {
                        if (this.getType(i) != tl.getType(i)) {
                            return false;
                        }
                        ++i;
                    }
                    return true;
                }
            }
            return false;
        }

        public String getName() {
            StringBuffer sb = new StringBuffer("(");
            sb.append(this.getType(0).toString());
            int i = 1;
            while (i < this.size()) {
                sb.append(",");
                sb.append(this.getType(i).toString());
                ++i;
            }
            sb.append(")");
            return sb.toString();
        }

        public String toString() {
            return this.getName();
        }
    }
}

