/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.tree;

import com.sun.xml.tree.AttributeNode;
import com.sun.xml.tree.AttributeSet;
import com.sun.xml.tree.DomEx;
import com.sun.xml.tree.ElementEx;
import com.sun.xml.tree.ParentNode;
import com.sun.xml.tree.TextNode;
import com.sun.xml.tree.XmlDocument;
import com.sun.xml.tree.XmlWriteContext;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Writer;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ElementNode
extends ParentNode
implements ElementEx {
    private String tag;
    private AttributeSet attributes;
    private String idAttributeName;
    private Object userObject;
    private static final char[] tagStart = new char[]{'<', '/'};
    private static final char[] tagEnd = new char[]{' ', '/', '>'};

    void checkChildType(int type) throws DOMException {
        switch (type) {
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                return;
            }
        }
        throw new DomEx(3);
    }

    public Node cloneNode(boolean deep) {
        try {
            ElementNode retval = (ElementNode)this.getOwnerDocument().createElement(this.tag);
            if (this.attributes != null) {
                retval.setAttributes(new AttributeSet(this.attributes, true));
            }
            if (deep) {
                Node node;
                int i = 0;
                while ((node = this.item(i)) != null) {
                    retval.appendChild(node.cloneNode(true));
                    ++i;
                }
            }
            return retval;
        }
        catch (DOMException dOMException) {
            throw new RuntimeException(this.getMessage("EN-001"));
        }
    }

    public String getAttribute(String name) {
        return this.attributes == null ? "" : this.attributes.getValue(name);
    }

    public String getAttribute(String uri, String name) {
        if (this.attributes == null) {
            return "";
        }
        Attr attr = this.getAttributeNode(uri, name);
        if (attr == null) {
            return "";
        }
        return attr.getValue();
    }

    public Attr getAttributeNode(String name) {
        if (this.attributes != null) {
            return (Attr)this.attributes.getNamedItem(name);
        }
        return null;
    }

    public Attr getAttributeNode(String uri, String name) {
        if (name == null) {
            return null;
        }
        if (this.attributes != null) {
            int i = 0;
            while (true) {
                String ns;
                AttributeNode attr;
                if ((attr = (AttributeNode)this.attributes.item(i)) == null) {
                    return null;
                }
                if (name.equals(attr.getName()) && (ns = attr.getNamespace()) != null && ns.equals(uri)) {
                    return attr;
                }
                ++i;
            }
        }
        return null;
    }

    public NamedNodeMap getAttributes() {
        if (this.attributes == null) {
            this.attributes = new AttributeSet(this);
        }
        return this.attributes;
    }

    public String getIdAttributeName() {
        return this.idAttributeName;
    }

    public String getLocalName() {
        int index = this.tag.indexOf(58);
        if (index < 0) {
            return this.tag;
        }
        return this.tag.substring(index + 1);
    }

    public String getNamespace() {
        int index = this.tag.indexOf(58);
        if (index < 0) {
            return this.getInheritedAttribute("xmlns");
        }
        String prefix = this.tag.substring(0, index);
        if ("xml".equals(prefix) || "xmlns".equals(prefix)) {
            return null;
        }
        String value = this.getInheritedAttribute("xmlns:" + prefix);
        if (value == null) {
            throw new IllegalStateException(this.getMessage("EN-000", new Object[]{prefix}));
        }
        return value;
    }

    public String getNodeName() {
        return this.tag;
    }

    public short getNodeType() {
        return 1;
    }

    public String getTagName() {
        return this.tag;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public void normalize() {
        Node node;
        boolean preserve = false;
        boolean knowPreserve = false;
        if (this.isReadonly()) {
            throw new DomEx(7);
        }
        int i = 0;
        while ((node = this.item(i)) != null) {
            switch (node.getNodeType()) {
                case 1: {
                    ((Element)node).normalize();
                    break;
                }
                case 3: {
                    Node node2 = this.item(i + 1);
                    if (node2 == null || node2.getNodeType() != 3) {
                        if (!knowPreserve) {
                            preserve = "preserve".equals(this.getInheritedAttribute("xml:space"));
                            knowPreserve = true;
                        }
                        if (preserve) break;
                        char[] buf = ((TextNode)node).data;
                        int current = 0;
                        int j = 0;
                        char c = buf[0];
                        while (j < buf.length) {
                            boolean sawSpace = false;
                            buf[current++] = c;
                            while (++j < buf.length) {
                                c = buf[j];
                                if (c != ' ' && c != '\t' && c != '\n' && c != '\r') break;
                                sawSpace = true;
                            }
                            if (!sawSpace) continue;
                            buf[current++] = 32;
                        }
                        if (current == 0) {
                            this.removeChild(node);
                            --i;
                            break;
                        }
                        if (current == buf.length) break;
                        char[] tmp = new char[current];
                        System.arraycopy(buf, 0, tmp, 0, current);
                        ((TextNode)node).data = tmp;
                        break;
                    }
                    ((TextNode)node).joinNextText();
                    --i;
                    break;
                }
            }
            ++i;
        }
    }

    public void removeAttribute(String name) throws DOMException {
        if (this.isReadonly()) {
            throw new DomEx(7);
        }
        if (this.attributes != null) {
            this.attributes.removeNamedItem(name);
        }
    }

    public Attr removeAttributeNode(Attr oldAttr) throws DOMException {
        Attr attr = this.getAttributeNode(oldAttr.getNodeName());
        if (this.isReadonly()) {
            throw new DomEx(7);
        }
        if (attr == null) {
            throw new DomEx(8);
        }
        this.removeAttribute(attr.getNodeName());
        return attr;
    }

    public void setAttribute(String name, String value) throws DOMException {
        AttributeNode att;
        if (this.isReadonly()) {
            throw new DomEx(7);
        }
        if (this.attributes == null) {
            this.attributes = new AttributeSet(this);
        }
        if ((att = (AttributeNode)this.attributes.getNamedItem(name)) != null) {
            att.setNodeValue(value);
        } else {
            att = new AttributeNode(name, value, true, null);
            att.setOwnerDocument((XmlDocument)this.getOwnerDocument());
            this.attributes.setNamedItem(att);
        }
    }

    public Attr setAttributeNode(Attr newAttr) throws DOMException {
        if (this.isReadonly()) {
            throw new DomEx(7);
        }
        if (!(newAttr instanceof AttributeNode)) {
            throw new DomEx(4);
        }
        if (this.attributes == null) {
            this.attributes = new AttributeSet(this);
        }
        this.attributes.setNamedItem(newAttr);
        return newAttr;
    }

    void setAttributes(AttributeSet a) {
        AttributeSet oldAtts = this.attributes;
        if (a != null) {
            a.setNameScope(this);
        }
        this.attributes = a;
        if (oldAtts != null) {
            oldAtts.setNameScope(null);
        }
    }

    public void setIdAttributeName(String attName) {
        if (this.isReadonly()) {
            throw new DomEx(7);
        }
        this.idAttributeName = attName;
    }

    void setReadonly(boolean deep) {
        if (this.attributes != null) {
            this.attributes.setReadonly();
        }
        super.setReadonly(deep);
    }

    protected void setTag(String t) {
        this.tag = t;
    }

    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    public String toString() {
        try {
            CharArrayWriter out = new CharArrayWriter();
            XmlWriteContext x = new XmlWriteContext(out);
            this.writeXml(x);
            return out.toString();
        }
        catch (Exception exception) {
            return super.toString();
        }
    }

    public void trimToSize() {
        super.trimToSize();
        if (this.attributes != null) {
            this.attributes.trimToSize();
        }
    }

    public void write(Writer out) throws IOException {
        this.writeXml(new XmlWriteContext(out));
    }

    public void writeXml(XmlWriteContext context) throws IOException {
        Writer out = context.getWriter();
        if (this.tag == null) {
            throw new IllegalStateException(this.getMessage("EN-002"));
        }
        out.write(tagStart, 0, 1);
        out.write(this.tag);
        if (this.attributes != null) {
            this.attributes.writeXml(context);
        }
        if (!this.hasChildNodes()) {
            out.write(tagEnd, 0, 3);
        } else {
            out.write(tagEnd, 2, 1);
            this.writeChildrenXml(context);
            out.write(tagStart, 0, 2);
            out.write(this.tag);
            out.write(tagEnd, 2, 1);
        }
    }
}

