/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.tree;

import com.sun.xml.tree.NodeBase;
import com.sun.xml.tree.XmlWriteContext;
import java.io.IOException;
import java.io.Writer;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;

final class PINode
extends NodeBase
implements ProcessingInstruction {
    private String target;
    private char[] data;

    public PINode() {
    }

    public PINode(String target, String text) {
        this.data = text.toCharArray();
        this.target = target;
    }

    PINode(String target, char[] buf, int offset, int len) {
        this.data = new char[len];
        System.arraycopy(buf, offset, this.data, 0, len);
        this.target = target;
    }

    public Node cloneNode(boolean deep) {
        return new PINode(this.target, this.data, 0, this.data.length);
    }

    public String getData() {
        return new String(this.data);
    }

    public String getNodeName() {
        return this.target;
    }

    public short getNodeType() {
        return 7;
    }

    public String getNodeValue() {
        return this.getData();
    }

    public String getTarget() {
        return this.target;
    }

    public void setData(String data) {
        this.data = data.toCharArray();
    }

    public void setNodeValue(String data) {
        this.setData(data);
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public void writeXml(XmlWriteContext context) throws IOException {
        Writer out = context.getWriter();
        out.write("<?");
        out.write(this.target);
        if (this.data != null) {
            out.write(32);
            out.write(this.data);
        }
        out.write("?>");
    }
}

