/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.tree;

import com.sun.xml.tree.DomEx;
import com.sun.xml.tree.NodeBase;
import com.sun.xml.tree.NodeEx;
import com.sun.xml.tree.ParseContext;
import com.sun.xml.tree.TreeWalker;
import com.sun.xml.tree.XmlDocument;
import com.sun.xml.tree.XmlReadable;
import com.sun.xml.tree.XmlWriteContext;
import java.io.IOException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

abstract class ParentNode
extends NodeBase
implements XmlReadable {
    private NodeBase[] children;
    private int length;

    ParentNode() {
    }

    public Node appendChild(Node newChild) throws DOMException {
        if (this.isReadonly()) {
            throw new DomEx(7);
        }
        NodeBase child = this.checkDocument(newChild);
        if (newChild.getNodeType() == 11) {
            this.consumeFragment(newChild, null);
            return newChild;
        }
        this.checkNotAncestor(newChild);
        this.checkChildType(child.getNodeType());
        if (this.children == null) {
            this.children = new NodeBase[3];
        } else if (this.children.length == this.length) {
            NodeBase[] temp = new NodeBase[this.length * 2];
            System.arraycopy(this.children, 0, temp, 0, this.length);
            this.children = temp;
        }
        child.setParentNode(this, this.length);
        this.children[this.length++] = child;
        this.mutated();
        return child;
    }

    abstract void checkChildType(int var1) throws DOMException;

    private NodeBase checkDocument(Node newChild) throws DOMException {
        if (newChild == null) {
            throw new DomEx(3);
        }
        if (!(newChild instanceof NodeBase)) {
            throw new DomEx(4);
        }
        Document owner = newChild.getOwnerDocument();
        Document myOwner = this.getOwnerDocument();
        NodeBase child = (NodeBase)newChild;
        if (myOwner == null && this instanceof Document) {
            myOwner = (Document)((Object)this);
        }
        if (owner == null) {
            child.setOwnerDocument((XmlDocument)myOwner);
            return child;
        }
        if (owner != myOwner) {
            throw new DomEx(4);
        }
        return child;
    }

    private void checkNotAncestor(Node newChild) throws DOMException {
        if (!newChild.hasChildNodes()) {
            return;
        }
        Node ancestor = this;
        while (ancestor != null) {
            if (newChild == ancestor) {
                throw new DomEx(3);
            }
            ancestor = ancestor.getParentNode();
        }
    }

    private void consumeFragment(Node fragment, Node before) throws DOMException {
        Node temp;
        ParentNode frag = (ParentNode)fragment;
        int i = 0;
        while ((temp = frag.item(i)) != null) {
            this.checkNotAncestor(temp);
            this.checkChildType(temp.getNodeType());
            ++i;
        }
        while ((temp = frag.item(0)) != null) {
            this.insertBefore(temp, before);
        }
    }

    public void doneChild(NodeEx child, ParseContext context) throws SAXException {
    }

    public void doneParse(ParseContext context) throws SAXException {
    }

    public NodeList getElementsByTagName(String tagname) {
        if ("*".equals(tagname)) {
            tagname = null;
        }
        return new TagList(tagname);
    }

    public final Node getFirstChild() {
        if (this.length == 0) {
            return null;
        }
        return this.children[0];
    }

    public final int getIndexOf(Node maybeChild) {
        int i = 0;
        while (i < this.length) {
            if (this.children[i] == maybeChild) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public final Node getLastChild() {
        if (this.length == 0) {
            return null;
        }
        return this.children[this.length - 1];
    }

    public final int getLength() {
        return this.length;
    }

    public final boolean hasChildNodes() {
        return this.length > 0;
    }

    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        if (this.isReadonly()) {
            throw new DomEx(7);
        }
        if (refChild == null) {
            return this.appendChild(newChild);
        }
        if (this.length == 0) {
            throw new DomEx(8);
        }
        NodeBase child = this.checkDocument(newChild);
        if (newChild.getNodeType() == 11) {
            this.consumeFragment(newChild, refChild);
            return newChild;
        }
        this.checkNotAncestor(newChild);
        this.checkChildType(newChild.getNodeType());
        if (this.children.length == this.length) {
            NodeBase[] temp = new NodeBase[this.length * 2];
            System.arraycopy(this.children, 0, temp, 0, this.length);
            this.children = temp;
        }
        int i = 0;
        while (i < this.length) {
            if (this.children[i] == refChild) {
                child.setParentNode(this, i);
                System.arraycopy(this.children, i, this.children, i + 1, this.length - i);
                this.children[i] = child;
                ++this.length;
                this.mutated();
                return newChild;
            }
            ++i;
        }
        throw new DomEx(8);
    }

    public final Node item(int i) {
        if (this.length == 0 || i >= this.length) {
            return null;
        }
        try {
            return this.children[i];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    private void mutated() {
        XmlDocument doc = (XmlDocument)this.getOwnerDocument();
        if (doc == null && this instanceof XmlDocument) {
            doc = (XmlDocument)this;
        }
        if (doc != null) {
            ++doc.mutationCount;
        }
    }

    void reduceWaste() {
        if (this.children == null) {
            return;
        }
        if (this.children.length - this.length > 6) {
            this.trimToSize();
        }
    }

    public Node removeChild(Node oldChild) throws DOMException {
        if (this.isReadonly()) {
            throw new DomEx(7);
        }
        if (!(oldChild instanceof NodeBase)) {
            throw new DomEx(8);
        }
        NodeBase child = (NodeBase)oldChild;
        int i = 0;
        while (i < this.length) {
            if (this.children[i] == child) {
                if (i + 1 != this.length) {
                    System.arraycopy(this.children, i + 1, this.children, i, this.length - 1 - i);
                }
                --this.length;
                this.children[this.length] = null;
                child.setParentNode(null, -1);
                this.mutated();
                return oldChild;
            }
            ++i;
        }
        throw new DomEx(8);
    }

    public Node replaceChild(Node newChild, Node refChild) throws DOMException {
        if (this.isReadonly()) {
            throw new DomEx(7);
        }
        if (newChild == null || this.children == null || refChild == null) {
            throw new DomEx(3);
        }
        NodeBase child = this.checkDocument(newChild);
        if (newChild.getNodeType() == 11) {
            this.consumeFragment(newChild, refChild);
            return this.removeChild(newChild);
        }
        this.checkNotAncestor(newChild);
        this.checkChildType(newChild.getNodeType());
        int i = 0;
        while (i < this.length) {
            if (this.children[i] == refChild) {
                child.setParentNode(this, i);
                this.children[i] = child;
                ((NodeBase)refChild).setParentNode(null, -1);
                this.mutated();
                return refChild;
            }
            ++i;
        }
        throw new DomEx(8);
    }

    public void startParse(ParseContext context) throws SAXException {
    }

    public void trimToSize() {
        if (this.length == 0) {
            this.children = null;
        } else if (this.children.length != this.length) {
            NodeBase[] temp = new NodeBase[this.length];
            System.arraycopy(this.children, 0, temp, 0, this.length);
            this.children = temp;
        }
    }

    public void writeChildrenXml(XmlWriteContext context) throws IOException {
        if (this.children == null) {
            return;
        }
        int oldIndent = 0;
        boolean preserve = true;
        boolean pureText = true;
        if (this.getNodeType() == 1) {
            preserve = "preserve".equals(this.getInheritedAttribute("xml:space"));
            oldIndent = context.getIndentLevel();
        }
        try {
            if (!preserve) {
                context.setIndentLevel(oldIndent + 2);
            }
            int i = 0;
            while (i < this.length) {
                if (!preserve && this.children[i].getNodeType() != 3) {
                    context.printIndent();
                    pureText = false;
                }
                this.children[i].writeXml(context);
                ++i;
            }
        }
        finally {
            Object var6_6 = null;
            if (!preserve) {
                context.setIndentLevel(oldIndent);
                if (!pureText) {
                    context.printIndent();
                }
            }
        }
    }

    class TagList
    implements NodeList {
        private String tag;
        private int lastMutationCount;
        private int lastIndex;
        private TreeWalker lastWalker;

        TagList(String tag) {
            this.tag = tag;
        }

        private int getLastMutationCount() {
            XmlDocument doc = (XmlDocument)ParentNode.this.getOwnerDocument();
            return doc == null ? 0 : doc.mutationCount;
        }

        public int getLength() {
            TreeWalker walker = new TreeWalker(ParentNode.this);
            Element node = null;
            int retval = 0;
            while ((node = walker.getNextElement(this.tag)) != null) {
                ++retval;
            }
            return retval;
        }

        public Node item(int i) {
            if (i < 0) {
                return null;
            }
            int temp = this.getLastMutationCount();
            if (this.lastWalker != null && (i < this.lastIndex || temp != this.lastMutationCount)) {
                this.lastWalker = null;
            }
            if (this.lastWalker == null) {
                this.lastWalker = new TreeWalker(ParentNode.this);
                this.lastIndex = -1;
                this.lastMutationCount = temp;
            }
            if (i == this.lastIndex) {
                return this.lastWalker.getCurrent();
            }
            Element node = null;
            while (i > this.lastIndex && (node = this.lastWalker.getNextElement(this.tag)) != null) {
                ++this.lastIndex;
            }
            return node;
        }
    }
}

