/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.tree;

import com.sun.xml.tree.ElementEx;
import com.sun.xml.tree.ElementFactory;
import com.sun.xml.tree.ElementNode;
import com.sun.xml.tree.XmlDocument;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Locale;

public class SimpleElementFactory
implements ElementFactory {
    private Dictionary defaultMapping;
    private ClassLoader defaultLoader;
    private String defaultNs;
    private Dictionary nsMappings;
    private Dictionary nsLoaders;
    private Locale locale = Locale.getDefault();
    static /* synthetic */ Class class$com$sun$xml$tree$ElementNode;

    public void addMapping(String namespace, Dictionary dict, ClassLoader loader) {
        if (namespace == null || dict == null) {
            throw new IllegalArgumentException();
        }
        if (this.nsMappings == null) {
            this.nsMappings = new Hashtable();
            this.nsLoaders = new Hashtable();
        }
        this.nsMappings.put(namespace, dict);
        if (loader != null) {
            this.nsLoaders.put(namespace, loader);
        }
    }

    public void addMapping(Dictionary dict, ClassLoader loader) {
        if (dict == null) {
            throw new IllegalArgumentException();
        }
        this.defaultMapping = dict;
        this.defaultLoader = loader;
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public ElementEx createElementEx(String tag) {
        return this.doMap(tag, this.defaultMapping, this.defaultLoader);
    }

    public ElementEx createElementEx(String namespace, String tag) {
        Dictionary mapping = null;
        if (namespace == null) {
            namespace = this.defaultNs;
        }
        if (this.nsMappings != null) {
            mapping = (Dictionary)this.nsMappings.get(namespace);
        }
        if (mapping == null) {
            return this.doMap(tag, this.defaultMapping, this.defaultLoader);
        }
        return this.doMap(tag, mapping, (ClassLoader)this.nsLoaders.get(namespace));
    }

    private ElementNode doMap(String tagName, Dictionary node2class, ClassLoader loader) {
        ElementNode retval;
        Class theClass = this.map2Class(tagName, node2class, loader);
        if (theClass == null) {
            theClass = this.map2Class("*Element", node2class, loader);
        }
        if (theClass == null) {
            retval = new ElementNode();
        } else {
            try {
                retval = (ElementNode)theClass.newInstance();
            }
            catch (Exception e) {
                throw new IllegalArgumentException(this.getMessage("SEF-003", new Object[]{tagName, theClass.getName(), e.getMessage()}));
            }
        }
        return retval;
    }

    String getMessage(String messageId) {
        return this.getMessage(messageId, null);
    }

    String getMessage(String messageId, Object[] parameters) {
        return XmlDocument.catalog.getMessage(this.locale, messageId, parameters);
    }

    private Class map2Class(String key, Dictionary node2class, ClassLoader loader) {
        Object mapResult = node2class.get(key);
        if (mapResult instanceof Class) {
            return (Class)mapResult;
        }
        if (mapResult == null) {
            return null;
        }
        if (mapResult instanceof String) {
            String className = (String)mapResult;
            try {
                Class<?> retval = loader == null ? Class.forName(className) : loader.loadClass(className);
                if (!(class$com$sun$xml$tree$ElementNode != null ? class$com$sun$xml$tree$ElementNode : (class$com$sun$xml$tree$ElementNode = SimpleElementFactory.class$("com.sun.xml.tree.ElementNode"))).isAssignableFrom(retval)) {
                    throw new IllegalArgumentException(this.getMessage("SEF-000", new Object[]{key, className}));
                }
                node2class.put(key, retval);
                return retval;
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(this.getMessage("SEF-001", new Object[]{key, className, e.getMessage()}));
            }
        }
        throw new IllegalArgumentException(this.getMessage("SEF-002", new Object[]{key}));
    }

    public void setDefaultNamespace(String ns) {
        this.defaultNs = ns;
    }
}

