/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.tree;

import com.sun.xml.tree.NodeBase;
import com.sun.xml.tree.XmlDocument;
import java.util.Locale;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TreeWalker {
    private Node startPoint;
    private Node current;

    public TreeWalker(Node initial) {
        if (!(initial instanceof NodeBase)) {
            throw new IllegalArgumentException(XmlDocument.catalog.getMessage(Locale.getDefault(), "TW-003"));
        }
        this.startPoint = this.current = initial;
    }

    public Node getCurrent() {
        return this.current;
    }

    public Node getNext() {
        if (this.current == null) {
            return null;
        }
        switch (this.current.getNodeType()) {
            case 1: 
            case 9: 
            case 11: {
                Node next = this.current.getFirstChild();
                if (next != null) {
                    this.current = next;
                    return next;
                }
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                Node next;
                Node here = this.current;
                while (here != null && here != this.startPoint) {
                    next = here.getNextSibling();
                    if (next != null) {
                        this.current = next;
                        return next;
                    }
                    here = here.getParentNode();
                }
                this.current = null;
                return null;
            }
        }
        throw new InternalError(((NodeBase)this.startPoint).getMessage("TW-000", new Object[]{Short.toString(this.current.getNodeType())}));
    }

    public Element getNextElement(String tag) {
        Node next = this.getNext();
        while (next != null) {
            if (next.getNodeType() == 1 && (tag == null || tag.equals(next.getNodeName()))) {
                return (Element)next;
            }
            next = this.getNext();
        }
        this.current = null;
        return null;
    }

    public Node removeCurrent() {
        if (this.current == null) {
            throw new IllegalStateException(((NodeBase)this.startPoint).getMessage("TW-001"));
        }
        Node toRemove = this.current;
        Node parent = this.current.getParentNode();
        if (parent == null) {
            throw new IllegalStateException(((NodeBase)this.startPoint).getMessage("TW-002"));
        }
        Node node = parent;
        synchronized (node) {
            Node retval = this.getNext();
            parent.removeChild(toRemove);
            Node node2 = retval;
            Object var6_6 = null;
            return node2;
        }
    }

    public void reset() {
        this.current = this.startPoint;
    }
}

