/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.tree;

import java.io.IOException;
import java.io.Writer;

public class XmlWriteContext {
    private Writer writer;
    private int indentLevel;
    private boolean prettyOutput;

    public XmlWriteContext(Writer out) {
        this.writer = out;
    }

    public XmlWriteContext(Writer out, int level) {
        this.writer = out;
        this.prettyOutput = true;
        this.indentLevel = level;
    }

    public int getIndentLevel() {
        return this.indentLevel;
    }

    public Writer getWriter() {
        return this.writer;
    }

    public boolean isEntityDeclared(String name) {
        return "amp".equals(name) || "lt".equals(name) || "gt".equals(name) || "quot".equals(name) || "apos".equals(name);
    }

    public boolean isPrettyOutput() {
        return this.prettyOutput;
    }

    public void printIndent() throws IOException {
        int temp = this.indentLevel;
        if (!this.prettyOutput) {
            return;
        }
        this.writer.write(10);
        while (temp >= 8) {
            this.writer.write(9);
            temp -= 8;
        }
        while (temp-- > 0) {
            this.writer.write(32);
        }
    }

    public void setIndentLevel(int level) {
        this.indentLevel = level;
    }
}

