/*
 *
 * b o o l e a n . c			-- Booleans and Equivalence predicates
 *
 * Copyright (C) 1993,1994,1995 Erick Gallesio - I3S-CNRS/ESSI <eg@unice.fr>
 * 
 *
 * Permission to use, copy, and/or distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that both the above copyright notice and this permission notice appear in
 * all copies and derived works.  Fees for distribution or use of this
 * software or derived works may only be charged with express written
 * permission of the copyright holder.  
 * This software is provided ``as is'' without express or implied warranty.
 *
 * This software is a derivative work of other copyrighted softwares; the
 * copyright notices of these softwares are placed in the file COPYRIGHTS
 *
 *
 *           Author: Erick Gallesio [eg@kaolin.unice.fr]
 *    Creation date: 23-Oct-1993 21:37
 * Last file update: 29-Jan-1995 16:28
 */

#include "stk.h"

PRIMITIVE STk_not(SCM x)
{
  return EQ(x, Ntruth) ? Truth : Ntruth;
}

PRIMITIVE STk_booleanp(SCM x)
{
  return BOOLEANP(x) ? Truth: Ntruth;
}

PRIMITIVE STk_eqv(SCM x, SCM y)
{
  if EQ(x,y) return(Truth);
  if (SYMBOLP(x) && SYMBOLP(y) && strcmp(PNAME(x), PNAME(y)) == 0)
    return Truth;
  if (NUMBERP(x) && NUMBERP(y)) {
    if ((EXACTP(x) && FLONUMP(y)) || (FLONUMP(x) && EXACTP(y))) return Ntruth;
    return (STk_equal_numbers(x,  y)) ? Truth : Ntruth;
  }
#ifndef COMPACT_SMALL_CST
  if (CHARP(x) && CHARP(y) && CHAR(x) == CHAR(y))
    return Truth;
#endif
  if (KEYWORDP(x)&&KEYWORDP(y)&&strcmp(KEYVAL(x), KEYVAL(y)) == 0)
    return Truth;
  /* What can we do else? */
  return Ntruth;
}

PRIMITIVE STk_eq(SCM x,SCM y)
{
  return EQ(x,y) ? Truth : Ntruth;
}

PRIMITIVE STk_equal(SCM x, SCM y)
{
Top:
  if (STk_eqv(x, y) == Truth) return Truth;
  switch (TYPE(x)) {
    case tc_cons:   if (CONSP(y)) {
      		      if (STk_equal(CAR(x), CAR(y)) == Ntruth) return Ntruth;
		      x = CDR(x); y = CDR(y);
		      goto Top;
		    }
		    break;
    case tc_string: if (STRINGP(y)) 
                      return (strcmp(CHARS(x), CHARS(y))==0) ? Truth: Ntruth;
                    break;
    case tc_vector: if (VECTORP(y)) 
                      return STk_equal(STk_vector2list(x), STk_vector2list(y));
  }
  return Ntruth;
}


