/* ==== syscall.S ============================================================
 * Copyright (c) 1993 by Chris Provenzano, proven@mit.edu
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *  This product includes software developed by Chris Provenzano.
 * 4. The name of Chris Provenzano may not be used to endorse or promote 
 *	  products derived from this software without specific prior written
 *	  permission.
 *
 * THIS SOFTWARE IS PROVIDED BY CHRIS PROVENZANO ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL CHRIS PROVENZANO BE LIABLE FOR ANY 
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT 
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF 
 * SUCH DAMAGE.
 *
 * Description : Machine dependent syscalls for decstation with r2000/r3000
 *
 *  1.00 93/08/14 proven
 *      -Started coding this file.
 */

	.text
    .ascii "$Id: syscall-r2000-ultrix-4.2.S,v 1.50 94/08/08 03:43:24 proven Exp $";

#include <syscall.h>
#include <machine/regdef.h>

/*
 * Initial asm stuff for all functions.
 */
	.text
	.align	2

/* ==========================================================================
 * error code for all syscalls. The error value is returned as the negative
 * of the errno value. Eventually I want to load the errno value directly
 * into pthread_run->error but until then ...
 */
machdep_error:
	negu v0, v0				/* Return negative of errno value. */
	j ra

/* ==========================================================================
 * Syscalls already done,
 * Standard		 		Other important		BSD sockets
 * fork 		=   2	select		=  93	socket		=  97
 * read 		=   3	readv		= 120	connect		=  98
 * write 		=   4	writev		= 121	accept		=  99
 * open			= 	5   getdirentries =     send		= 101
 * close		=   6						recv		= 102
 * creat		=	8						bind		= 104
 * link			=   9						listen		= 106
 * unlink		=  10						recvmsg		= 113
 * chdir		=  12						sendmsg		= 114
 * chmod		=  15						getsockopt  = 118
 * chown		=  16						recvfrom    = 125
 * lseek  		=  19						sendto		= 133
 * stat			=  38						shutdown	= 134
 * dup 			=  41						getpeername = 141
 * pipe 		=  42  					
 * execve		=  59  				
 * fstat 		=  62		
 * wait3		=  84	
 * dup2			=  90
 * fcntl		=  92
 * fchown		= 123
 * fchmod		= 124
 * rename		= 128
 * waitpid		= 189
 * ======================================================================= */

/* ==========================================================================
 * machdep_sys_fork()
 */
	.globl	machdep_sys_fork
	.ent	machdep_sys_fork

machdep_sys_fork:

	.frame	sp,0,ra				/* No frame, return address in ra */

	li v0,SYS_fork				/* Load fork syscall # into v0 */
	syscall					
	bne a3,zero,machdep_error	/* Error if a3 != 0 */
	beqz v1,__fork_parent		/* Second return value = 0, if parent */
	li v0,0
__fork_parent:
	j ra

	.end	machdep_sys_fork

/* ==========================================================================
 * machdep_sys_read()
 */
	.globl	machdep_sys_read
	.ent	machdep_sys_read

machdep_sys_read:

	.frame	sp,0,ra				/* No frame, return address in ra */

	li v0,SYS_read				/* Load read syscall # into v0 */
	syscall					
	bne a3,zero,machdep_error	/* Error if a3 != 0 */
	j ra

	.end	machdep_sys_read

/* ==========================================================================
 * machdep_sys_write()
 */
	.globl	machdep_sys_write
	.ent	machdep_sys_write

machdep_sys_write:

	.frame	sp,0,ra				/* No frame, return address in ra */

	li v0,SYS_write				/* Load write syscall # into v0 */
	syscall
	bne a3,zero,machdep_error	/* Error if a3 != 0 */
	j ra

	.end	machdep_sys_write

/* ==========================================================================
 * machdep_sys_open()
 */
	.globl	machdep_sys_open
	.ent	machdep_sys_open

machdep_sys_open:

	.frame	sp,0,ra				/* No frame, return address in ra */

	li v0,SYS_open				/* Load open syscall # into v0 */
	syscall					
	bne a3,zero,machdep_error	/* Error if a3 != 0 */
	j ra

	.end	machdep_sys_open

/* ==========================================================================
 * machdep_sys_close()
 */
	.globl	machdep_sys_close
	.ent	machdep_sys_close

machdep_sys_close:

	.frame	sp,0,ra				/* No frame, return address in ra */

	li v0,SYS_close				/* Load close syscall # into v0 */
	syscall					
	bne a3,zero,machdep_error	/* Error if a3 != 0 */
	j ra

	.end	machdep_sys_close

/* ==========================================================================
 * machdep_sys_creat()
 */
	.globl	machdep_sys_creat
	.ent	machdep_sys_creat

machdep_sys_creat:

	.frame	sp,0,ra				/* No frame, return address in ra */

	li v0,SYS_creat				/* Load creat syscall # into v0 */
	syscall					
	bne a3,zero,machdep_error	/* Error if a3 != 0 */
	j ra

	.end	machdep_sys_creat

/* ==========================================================================
 * machdep_sys_link()
 */
	.globl	machdep_sys_link
	.ent	machdep_sys_link

machdep_sys_link:

	.frame	sp,0,ra				/* No frame, return address in ra */

	li v0,SYS_link				/* Load link syscall # into v0 */
	syscall					
	bne a3,zero,machdep_error	/* Error if a3 != 0 */
	j ra

	.end	machdep_sys_link

/* ==========================================================================
 * machdep_sys_unlink()
 */
	.globl	machdep_sys_unlink
	.ent	machdep_sys_unlink

machdep_sys_unlink:

	.frame	sp,0,ra				/* No frame, return address in ra */

	li v0,SYS_unlink			/* Load unlink syscall # into v0 */
	syscall					
	bne a3,zero,machdep_error	/* Error if a3 != 0 */
	j ra

	.end	machdep_sys_unlink

/* ==========================================================================
 * machdep_sys_chdir()
 */
	.globl	machdep_sys_chdir
	.ent	machdep_sys_chdir

machdep_sys_chdir:

	.frame	sp,0,ra				/* No frame, return address in ra */

	li v0,SYS_chdir				/* Load chdir syscall # into v0 */
	syscall					
	bne a3,zero,machdep_error	/* Error if a3 != 0 */
	j ra

	.end	machdep_sys_chdir

/* ==========================================================================
 * machdep_sys_chmod()
 */
	.globl	machdep_sys_chmod
	.ent	machdep_sys_chmod

machdep_sys_chmod:

	.frame	sp,0,ra				/* No frame, return address in ra */

	li v0,SYS_chmod				/* Load chmod syscall # into v0 */
	syscall					
	bne a3,zero,machdep_error	/* Error if a3 != 0 */
	j ra

	.end	machdep_sys_chmod

/* ==========================================================================
 * machdep_sys_chown()
 */
	.globl	machdep_sys_chown
	.ent	machdep_sys_chown

machdep_sys_chown:

	.frame	sp,0,ra				/* No frame, return address in ra */

	li v0,SYS_chown				/* Load chown syscall # into v0 */
	syscall					
	bne a3,zero,machdep_error	/* Error if a3 != 0 */
	j ra

	.end	machdep_sys_chown

/* ==========================================================================
 * machdep_sys_lseek()
 */
	.globl	machdep_sys_lseek
	.ent	machdep_sys_lseek

machdep_sys_lseek:

	.frame	sp,0,ra				/* No frame, return address in ra */

	li v0,SYS_lseek				/* Load lseek syscall # into v0 */
	syscall					
	bne a3,zero,machdep_error	/* Error if a3 != 0 */
	j ra

	.end	machdep_sys_lseek

/* ==========================================================================
 * machdep_sys_stat()
 */
	.globl	machdep_sys_stat
	.ent	machdep_sys_stat

machdep_sys_stat:

	.frame	sp,0,ra				/* No frame, return address in ra */

	li v0,SYS_stat				/* Load stat syscall # into v0 */
	syscall					
	bne a3,zero,machdep_error	/* Error if a3 != 0 */
	j ra

	.end	machdep_sys_stat

/* ==========================================================================
 * machdep_sys_dup()
 */
	.globl	machdep_sys_dup
	.ent	machdep_sys_dup

machdep_sys_dup:

	.frame	sp,0,ra				/* No frame, return address in ra */

	li v0,SYS_dup				/* Load dup syscall # into v0 */
	syscall					
	bne a3,zero,machdep_error	/* Error if a3 != 0 */
	j ra

	.end	machdep_sys_dup

/* ==========================================================================
 * machdep_sys_pipe()
 */
	.globl	machdep_sys_pipe
	.ent	machdep_sys_pipe

machdep_sys_pipe:

	.frame	sp,0,ra				/* No frame, return address in ra */

	li v0,SYS_pipe				/* Load pipe syscall # into v0 */
	syscall					
	bne a3,zero,machdep_error	/* Error if a3 != 0 */
	sw v0, 0(a0)
	sw v1, 4(a0)
	li v0, 0
	j ra

	.end	machdep_sys_pipe

/* ==========================================================================
 * machdep_sys_execve()
 */
	.globl	machdep_sys_execve
	.ent	machdep_sys_execve

machdep_sys_execve:

	.frame	sp,0,ra				/* No frame, return address in ra */

	li v0,SYS_execve			/* Load execve syscall # into v0 */
	syscall					
	bne a3,zero,machdep_error	/* Error if a3 != 0 */
	j ra

	.end	machdep_sys_execve

/* ==========================================================================
 * machdep_sys_fstat()
 */
	.globl	machdep_sys_fstat
	.ent	machdep_sys_fstat

machdep_sys_fstat:

	.frame	sp,0,ra				/* No frame, return address in ra */

	li v0,SYS_fstat				/* Load fstat syscall # into v0 */
	syscall					
	bne a3,zero,machdep_error	/* Error if a3 != 0 */
	j ra

	.end	machdep_sys_fstat

/* ==========================================================================
 * machdep_sys_wait3()
 */
	.globl	machdep_sys_wait3
	.ent	machdep_sys_wait3

machdep_sys_wait3:

	.frame	sp,0,ra				/* No frame, return address in ra */

	li v0,SYS_wait3				/* Load wait3 syscall # into v0 */
	syscall					
	bne a3,zero,machdep_error	/* Error if a3 != 0 */
	j ra

	.end	machdep_sys_wait3

/* ==========================================================================
 * machdep_sys_dup2()
 */
	.globl	machdep_sys_dup2
	.ent	machdep_sys_dup2

machdep_sys_dup2:

	.frame	sp,0,ra				/* No frame, return address in ra */

	li v0,SYS_dup2				/* Load dup2 syscall # into v0 */
	syscall					
	bne a3,zero,machdep_error	/* Error if a3 != 0 */
	j ra

	.end	machdep_sys_dup2

/* ==========================================================================
 * machdep_sys_fcntl()
 */
	.globl	machdep_sys_fcntl
	.ent	machdep_sys_fcntl

machdep_sys_fcntl:

	.frame	sp,0,ra				/* No frame, return address in ra */

	li v0,SYS_fcntl				/* Load fcntl syscall # into v0 */
	syscall					
	bne a3,zero,machdep_error	/* Error if a3 != 0 */
	j ra

	.end	machdep_sys_fcntl

/* ==========================================================================
 * machdep_sys_fchmod()
 */
	.globl	machdep_sys_fchmod
	.ent	machdep_sys_fchmod

machdep_sys_fchmod:

	.frame	sp,0,ra				/* No frame, return address in ra */

	li v0,SYS_fchmod			/* Load fchmod syscall # into v0 */
	syscall					
	bne a3,zero,machdep_error	/* Error if a3 != 0 */
	j ra

	.end	machdep_sys_fchmod

/* ==========================================================================
 * machdep_sys_fchown()
 */
	.globl	machdep_sys_fchown
	.ent	machdep_sys_fchown

machdep_sys_fchown:

	.frame	sp,0,ra				/* No frame, return address in ra */

	li v0,SYS_fchown			/* Load fchown syscall # into v0 */
	syscall					
	bne a3,zero,machdep_error	/* Error if a3 != 0 */
	j ra

	.end	machdep_sys_fchown

/* ==========================================================================
 * machdep_sys_rename()
 */
	.globl	machdep_sys_rename
	.ent	machdep_sys_rename

machdep_sys_rename:

	.frame	sp,0,ra				/* No frame, return address in ra */

	li v0,SYS_rename			/* Load link syscall # into v0 */
	syscall					
	bne a3,zero,machdep_error	/* Error if a3 != 0 */
	j ra

	.end	machdep_sys_rename


/* ==========================================================================
 * machdep_sys_waitpid()
 */
	.globl	machdep_sys_waitpid
	.ent	machdep_sys_waitpid

machdep_sys_waitpid:

	.frame	sp,0,ra				/* No frame, return address in ra */

	li v0,SYS_waitpid			/* Load waitpid syscall # into v0 */
	syscall					
	bne a3,zero,machdep_error	/* Error if a3 != 0 */
	j ra

	.end	machdep_sys_waitpid

/* ==========================================================================
 * machdep_sys_readv()
 */
	.globl	machdep_sys_readv
	.ent	machdep_sys_readv

machdep_sys_readv:

	.frame	sp,0,ra				/* No frame, return address in ra */

	li v0,SYS_readv				/* Load readv syscall # into v0 */
	syscall					
	bne a3,zero,machdep_error	/* Error if a3 != 0 */
	j ra

	.end	machdep_sys_readv

/* ==========================================================================
 * machdep_sys_writev()
 */
	.globl	machdep_sys_writev
	.ent	machdep_sys_writev

machdep_sys_writev:

	.frame	sp,0,ra				/* No frame, return address in ra */

	li v0,SYS_writev			/* Load writev syscall # into v0 */
	syscall					
	bne a3,zero,machdep_error	/* Error if a3 != 0 */
	j ra

	.end	machdep_sys_writev

/* ==========================================================================
 * Other important syscalls necessary for the function of this package.
 * ==========================================================================
 * machdep_sys_select()
 */
	.globl	machdep_sys_select
	.ent	machdep_sys_select

machdep_sys_select:

	.frame	sp,0,ra				/* No frame, return address in ra */

	li v0,SYS_select			/* Load select syscall # into v0 */
	syscall
	bne a3,zero,machdep_error	/* Error if a3 != 0 */
	j ra

	.end	machdep_sys_select

/* ==========================================================================
 * machdep_sys_getdirentries()
 */
	.globl	machdep_sys_getdirentries
	.ent	machdep_sys_getdirentries

machdep_sys_getdirentries:

	.frame	sp,0,ra				/* No frame, return address in ra */

	li v0,SYS_getdirentries		/* Load getdirentries syscall # into v0 */
	syscall					
	bne a3,zero,machdep_error	/* Error if a3 != 0 */
	j ra

	.end	machdep_sys_getdirentries

/* ======================================================================= */
/* ==========================================================================
 * machdep_sys_socket()
 */
	.globl	machdep_sys_socket
	.ent	machdep_sys_socket

machdep_sys_socket:

	.frame	sp,0,ra				/* No frame, return address in ra */

	li v0,SYS_socket			/* Load socket syscall # into v0 */
	syscall					
	bne a3,zero,machdep_error	/* Error if a3 != 0 */
	j ra

	.end	machdep_sys_socket

/* ==========================================================================
 * machdep_sys_connect()
 */
	.globl	machdep_sys_connect
	.ent	machdep_sys_connect

machdep_sys_connect:

	.frame	sp,0,ra				/* No frame, return address in ra */

	li v0,SYS_connect			/* Load connect syscall # into v0 */
	syscall					
	bne a3,zero,machdep_error	/* Error if a3 != 0 */
	j ra

	.end	machdep_sys_connect

/* ==========================================================================
 * machdep_sys_accept()
 */
	.globl	machdep_sys_accept
	.ent	machdep_sys_accept

machdep_sys_accept:

	.frame	sp,0,ra				/* No frame, return address in ra */

	li v0,SYS_accept			/* Load accept syscall # into v0 */
	syscall					
	bne a3,zero,machdep_error	/* Error if a3 != 0 */
	j ra

	.end	machdep_sys_accept

/* ==========================================================================
 * machdep_sys_send()
 */
	.globl	machdep_sys_send
	.ent	machdep_sys_send

machdep_sys_send:

	.frame	sp,0,ra				/* No frame, return address in ra */

	li v0,SYS_send				/* Load send syscall # into v0 */
	syscall					
	bne a3,zero,machdep_error	/* Error if a3 != 0 */
	j ra

	.end	machdep_sys_send

/* ==========================================================================
 * machdep_sys_recv()
 */
	.globl	machdep_sys_recv
	.ent	machdep_sys_recv

machdep_sys_recv:

	.frame	sp,0,ra				/* No frame, return address in ra */

	li v0,SYS_recv				/* Load recv syscall # into v0 */
	syscall					
	bne a3,zero,machdep_error	/* Error if a3 != 0 */
	j ra

	.end	machdep_sys_recv

/* ==========================================================================
 * machdep_sys_bind()
 */
	.globl	machdep_sys_bind
	.ent	machdep_sys_bind

machdep_sys_bind:

	.frame	sp,0,ra				/* No frame, return address in ra */

	li v0,SYS_bind				/* Load bind syscall # into v0 */
	syscall					
	bne a3,zero,machdep_error	/* Error if a3 != 0 */
	j ra

	.end	machdep_sys_bind

/* ==========================================================================
 * machdep_sys_listen()
 */
	.globl	machdep_sys_listen
	.ent	machdep_sys_listen

machdep_sys_listen:

	.frame	sp,0,ra				/* No frame, return address in ra */

	li v0,SYS_listen			/* Load listen syscall # into v0 */
	syscall					
	bne a3,zero,machdep_error	/* Error if a3 != 0 */
	j ra

	.end	machdep_sys_listen

/* ==========================================================================
 * machdep_sys_recvmsg()
 */
	.globl	machdep_sys_recvmsg
	.ent	machdep_sys_recvmsg

machdep_sys_recvmsg:

	.frame	sp,0,ra				/* No frame, return address in ra */

	li v0,SYS_recvmsg			/* Load recvmsg syscall # into v0 */
	syscall					
	bne a3,zero,machdep_error	/* Error if a3 != 0 */
	j ra

	.end	machdep_sys_recvmsg

/* ==========================================================================
 * machdep_sys_sendmsg()
 */
	.globl	machdep_sys_sendmsg
	.ent	machdep_sys_sendmsg

machdep_sys_sendmsg:

	.frame	sp,0,ra				/* No frame, return address in ra */

	li v0,SYS_sendmsg			/* Load sendmsg syscall # into v0 */
	syscall					
	bne a3,zero,machdep_error	/* Error if a3 != 0 */
	j ra

	.end	machdep_sys_sendmsg

/* ==========================================================================
 * machdep_sys_getsockopt()
 */
	.globl	machdep_sys_getsockopt
	.ent	machdep_sys_getsockopt

machdep_sys_getsockopt:

	.frame	sp,0,ra				/* No frame, return address in ra */

	li v0,SYS_getsockopt		/* Load getsockopt syscall # into v0 */
	syscall					
	bne a3,zero,machdep_error	/* Error if a3 != 0 */
	j ra

	.end	machdep_sys_getsockopt

/* ==========================================================================
 * machdep_sys_recvfrom()
 */
	.globl	machdep_sys_recvfrom
	.ent	machdep_sys_recvfrom

machdep_sys_recvfrom:

	.frame	sp,0,ra				/* No frame, return address in ra */

	li v0,SYS_recvfrom			/* Load recvfrom syscall # into v0 */
	syscall					
	bne a3,zero,machdep_error	/* Error if a3 != 0 */
	j ra

	.end	machdep_sys_recvfrom

/* ==========================================================================
 * machdep_sys_sendto()
 */
	.globl	machdep_sys_sendto
	.ent	machdep_sys_sendto

machdep_sys_sendto:

	.frame	sp,0,ra				/* No frame, return address in ra */

	li v0,SYS_sendto			/* Load sendto syscall # into v0 */
	syscall					
	bne a3,zero,machdep_error	/* Error if a3 != 0 */
	j ra

	.end	machdep_sys_sendto

/* ==========================================================================
 * machdep_sys_shutdown()
 */
	.globl	machdep_sys_shutdown
	.ent	machdep_sys_shutdown

machdep_sys_shutdown:

	.frame	sp,0,ra				/* No frame, return address in ra */

	li v0,SYS_shutdown			/* Load shutdown syscall # into v0 */
	syscall					
	bne a3,zero,machdep_error	/* Error if a3 != 0 */
	j ra

	.end	machdep_sys_shutdown

/* ==========================================================================
 * machdep_sys_getpeername()
 */
	.globl	machdep_sys_getpeername
	.ent	machdep_sys_getpeername

machdep_sys_getpeername:

	.frame	sp,0,ra				/* No frame, return address in ra */

	li v0,SYS_getpeername		/* Load getpeername syscall # into v0 */
	syscall					
	bne a3,zero,machdep_error	/* Error if a3 != 0 */
	j ra

	.end	machdep_sys_getpeername

/* ==========================================================================
 * Other important asm routines.
 * ======================================================================= */
/* ==========================================================================
 * fake_setjmp()
 */
	.globl	fake_setjmp
	.ent	fake_setjmp

fake_setjmp:

	.frame sp,0,ra				/* No frame, return address in ra */

								/* Save all the important registers */
	sw ra,8(a0)
	sw gp,124(a0)
	sw sp,128(a0)
	sw s0,76(a0)
								/* More registers needed. */
	j ra

	.end	fake_longjmp

/* ==========================================================================
 * machdep_sys_longjmp()
 */
	.globl	machdep_sys_longjmp
	.ent	machdep_sys_longjmp

machdep_sys_longjmp:

	.frame sp,0,ra				/* No frame, return address in ra */
	li a1,1						/* Load 1 into reg a1 */
	sw a1, 20(a0);				/* Load a1 into address a0 + 20 */
	li v0,SYS_sigreturn			/* Load sigreturn syscall # into v0 */
	syscall						/* Do syscall to do longjmp */
	j ra

	.end	machdep_sys_longjmp
