/* ==== schedparam.c =======================================================
 * Copyright (c) 1994 by Chris Provenzano, proven@mit.edu
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *  This product includes software developed by Chris Provenzano.
 * 4. The name of Chris Provenzano may not be used to endorse or promote 
 *	  products derived from this software without specific prior written
 *	  permission.
 *
 * THIS SOFTWARE IS PROVIDED BY CHRIS PROVENZANO ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL CHRIS PROVENZANO BE LIABLE FOR ANY 
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT 
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF 
 * SUCH DAMAGE.
 *
 * Description : Pthread schedparam functions.
 *
 *  1.38 94/06/15 proven
 *      -Started coding this file.
 */

#ifndef lint
static const char rcsid[] = "$Id: schedparam.c,v 1.50.2.1 94/10/05 06:48:08 proven Exp $";
#endif

#include <pthread.h>
#include <errno.h>

/* Currently only policy is supported */

/* ==========================================================================
 * pthread_setschedparam()
 */
int pthread_setschedparam(pthread_t pthread, int policy,
  struct sched_param * param)
{
	enum schedparam_policy new_policy, old_policy;
	semaphore * lock;
	int ret = OK;

	new_policy = policy;
	lock = &(pthread->lock);
	while (SEMAPHORE_TEST_AND_SET(lock)) {
		pthread_yield();
	}

	old_policy = pthread->attr.schedparam_policy;

	if (pthread = pthread_run) {
		switch(new_policy) {
		case SCHED_RR:
			pthread->attr.schedparam_policy = new_policy;
			switch (old_policy) { 
			case SCHED_FIFO:
				pthread_yield();
			default:
				break;
			}
			break;
		case SCHED_FIFO:
			pthread->attr.schedparam_policy = new_policy;
			switch (old_policy) { 
			case SCHED_IO:
			case SCHED_RR:
				machdep_unset_thread_timer();
			default:
				break;
			}
			break;
		case SCHED_IO:
			pthread->attr.schedparam_policy = new_policy;
			switch (old_policy) { 
			case SCHED_FIFO:
				pthread_yield();
			default:
				break;
			}
			break;
		default:
			SET_ERRNO(EINVAL);
			ret = EINVAL;
			break;
		}
	} else {
		switch(new_policy) {
		case SCHED_FIFO:
		case SCHED_IO:
		case SCHED_RR:
			pthread->attr.schedparam_policy = new_policy;
			break;
		default:
			SET_ERRNO(EINVAL);
			ret = EINVAL;
			break;
		}
	}
		
	SEMAPHORE_RESET(lock);
	return(ret);
}

/* ==========================================================================
 * pthread_getschedparam()
 */
int pthread_getschedparam(pthread_t pthread, int * policy,
  struct sched_param * param)
{
	semaphore * lock;

	lock = &(pthread->lock);
	while (SEMAPHORE_TEST_AND_SET(lock)) {
		pthread_yield();
	}

	*policy = pthread->attr.schedparam_policy;

	SEMAPHORE_RESET(lock);
	return(OK);
}

