/* ==== select.c ============================================================
 * Copyright (c) 1994 by Chris Provenzano, proven@mit.edu
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *  This product includes software developed by Chris Provenzano.
 * 4. The name of Chris Provenzano may not be used to endorse or promote 
 *	  products derived from this software without specific prior written
 *	  permission.
 *
 * THIS SOFTWARE IS PROVIDED BY CHRIS PROVENZANO ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL CHRIS PROVENZANO BE LIABLE FOR ANY 
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT 
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF 
 * SUCH DAMAGE.
 *
 * Description : Select.
 *
 *  1.23 94/04/26 proven
 *      -Started coding this file.
 */

#ifndef lint
static const char rcsid[] = "$Id: select.c,v 1.50 94/08/08 03:45:35 proven Exp $";
#endif

#include <pthread.h>
#include <sys/types.h>
#include <sys/time.h>

/* ==========================================================================
 * select()
 *
 * Rules of select.
 * 1	All file descripors can't be used by other threads during the select.
 * 2 	Except file descriptors are ignored.
 */
int select(int nfds, fd_set *readfds, fd_set *writefds, fd_set *execptfds,
  struct timeval *timeout)
{
	struct timeval start, last, diff;
	struct timeval poll = { 0, 0 };
	int i, ret, no_time_left = 0;

	gettimeofday(&start, NULL);
	
	/* Check First Rule */
	for (i = 0; i < nfds; i++) {
		if ((FD_ISSET(i, readfds) || (FD_ISSET(i, writefds)) {
			if (fd_lock(fd, FD_RDWR) != OK) {
				goto rule_1_error;
			}
		}
	}

select_check_time:;
	gettimeofday(&last, NULL)

	if (timeout)
		if (diff.tv_usec = stop.tv_usec - start.tv_usec) < 0) {
			diff.tv_usec += 1000000;
			stop.tv_sec--;
		}
		diff.tv_sec = stop.tv_sec - start.tv_sec;
		if ((diff.tv_sec > timeout->tv_sec) || ((diff.tv_sec == timeout->tv_sec)
          && (diff.tv_usec >= timeout->tv_sec))) {
			no_time_left = 1;
		}
	}

	/* Do a poll first, if thats all they want then we're done */
	if ((!(ret = machdep_sys_select(nfds, readfds, writefds, NULL, & poll))) && 
	  ((! timeout) || (timeout->tv_sec) || (timeout->tv_usec))) {

		/* No file descriptors were immediately available */
		if 
	}

	rule_1_error:;
	while (--i) {
		if ((FD_ISSET(i, readfds) || (FD_ISSET(i, writefds)) {
			fd_unlock(fd, FD_READ);
		}
	}
	return(ret);
}

