dnl Autoconf extensions for pthreads package.
dnl
ifelse(regexp(AC_DEFINE(xxxxx),.*@@@.*),-1,,[define(IS_AUTOHEADER)])])dnl
dnl
dnl Now, the real stuff needed by the pthreads package.
dnl
AC_DEFUN([PTHREADS_CHECK_ONE_SYSCALL],
[AC_MSG_CHECKING(for syscall $1)
AC_CACHE_VAL(pthreads_cv_syscall_$1,
AC_TRY_LINK([
/* FIXME: This list should be generated from info in configure.in.  */
#ifdef HAVE_SYSCALL_H
#include <syscall.h>
#else
#ifdef HAVE_SYS_SYSCALL_H
#include <sys/syscall.h>
#else
where is your syscall header file??
#endif
#endif
],[
int x;
x = SYS_$1 ;
],
eval pthreads_cv_syscall_$1=yes,
eval pthreads_cv_syscall_$1=no))
if eval test \$pthreads_cv_syscall_$1 = yes ; then
	pthreads_syscall_present=yes
	available_syscalls="$available_syscalls $1"
dnl Can't just do the obvious substitution here or autoheader gets
dnl sorta confused.  (Sigh.)  Getting the requoting of the brackets right
dnl would be a pain too.
changequote(,)dnl
	macroname=HAVE_SYSCALL_`echo $1 | tr '[a-z]' '[A-Z]'`
changequote([,])dnl
	AC_DEFINE_UNQUOTED($macroname)
else
	pthreads_syscall_present=no
	missing_syscalls="$missing_syscalls $1"
fi
AC_MSG_RESULT($pthreads_syscall_present)
])dnl
dnl
AC_DEFUN(PTHREADS_CHECK_SYSCALLS,dnl
ifdef([IS_AUTOHEADER],
dnl Need to fake out autoheader, since there's no way to add a new class
dnl of features to generate config.h.in entries for.
[@@@syscalls="$1"@@@
@@@funcs="$funcs syscall_`echo $syscalls | sed 's/ / syscall_/g'`"@@@],
[pthreads_syscall_list="$1"
for pthreads_syscallname in $pthreads_syscall_list ; do
  PTHREADS_CHECK_ONE_SYSCALL([$]pthreads_syscallname)
done
]))dnl
