/* Test to see if floating point state is being properly maintained
   for each thread.  Different threads doing floating point operations
   simultaneously should not interfere with one another.  This
   includes operations that might change some FPU flags, such as
   rounding modes, at least implicitly.  */

#include <stdio.h>
#include <math.h>

int limit = 1000000;

void *log_loop (void *x) {
  int i;
  double d, d1;
  sleep (1);
  for (i = 0; i < limit; i++) {
    d1 = 42.0;
    d1 = log (exp (d1));
    d1 = (d1 + 39.0) / d1;
    if (i == 0)
      d = d1;
    else if (d != d1)
      abort ();
  }
}

void *trig_loop (void *x) {
  int i;
  double d, d1;
  sleep (1);
  for (i = 0; i < limit; i++) {
    d = 35.0;
    d *= M_PI;
    d /= M_LN2;
    d = sin (d);
    d = cos (1 / d);
    if (i == 0)
      d1 = d;
    else if (d != d1)
      abort ();
  }
}

#define N 10
int main () {
  int i;
  void *x;

  limit = 5;
  log_loop (0);
  trig_loop (0);
  return 0;
}
