/* ==== test_create.c ============================================================
 * Copyright (c) 1993 by Chris Provenzano, proven@athena.mit.edu
 *
 * Description : Test pthread_create() and pthread_exit() calls.
 *
 *  1.00 93/08/03 proven
 *      -Started coding this file.
 */

#include <pthread.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>

struct sockaddr_in a_sout;
pthread_mutex_t mutex = PTHREAD_MUTEX_INITIALIZER;

void * sock_write(void* arg)
{
	int fd;

	/* Ensure sock_read runs first */
	if (pthread_mutex_lock(&mutex)) {
		printf("Error: sock_write:pthread_mutex_lock()\n");
		exit(1);
	}

	a_sout.sin_addr.s_addr = htonl(0x7f000001); /* loopback */

	if ((fd = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
		printf("Error: sock_write:socket()\n");
		exit(1);
	}

	printf("This should be message #2\n");
	if (connect(fd, &a_sout, sizeof(a_sout)) < 0) {
		printf("Error: sock_read:connect()\n");
		exit(1);
	}
	close(fd);
		
	if (pthread_mutex_unlock(&mutex)) {
		printf("Error: sock_write:pthread_mutex_lock()\n");
		exit(1);
	}

	if ((fd = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
		printf("Error: sock_write:socket()\n");
		exit(1);
	}

	printf("This should be message #3\n");
	if (connect(fd, &a_sout, sizeof(a_sout)) < 0) {
		printf("Error: sock_read:connect()\n");
		exit(1);
	}
	close(fd);
}

void * sock_read(void* arg)
{
	struct sockaddr a_sin;
	int a_sin_size;
	int a_fd, fd;
	short port;

	if (pthread_mutex_unlock(&mutex)) {
		printf("Error: sock_read:pthread_mutex_lock()\n");
		exit(1);
	}

	port = 3276;
	a_sout.sin_family = AF_INET;
	a_sout.sin_port = htons(port);
	a_sout.sin_addr.s_addr = INADDR_ANY;

	if ((a_fd = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
		printf("Error: sock_read:socket()\n");
		exit(1);
	}

	while (bind(a_fd, &a_sout, sizeof(a_sout)) < 0) {
		if (errno == EADDRINUSE) { 
			a_sout.sin_port = htons((++port));
			continue;
		}
		printf("Error: sock_read:bind()\n");
		exit(1);
	}

	if (listen(a_fd, 2)) {
		printf("Error: sock_read:listen()\n");
		exit(1);
	}
		
	a_sin_size = sizeof(a_sin);
	printf("This should be message #1\n");
	if ((fd = accept(a_fd, &a_sin, &a_sin_size)) < 0) {
		printf("Error: sock_read:accept()\n");
		exit(1);
	}
	
	if (pthread_mutex_lock(&mutex)) {
		printf("Error: sock_read:pthread_mutex_lock()\n");
		exit(1);
	}
	close(fd);

	a_sin_size = sizeof(a_sin);
	printf("This should be message #4\n");
	if ((fd = accept(a_fd, &a_sin, &a_sin_size)) < 0) {
		printf("Error: sock_read:accept()\n");
		exit(1);
	}

	close(fd);
}

main()
{
	pthread_t thread;
	int i;

	pthread_init(); 

	/* Ensure sock_read runs first */
	if (pthread_mutex_lock(&mutex)) {
		printf("Error: main:pthread_mutex_lock()\n");
		exit(1);
	}

	if (pthread_create(&thread, NULL, sock_read, 0xdeadbeaf)) {
		printf("Error: main:pthread_create(sock_read)\n");
		exit(1);
	}
	if (pthread_create(&thread, NULL, sock_write, 0xdeadbeaf)) {
		printf("Error: main:pthread_create(sock_write)\n");
		exit(1);
	}

	sleep(10);
}
