/* ==== syscall.S ============================================================
 * Copyright (c) 1993 Chris Provenzano, proven@athena.mit.edu
 *
 * Description : Machine dependent syscalls for decstation with r2000/r3000
 *
 *  1.00 93/08/14 proven
 *      -Started coding this file.
 */

#include <syscall.h>

#define SYSCALL(x)															\
	machdep_sys_##x														!	\
																		!	\
	.PROC																!	\
	.CALLINFO 	NO_CALLS,FRAME=0	 									!	\
																		!	\
	ldil -0x80000,%r1			/* Load r1 with kernel gate address */	!	\
	ble 4(%sr7,%r1)				/* Branch to kernel */ 					!	\
	ldi SYS_##x,%r22			/* Load syscall into r22 (t1) */ 		!	\
	or,= %r0,%r22,%r0			/* Is return OK */						!	\
	b,n machdep_error			/* No, goto error handler */			!	\
	bv,n %r0(%r2)				/* Return */							!	\
																		!	\
	.PROCEND															!	\
	.EXPORT		machdep_sys_##x,ENTRY

/*
 * Initial asm stuff for all functions.
 */
	.CODE

/* ==========================================================================
 * error code for all syscalls. The error value is returned as the negative
 * of the errno value. Eventually I want to load the errno value directly
 * into pthread_run->error but until then ...
 */
machdep_error
	sub %r0,%r28,%r28			/* Return negative of errno value. */
	bv,n %r0(%r2)				/* Return */

/* ==========================================================================
 * Syscalls already done,
 * Standard		 		Other important		BSD sockets
 * read 		=   3	select		=  93	accept		= 275
 * write 		=   4						bind		= 276
 * open 		=   5						connect		= 277
 * close 		=   6						getpeername	= 278
 * lseek 		=  19						getsockopt	= 280
 * fcntl		=  62						listen		= 281
 * dup2			=  90
 * readv		= 120						socket		= 290
 * writev		= 121
 * ======================================================================= */

/* ==========================================================================
 * machdep_sys_creat()
 */
SYSCALL(creat)

/* ==========================================================================
 * machdep_sys_unlink()
 */
SYSCALL(unlink)

/* ==========================================================================
 * machdep_sys_fchmod()
 */
SYSCALL(fchmod)

/* ==========================================================================
 * machdep_sys_chdir()
 */
SYSCALL(chdir)

/* ==========================================================================
 * machdep_sys_chmod()
 */
SYSCALL(chmod)

/* ==========================================================================
 * machdep_sys_chown()
 */
SYSCALL(chown)

/* ==========================================================================
 * machdep_sys_recvmsg()
 */
SYSCALL(recvmsg)

/* ==========================================================================
 * machdep_sys_sendmsg()
 */
SYSCALL(sendmsg)

/* ==========================================================================
 * machdep_sys_shutdown()
 */
SYSCALL(shutdown)

/* ==========================================================================
 * machdep_sys_rename()
 */
SYSCALL(rename)

/* ==========================================================================
 * machdep_sys_link()
 */
SYSCALL(link)

/* ==========================================================================
 * machdep_sys_stat()
 */
SYSCALL(stat)

/* ==========================================================================
 * machdep_sys_fchown()
 */
SYSCALL(fchown)

/* ==========================================================================
 * machdep_sys_read()
 */
SYSCALL(read)

/* ==========================================================================
 * machdep_sys_write()
 */
SYSCALL(write)

/* ==========================================================================
 * machdep_sys_open()
 */
SYSCALL(open)

/* ==========================================================================
 * machdep_sys_close()
 */
SYSCALL(close)

/* ==========================================================================
 * machdep_sys_lseek()
 */
SYSCALL(lseek)

/* ==========================================================================
 * machdep_sys_fcntl()
 */
SYSCALL(fcntl)

/* ==========================================================================
 * machdep_sys_dup2()
 */
SYSCALL(dup2)

/* ==========================================================================
 * machdep_sys_readv()
 */
SYSCALL(readv)

/* ==========================================================================
 * machdep_sys_writev()
 */
SYSCALL(writev)

/* ==========================================================================
 * machdep_sys_fstat()
 */
SYSCALL(fstat)

/* ==========================================================================
 * machdep_sys_pipe()
 */
SYSCALL(pipe)

/* ==========================================================================
 * machdep_sys_dup()
 */
SYSCALL(dup)

/* ==========================================================================
 * machdep_sys_fork()
 */
machdep_sys_fork														
																		
	.PROC															
	.CALLINFO 	NO_CALLS,FRAME=0	 									
																		
	ldil -0x80000,%r1			/* Load r1 with kernel gate address */	
	ble 4(%sr7,%r1)				/* Branch to kernel */ 					
	ldi SYS_fork,%r22			/* Load syscall into r22 (t1) */ 		
	or,= %r0,%r22,%r0			/* Is return OK */						
	b,n machdep_error			/* No, goto error handler */		
	or,= %r29,%r0,%r0				/* Is return value 1 = 0 */				
	copy %r0,%r28				/* Load 0 into return value 0 */	
	bv,n %r0(%r2)				/* Return */							
																		
	.PROCEND															
	.EXPORT		machdep_sys_fork,ENTRY

/* ==========================================================================
 * machdep_sys_execve()
 */
SYSCALL(execve)

/* ==========================================================================
 * machdep_sys_wait3()
 */
SYSCALL(wait3)

/* ==========================================================================
 * machdep_sys_waitpid()
 */
SYSCALL(waitpid)

/* ==========================================================================
 * Other important syscalls necessary for the function of this package.
 * ==========================================================================
 * machdep_sys_select()
 */
SYSCALL(select) 

/* ==========================================================================
 * machdep_sys_getdirentries()
 */
SYSCALL(getdirentries)

/*======================================================================= */
/* ==========================================================================
 * machdep_sys_accept()
 */
SYSCALL(accept)

/* ==========================================================================
 * machdep_sys_bind()
 */
SYSCALL(bind)

/* ==========================================================================
 * machdep_sys_connect()
 */
SYSCALL(connect)

/* ==========================================================================
 * machdep_sys_getpeername()
 */
SYSCALL(getpeername)

/* ==========================================================================
 * machdep_sys_getsockopt()
 */
SYSCALL(getsockopt)

/* ==========================================================================
 * machdep_sys_listen()
 */
SYSCALL(listen)

/* ==========================================================================
 * machdep_sys_socket()
 */
SYSCALL(socket)

/* ==========================================================================
 * machdep_sys_send()
 */
SYSCALL(send)

/* ==========================================================================
 * machdep_sys_sendto()
 */
SYSCALL(sendto)

/* ==========================================================================
 * machdep_sys_recv()
 */
SYSCALL(recv)

/* ==========================================================================
 * machdep_sys_recvfrom()
 */
SYSCALL(recvfrom)

	.END

