/*
 * Copyright (c) 1983 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *	  notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *	  notice, this list of conditions and the following disclaimer in the
 *	  documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *	  must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *	  may be used to endorse or promote products derived from this software
 *	  without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.	IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#if defined(LIBC_SCCS) && !defined(lint)
/*static char *sccsid = "from: @(#)gethostent.c	5.8 (Berkeley) 2/24/91";*/
static char *rcsid = "$Id: gethostent.c,v 1.4 1995/01/06 10:46:01 ghudson Exp $";
#endif /* LIBC_SCCS and not lint */

#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "res_internal.h"

void sethostent(int keep_open)
{
	struct res_data *data = _res_init();
	
	if (data) {
		data->keep_hostfp_open |= keep_open;
		sethostent_r(&data->hostfp);
	}
}

void endhostent()
{
	struct res_data *data = _res_init();
	
	if (data) {
		data->keep_hostfp_open = 0;
		endhostent_r(&data->hostfp);
	}
}

struct hostent *gethostent()
{
	struct res_data *data = _res_init();
	
	return (data) ? gethostent_r(&data->host_answer, &data->hostfp) : NULL;
}

void sethostent_r(FILE **fp)
{
	if (*fp == NULL)
		*fp = fopen(_PATH_HOSTS, "r");
	else
		rewind(*fp);
}

void endhostent_r(FILE **fp)
{
	fclose(*fp);
	*fp = NULL;
}

struct hostent *gethostent_r(struct hostent_answer *result, FILE **fp)
{
	char *p, *cp, **q;
	
	if (*fp == NULL && (*fp = fopen(_PATH_HOSTS, "r")) == NULL)
		return NULL;
  again:
	if ((p = fgets(result->hostbuf, BUFSIZ, *fp)) == NULL)
		return NULL;
	if (*p == '#')
		goto again;
	cp = strpbrk(p, "#\n");
	if (cp == NULL)
		goto again;
	*cp = '\0';
	cp = strpbrk(p, " \t");
	if (cp == NULL)
		goto again;
	*cp++ = '\0';
	/* THIS STUFF IS INTERNET SPECIFIC */
	result->h_addr_ptrs[0] = (char *)&result->host_addr;
	result->h_addr_ptrs[1] = NULL;
	result->host_addr.s_addr = inet_addr(p);
	result->host.h_addr_list = result->h_addr_ptrs;
	result->host.h_length = sizeof (u_long);
	result->host.h_addrtype = AF_INET;
	while (*cp == ' ' || *cp == '\t')
		cp++;
	result->host.h_name = cp;
	q = result->host.h_aliases = result->host_aliases;
	cp = strpbrk(cp, " \t");
	if (cp != NULL) 
		*cp++ = '\0';
	while (cp && *cp) {
		if (*cp == ' ' || *cp == '\t') {
			cp++;
			continue;
		}
		if (q < &result->host_aliases[__NETDB_MAXALIASES - 1])
			*q++ = cp;
		cp = strpbrk(cp, " \t");
		if (cp != NULL)
			*cp++ = '\0';
	}
	*q = NULL;
	return &result->host;
}

