/* ==== test_create.c ============================================================
 * Copyright (c) 1995 by Greg Hudson, ghudson@.mit.edu
 *
 * Description : Test netdb calls.
 *
 *  1.00 95/01/05 ghudson
 *      -Started coding this file.
 */

#include <pthread.h>
#include <stdio.h>
#include <string.h>
#include <netdb.h>

static void test_serv()
{
	struct servent *serv;
	struct servent_answer answer;
	FILE *fp;

	serv = getservbyname("telnet", "tcp");
	if (serv)
		printf("getservbyname -> port %d\n", ntohs(serv->s_port));
	else
		printf("getservbyname -> NULL (bad)\n");

	serv = getservbyname_r("telnet", "tcp", &answer);
	if (serv)
		printf("getservbyname_r -> port %d\n", ntohs(serv->s_port));
	else
		printf("getservbyname_r -> NULL (bad)\n");

	serv = getservbyname_r_file("telnet", "tcp", &answer, &fp);
	serv = getservbyname_r_file("telnet", "tcp", &answer, &fp);
	serv = getservbyname_r_file("telnet", "tcp", &answer, &fp);
	if (serv)
		printf("getservbyname_r_file -> port %d\n", ntohs(serv->s_port));
	else
		printf("getservbyname_r_file -> NULL (bad)\n");
	endservent_r(&fp);
}

static void test_host()
{
    struct hostent *host;
	struct hostent_answer answer;
	struct in_addr addr;

	host = gethostbyname("maze.mit.edu");
	if (host) {
		memcpy(&addr, host->h_addr, sizeof(addr));
		printf("gethostbyname -> %s\n", inet_ntoa(addr));
	} else {
		printf("gethostbyname -> NULL (bad)\n");
	}

	host = gethostbyname_r("maze.mit.edu", &answer);
	if (host) {
		memcpy(&addr, host->h_addr, sizeof(addr));
		printf("gethostbyname_r -> %s\n", inet_ntoa(addr));
	} else {
		printf("gethostbyname_r -> NULL (bad)\n");
	}
}

main()
{
	test_serv();
	test_host();
}
