/* ==== syscall.S ============================================================
 * Copyright (c) 1994 Chris Provenzano, proven@mit.edu
 * All rights reserved.
 *
 * Description : Machine dependent syscalls for i386/i486/i586
 *
 *  1.00 93/08/26 proven
 *      -Started coding this file.
 *
 *	1.01 93/11/13 proven
 *		-The functions readv() and writev() added.
 *
 *	1.16 94/01/30 proven
 *		-This file now requires gas version 2.0 or greater.
 */

#ifndef lint
	.text
	.asciz "$Id: syscall-i386-linux-1.0.S,v 1.50 1994/08/08 03:43:15 proven Exp $";
#endif
 
#if defined(SYSLIBC_SCCS) && !defined(lint)
        .asciz "@(#)syscall.s   5.1 (Berkeley) 4/23/90"
#endif /* SYSLIBC_SCCS and not lint */

#include <sys/syscall.h>

#define SYSCALL0(x)					\
	.globl _machdep_sys_##x;		\
									\
_machdep_sys_##x##:;				\
									\
	lea	SYS_##x, %eax;				\
	int $0x80;						\
	ret;

#define SYSCALL1(x)					\
	.globl _machdep_sys_##x;		\
									\
_machdep_sys_##x##:;				\
									\
	push %ebx;						\
	mov 8(%esp), %ebx;				\
	lea	SYS_##x, %eax;				\
	int $0x80;						\
	pop %ebx;						\
	ret;

#define SYSCALL2(x)					\
	.globl _machdep_sys_##x;		\
									\
_machdep_sys_##x##:;				\
									\
	push %ebx;						\
	mov 8(%esp), %ebx;				\
	mov 12(%esp), %ecx;				\
	lea	SYS_##x, %eax;				\
	int $0x80;						\
	pop %ebx;						\
	ret;

#define SYSCALL3(x)					\
	.globl _machdep_sys_##x;		\
									\
_machdep_sys_##x##:;				\
									\
	push %ebx;						\
	mov 8(%esp), %ebx;				\
	mov 12(%esp), %ecx;				\
	mov 16(%esp), %edx;				\
	lea	SYS_##x, %eax;				\
	int $0x80;						\
	pop %ebx;						\
	ret;

#define SYSCALL4(x)					\
	.globl _machdep_sys_##x;		\
									\
_machdep_sys_##x##:;				\
									\
	push %ebx;						\
	push %esi;						\
	mov 12(%esp), %ebx;				\
	mov 16(%esp), %ecx;				\
	mov 20(%esp), %edx;				\
	mov 24(%esp), %esi;				\
	lea	SYS_##x, %eax;				\
	int $0x80;						\
	pop %esi;						\
	pop %ebx;						\
	ret;

#define SYSCALL5(x)					\
	.globl _machdep_sys_##x;		\
									\
_machdep_sys_##x##:;				\
									\
	push %ebx;						\
	push %esi;						\
	push %edi;						\
	mov 16(%esp), %ebx;				\
	mov 20(%esp), %ecx;				\
	mov 24(%esp), %edx;				\
	mov 28(%esp), %esi;				\
	mov 32(%esp), %edi;				\
	lea	SYS_##x, %eax;				\
	int $0x80;						\
	pop %edi;						\
	pop %esi;						\
	pop %ebx;						\
	ret;

/*
 * Initial asm stuff for all functions.
 */
	.text
	.align	2


/* ==========================================================================
 * machdep_sys_write()
 */
SYSCALL3(write)

/* ==========================================================================
 * machdep_sys_read()
 */
SYSCALL3(read)

/* ==========================================================================
 * machdep_sys_open()
 */
SYSCALL3(open)

/* ==========================================================================
 * machdep_sys_creat()
 */
SYSCALL2(creat)

/* ==========================================================================
 * machdep_sys_close()
 */
SYSCALL1(close)

/* ==========================================================================
 * machdep_sys_dup2()
 */
SYSCALL2(dup2)

/* ==========================================================================
 * machdep_sys_fcntl()
 */
SYSCALL3(fcntl)

/* ==========================================================================
 * machdep_sys_fchown()
 */
SYSCALL3(fchown)

/* ==========================================================================
 * machdep_sys_fchmod()
 */
SYSCALL2(fchmod)

/* ==========================================================================
 * machdep_sys_chown()
 */
SYSCALL3(chown)

/* ==========================================================================
 * machdep_sys_chmod()
 */
SYSCALL2(chmod)

/* ==========================================================================
 * machdep_sys_chdir()
 */
SYSCALL1(chdir)

/* ==========================================================================
 * machdep_sys_unlink()
 */
SYSCALL1(unlink)

/* ==========================================================================
 * machdep_sys_link()
 */
SYSCALL2(link)

/* ==========================================================================
 * machdep_sys_link()
 */
SYSCALL2(rename)

/* ==========================================================================
 * machdep_sys_lseek()
 */
SYSCALL3(lseek)

/* ==========================================================================
 * machdep_sys_pipe()
 */
SYSCALL1(pipe)

/* ==========================================================================
 * machdep_sys_dup()
 */
SYSCALL1(dup)

/* ==========================================================================
 * machdep_sys_fork()
 */
SYSCALL0(fork)

/* ==========================================================================
 * machdep_sys_execve()
 */
SYSCALL3(execve)

/* ==========================================================================
 * machdep_sys_stat()
 */
SYSCALL2(stat)

/* ==========================================================================
 * machdep_sys_fstat()
 */
SYSCALL2(fstat)

/* ========================================================================== 
 * Nonstandard calls used to make the system work
 *
 * ==========================================================================
 * machdep_sys_select()
 */
	.globl _machdep_sys_select;		\
									\
_machdep_sys_select:;				\
									\
	push %ebx;						\
	lea 8(%esp), %ebx;				\
	lea	SYS_select, %eax;			\
	int $0x80;						\
	pop %ebx;						\
	ret;

/* ==========================================================================
 * machdep_sys_wait4()
 */
SYSCALL4(wait4)

/* ==========================================================================
 * machdep_sys_readdir()
 */
SYSCALL3(readdir)

/* ==========================================================================
 * machdep_sys_socketcall()
 */
SYSCALL2(socketcall)

