/* ==== syscall.S ============================================================
 * Copyright (c) 1994 Chris Provenzano, proven@mit.edu
 * All rights reserved.
 *
 */

#ifndef lint
	.text
	.asciz "$Id: syscall-sparc-sunos-5.3.S,v 1.1 1994/09/29 06:20:51 proven Exp $";
#endif
 
#define _ASM
#include <sys/syscall.h>

#define	SYSCALL(x)					\
	.globl machdep_sys_##x;		\
									\
machdep_sys_##x:;					\
									\
	mov SYS_##x, %g1;   			\
	ta 0;							\
	bcs,a 2b;						\
	sub %r0,%o0,%o0;				\
	retl							


/*
 * Initial asm stuff for all functions.
 */
	.text
	.align	4

/* ==========================================================================
 * error code for all syscalls. The error value is returned as the negative
 * of the errno value.
 */

1:
	sub		%r0, %o0, %o0
2:
	retl
	nop

/* ==========================================================================
 * machdep_sys_write()
 */
SYSCALL(write)

/* ==========================================================================
 * machdep_sys_read()
 */
SYSCALL(read)

/* ==========================================================================
 * machdep_sys_open()
 */
SYSCALL(open)

/* ==========================================================================
 * machdep_sys_creat()
 */
SYSCALL(creat)

/* ==========================================================================
 * machdep_sys_close()
 */
SYSCALL(close)

/* ==========================================================================
 * machdep_sys_fcntl()
 */
SYSCALL(fcntl)

/* ==========================================================================
 * machdep_sys_lseek()
 */
SYSCALL(lseek)

/* ==========================================================================
 * machdep_sys_dup()
 */
SYSCALL(dup)

/* ==========================================================================
 * machdep_sys_pipe()
 */
SYSCALL(pipe)

/* ==========================================================================
 * machdep_sys_fchmod()
 */
SYSCALL(fchmod)

/* ==========================================================================
 * machdep_sys_fchown()
 */
SYSCALL(fchown)

/* ==========================================================================
 * machdep_sys_fork()
 */
    .globl _machdep_sys_fork;

_machdep_sys_fork:;

    mov SYS_fork, %g1;
    ta 0;
    bcs 1b;
    nop;
    tst %o1
    bne,a __fork_parent
    mov  %g0, %o0
__fork_parent:;
    retl

/* ==========================================================================
 * machdep_sys_execve()
 */
SYSCALL(execve)

/* ==========================================================================
 * machdep_sys_fstat()
 */
SYSCALL(fstat)

/* ==========================================================================
 * machdep_sys_link()
 */
SYSCALL(link)

/* ==========================================================================
 * machdep_sys_unlink()
 */
SYSCALL(unlink)

/* ==========================================================================
 * machdep_sys_chdir()
 */
SYSCALL(chdir)

/* ==========================================================================
 * machdep_sys_chown()
 */
SYSCALL(chown)

/* ==========================================================================
 * machdep_sys_chmod()
 */
SYSCALL(chmod)

/* ==========================================================================
 * machdep_sys_stat()
 */
SYSCALL(stat)

/* ==========================================================================
 * machdep_sys_rename()
 */
SYSCALL(rename)

/* ========================================================================== 
 * Nonstandard calls used to make the system work
 * ==========================================================================
 * machdep_sys_getdents()
 */
SYSCALL(getdents)

/* ==========================================================================
 * machdep_sys_waitsys()
 */
SYSCALL(waitsys)

/* ==========================================================================
 * machdep_sys_pgrpsys()
 */
SYSCALL(pgrpsys)

/* ========================================================================== 
 * Berkeley socket stuff
 * 
 * ==========================================================================
 * machdep_sys_socketcall()
 */
    .globl machdep_sys_socketcall;

machdep_sys_socketcall:;

	mov 83, %g1;   			
	ta 0;							
	bcs,a 2b;						
	sub %r0,%o0,%o0;				
	retl							

/* ==========================================================================
 * machdep_sys_readv()
 */
SYSCALL(readv)

/* ==========================================================================
 * machdep_sys_writev()
 */
SYSCALL(writev)

