/* ==== select.c ============================================================
 * Copyright (c) 1994 by Chris Provenzano, proven@mit.edu
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *  This product includes software developed by Chris Provenzano.
 * 4. The name of Chris Provenzano may not be used to endorse or promote 
 *	  products derived from this software without specific prior written
 *	  permission.
 *
 * THIS SOFTWARE IS PROVIDED BY CHRIS PROVENZANO ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL CHRIS PROVENZANO BE LIABLE FOR ANY 
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT 
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF 
 * SUCH DAMAGE.
 *
 * Description : Select.
 *
 *  1.23 94/04/26 proven
 *      -Started coding this file.
 */

#ifndef lint
static const char rcsid[] = "$Id: select.c,v 1.51 1994/10/25 22:48:26 proven Exp $";
#endif

#include <pthread.h>
#include <sys/types.h>
#include <sys/time.h>

/* ==========================================================================
 * select()
 *
 * Rules of select.
 * 1	All file descripors can't be used by other threads during the select.
 * 2 	Except file descriptors are ignored.
 */
int select(int nfds, fd_set *readfds, fd_set *writefds, fd_set *execptfds,
  struct timeval *timeout)
{
	struct timeval start, last, diff;
	struct timeval poll = { 0, 0 };
	int i, ret, no_time_left = 0;

	gettimeofday(&start, NULL);
	
	/* Check First Rule */
	for (i = 0; i < nfds; i++) {
		if ((FD_ISSET(i, readfds) || (FD_ISSET(i, writefds)) {
			if (fd_lock(fd, FD_RDWR) != OK) {
				goto rule_1_error;
			}
		}
	}

select_check_time:;
	gettimeofday(&last, NULL)

	if (timeout)
		if (diff.tv_usec = stop.tv_usec - start.tv_usec) < 0) {
			diff.tv_usec += 1000000;
			stop.tv_sec--;
		}
		diff.tv_sec = stop.tv_sec - start.tv_sec;
		if ((diff.tv_sec > timeout->tv_sec) || ((diff.tv_sec == timeout->tv_sec)
          && (diff.tv_usec >= timeout->tv_sec))) {
			no_time_left = 1;
		}
	}

	/* Do a poll first, if thats all they want then we're done */
	if ((!(ret = machdep_sys_select(nfds, readfds, writefds, NULL, & poll))) && 
	  ((! timeout) || (timeout->tv_sec) || (timeout->tv_usec))) {

		/* No file descriptors were immediately available */
		if 
	}

	rule_1_error:;
	while (--i) {
		if ((FD_ISSET(i, readfds) || (FD_ISSET(i, writefds)) {
			fd_unlock(fd, FD_READ);
		}
	}
	return(ret);
}





Received: from PACIFIC-CARRIER-ANNEX.MIT.EDU by po7.MIT.EDU (5.61/4.7) id AA29185; Thu, 6 Oct 94 09:22:21 EDT
Received: from ixgate02.dfnrelay.d400.de by MIT.EDU with SMTP
	id AA06252; Thu, 6 Oct 94 09:22:13 EDT
X400-Received: by mta d400relay in /PRMD=dfnrelay/ADMD=d400/C=de/; Relayed;
               Thu, 6 Oct 1994 14:22:34 +0100
X400-Received: by /PRMD=TU-Berlin/ADMD=D400/C=DE/; Relayed;
               Thu, 6 Oct 1994 13:46:16 +0100
X400-Received: by /PRMD=TU-Berlin/ADMD=D400/C=DE/; Relayed;
               Thu, 6 Oct 1994 13:44:43 +0100
X400-Received: by /PRMD=TU-Berlin/ADMD=D400/C=DE/; Relayed;
               Thu, 6 Oct 1994 13:44:44 +0100
Date: Thu, 6 Oct 1994 13:44:44 +0100
X400-Originator: peterh@prz.tu-berlin.d400.de
X400-Recipients: non-disclosure:;
X400-Mts-Identifier: [/PRMD=TU-Berlin/ADMD=D400/C=DE/;<9410061244.AA10236@prz.tu-berli]
X400-Content-Type: P2-1984 (2)
Content-Identifier: Re: Select fo...
Alternate-Recipient: Allowed
From: " (Peter Hofmann)" <peterh@prz.tu-berlin.d400.de>
Message-Id: <9410061244.AA10236@prz.tu-berlin.de>
To: " (Christopher Provenzano)" <proven@MIT.EDU>
In-Reply-To: <9410041956.AA19499@carbonara.MIT.EDU>
Subject: Re: Select for pthreads
X-Mailer: ELM [version 2.4 PL22]
Mime-Version: 1.0
Content-Type: text/plain; charset=ISO-8859-1
Content-Transfer-Encoding: 8bit
Content-Length: 26153

Hello,

here are the changes I made to your pthreads-1-50-7  package to
implement the select, setsockopt, getsockopt, and getpeername system
calls. This works fine on my Linux system (kernel 1.1.50), the select
does not work on Suns, however. I haven't found the time to look into
this problem, yet.

Another potential problem is, that I have tested the select call only
with sockets I want to read, so far. So I don't really know, if it
works to specify writing sockets or exceptional conditions.

Peter

*** fd_kern.c	Wed Aug 24 08:11:21 1994
--- /home/peter/tmp/pthreads/pthreads/fd_kern.c	Mon Oct  3 23:55:58 1994
***************
*** 58,64 ****
  /* ==========================================================================
   * Variables used by both fd_kern_poll and fd_kern_wait
   */
! static struct pthread *fd_wait_read, *fd_wait_write;
  
  /* ==========================================================================
   * fd_kern_poll()
--- 58,64 ----
  /* ==========================================================================
   * Variables used by both fd_kern_poll and fd_kern_wait
   */
! static struct pthread *fd_wait;
  
  /* ==========================================================================
   * fd_kern_poll()
***************
*** 71,137 ****
  
  void fd_kern_poll()
  {
! 	struct timeval __fd_kern_poll_timeout = { 0, 0 };
! 	fd_set fd_set_read, fd_set_write;
! 	struct pthread **pthread;
! 	semaphore *lock;
! 	int count;
! 
! 	FD_ZERO(&fd_set_read);
! 	FD_ZERO(&fd_set_write);
! 	/* If someone has the lock then they are in RUNNING state, just return */
! 	lock = &fd_wait_lock;
! 	if (SEMAPHORE_TEST_AND_SET(lock)) {
! 		return;
! 	}
! 	if (fd_wait_read || fd_wait_write) {
! 		for (pthread = &fd_wait_read; *pthread; pthread = &((*pthread)->next)) {
! 			FD_SET((*pthread)->fd, &fd_set_read);
! 		}
! 		for (pthread = &fd_wait_write; *pthread; pthread = &((*pthread)->next)) {
! 			FD_SET((*pthread)->fd, &fd_set_write);
! 		}
! 
! 		if ((count = machdep_sys_select(dtablesize, &fd_set_read,
! 		  &fd_set_write, NULL, &__fd_kern_poll_timeout)) < OK) {
! 			if (count == -EINTR) {
! 				SEMAPHORE_RESET(lock);
! 				return;
! 			}
! 			PANIC();
! 		}
  	
! 		for (pthread = &fd_wait_read; count && *pthread; ) {
! 			if (FD_ISSET((*pthread)->fd, &fd_set_read)) {
! 				/* Get lock on thread */
! 
! 				(*pthread)->state = PS_RUNNING;
! 				*pthread = (*pthread)->next;
! 				count--;
! 				continue;
! 			} 
! 			pthread = &((*pthread)->next);
! 		}
! 					
! 		for (pthread = &fd_wait_write; count && *pthread; ) {
! 			if (FD_ISSET((*pthread)->fd, &fd_set_write)) {
! 				semaphore *plock;
! 
! 				/* Get lock on thread */
! 				plock = &(*pthread)->lock;
! 				if (!(SEMAPHORE_TEST_AND_SET(plock))) {
! 					/* Thread locked, skip it. */
! 					(*pthread)->state = PS_RUNNING;
! 					*pthread = (*pthread)->next;
! 					SEMAPHORE_RESET(plock);
! 				}
! 				count--;
! 				continue;
! 			} 
! 			pthread = &((*pthread)->next);
! 		}
! 	}
! 	SEMAPHORE_RESET(lock);
  }
  
  /* ==========================================================================
--- 71,136 ----
  
  void fd_kern_poll()
  {
!   struct timeval __fd_kern_poll_timeout = { 0, 0 };
!   fd_set fd_set_read, fd_set_write, fd_set_excp;
!   struct pthread **pthread;
!   semaphore *lock;
!   int count,i,type;
! 
!   /* If someone has the lock then they are in RUNNING state, just return */
!   lock = &fd_wait_lock;
!   if (SEMAPHORE_TEST_AND_SET(lock))
!     return;
! 
!   if (fd_wait) {
!     FD_ZERO(&fd_set_read);
!     FD_ZERO(&fd_set_write);
!     FD_ZERO(&fd_set_excp);
!     for (pthread = &fd_wait; *pthread; pthread = &((*pthread)->next))
!       for (i = 0; i < (*pthread)->fd_cnt; i++)
!       {
!         type = (*pthread)->fd_types[i];
!         if (type & FD_READ)
!           FD_SET((*pthread)->fds[i], &fd_set_read);
!         else if (type & FD_WRITE)
!           FD_SET((*pthread)->fds[i], &fd_set_write);
!         else if (type & FD_EXCP)
!           FD_SET((*pthread)->fds[i], &fd_set_excp);
!       }
! 
!     if ((count = machdep_sys_select(dtablesize, &fd_set_read,
!                                     &fd_set_write, &fd_set_excp,
!                                     &__fd_kern_poll_timeout)) < OK)
!     {
!       if (count == -EINTR)
!       {
!         SEMAPHORE_RESET(lock);
!         return;
!       }
!       PANIC();
!     }
  	
!     for (pthread = &fd_wait; count && *pthread; )
!       for (i = 0; *pthread && i < (*pthread)->fd_cnt; i++)
!         if (FD_ISSET((*pthread)->fds[i], &fd_set_read) ||
!             FD_ISSET((*pthread)->fds[i], &fd_set_excp) ||
!             FD_ISSET((*pthread)->fds[i], &fd_set_write))
!         {
!           semaphore *plock;
!           /* Get lock on thread */
!           plock = &(*pthread)->lock;
!           if (!(SEMAPHORE_TEST_AND_SET(plock))) {
!             /* Thread locked, skip it. */
!             (*pthread)->state = PS_RUNNING;
!             *pthread = (*pthread)->next;
!             SEMAPHORE_RESET(plock);
!           }
!           else
!             pthread = &((*pthread)->next);
!           count--;
!         }
!   }
!   SEMAPHORE_RESET(lock);
  }
  
  /* ==========================================================================
***************
*** 143,222 ****
  
  void fd_kern_wait()
  {
! 	fd_set fd_set_read, fd_set_write;
! 	struct pthread **pthread;
! 	sigset_t sig_to_block;
! 	int count;
! 
! 	if (fd_wait_read || fd_wait_write) {
! 		FD_ZERO(&fd_set_read);
! 		FD_ZERO(&fd_set_write);
! 		for (pthread = &fd_wait_read; *pthread; pthread = &((*pthread)->next)) {
! 			FD_SET((*pthread)->fd, &fd_set_read);
! 		}
! 		for (pthread = &fd_wait_write; *pthread; pthread = &((*pthread)->next)) {
! 			FD_SET((*pthread)->fd, &fd_set_write);
! 		}
! 
! 		/* Turn off interrupts for real while we set the timer.  */
! 
! 		sigfillset(&sig_to_block);
! 		sigprocmask(SIG_BLOCK, &sig_to_block, NULL);
! 
! 		machdep_unset_thread_timer(); 
! 		__fd_kern_wait_timeout.tv_usec = 0;
! 		__fd_kern_wait_timeout.tv_sec = 3600;
! 
! 		sigprocmask(SIG_UNBLOCK, &sig_to_block, NULL);
! 
! 		/*
! 		 * There is a small but finite chance that an interrupt will
! 		 * occure between the unblock and the select. Because of this
! 		 * sig_handler_real() sets the value of __fd_kern_wait_timeout
! 		 * to zero causing the select to do a poll instead of a wait.
! 		 */
! 
! 		while ((count = machdep_sys_select(dtablesize, &fd_set_read,
! 		  &fd_set_write, NULL, &__fd_kern_wait_timeout)) < OK) {
! 			if (count == -EINTR) {
! 				return;
! 			}
! 			PANIC();
! 		}
  	
! 		for (pthread = &fd_wait_read; count && *pthread; ) {
! 			if (FD_ISSET((*pthread)->fd, &fd_set_read)) {
! 				/* Get lock on thread */
! 
! 				(*pthread)->state = PS_RUNNING;
! 				*pthread = (*pthread)->next;
! 				count--;
! 				continue;
! 			} 
! 			pthread = &((*pthread)->next);
! 		}
! 					
! 		for (pthread = &fd_wait_write; count && *pthread; ) {
! 			if (FD_ISSET((*pthread)->fd, &fd_set_write)) {
! 				semaphore *plock;
! 
! 				/* Get lock on thread */
! 				plock = &(*pthread)->lock;
! 				if (!(SEMAPHORE_TEST_AND_SET(plock))) {
! 					/* Thread locked, skip it. */
! 					(*pthread)->state = PS_RUNNING;
! 					*pthread = (*pthread)->next;
! 					SEMAPHORE_RESET(plock);
! 				}
! 				count--;
! 				continue;
! 			} 
! 			pthread = &((*pthread)->next);
! 		}
! 	} else {
! 		/* No threads, waiting on I/O, do a sigsuspend */
! 		sig_handler_pause();
! 	}
  }
  
  /* ==========================================================================
--- 142,218 ----
  
  void fd_kern_wait()
  {
!   fd_set fd_set_read, fd_set_write, fd_set_excp;
!   struct pthread **pthread;
!   sigset_t sig_to_block;
!   int count,i,type;
! 
!   if (fd_wait) {
!     FD_ZERO(&fd_set_read);
!     FD_ZERO(&fd_set_write);
!     FD_ZERO(&fd_set_excp);
!     for (pthread = &fd_wait; *pthread; pthread = &((*pthread)->next))
!       for (i = 0; i < (*pthread)->fd_cnt; i++)
!       {
!         type = (*pthread)->fd_types[i];
!         if (type & FD_READ)
!           FD_SET((*pthread)->fds[i], &fd_set_read);
!         else if (type & FD_WRITE)
!           FD_SET((*pthread)->fds[i], &fd_set_write);
!         else if (type & FD_EXCP)
!           FD_SET((*pthread)->fds[i], &fd_set_excp);
!       }
!     
!     /* Turn off interrupts for real while we set the timer.  */
! 
!     sigfillset(&sig_to_block);
!     sigprocmask(SIG_BLOCK, &sig_to_block, NULL);
! 
!     machdep_unset_thread_timer(); 
!     __fd_kern_wait_timeout.tv_usec = 0;
!     __fd_kern_wait_timeout.tv_sec = 3600;
! 
!     sigprocmask(SIG_UNBLOCK, &sig_to_block, NULL);
! 
!     /*
!     * There is a small but finite chance that an interrupt will
!     * occure between the unblock and the select. Because of this
!     * sig_handler_real() sets the value of __fd_kern_wait_timeout
!     * to zero causing the select to do a poll instead of a wait.
!     */
! 
!     while ((count = machdep_sys_select(dtablesize, &fd_set_read,
!                                        &fd_set_write, &fd_set_excp,
!                                        &__fd_kern_wait_timeout)) < OK) {
!       if (count == -EINTR) {
!         return;
!       }
!       PANIC();
!     }
  	
!     for (pthread = &fd_wait; count && *pthread; )
!       for (i = 0; *pthread && i < (*pthread)->fd_cnt; i++)
!         if (FD_ISSET((*pthread)->fds[i], &fd_set_read) ||
!             FD_ISSET((*pthread)->fds[i], &fd_set_excp) ||
!             FD_ISSET((*pthread)->fds[i], &fd_set_write))
!         {
!           semaphore *plock;
!           /* Get lock on thread */
!           plock = &(*pthread)->lock;
!           if (!(SEMAPHORE_TEST_AND_SET(plock))) {
!             /* Thread locked, skip it. */
!             (*pthread)->state = PS_RUNNING;
!             *pthread = (*pthread)->next;
!             SEMAPHORE_RESET(plock);
!           }
!           else
!             pthread = &((*pthread)->next);
!           count--;
!         }
!   } else {
!     /* No threads, waiting on I/O, do a sigsuspend */
!     sig_handler_pause();
!   }
  }
  
  /* ==========================================================================
***************
*** 250,258 ****
  			}
  
  			/* queue pthread for a FDR_WAIT */
! 			pthread_run->next = fd_wait_read;
! 			fd_wait_read = pthread_run;
! 			pthread_run->fd = fd;
  			SEMAPHORE_RESET(lock);
  			reschedule(PS_FDR_WAIT);
  		} else {
--- 246,256 ----
  			}
  
  			/* queue pthread for a FDR_WAIT */
! 			pthread_run->next = fd_wait;
! 			fd_wait = pthread_run;
!                         pthread_run->fd_cnt = 1;
! 			pthread_run->fds[0] = fd;
! 			pthread_run->fd_types[0] = FD_READ;
  			SEMAPHORE_RESET(lock);
  			reschedule(PS_FDR_WAIT);
  		} else {
***************
*** 290,298 ****
  			}
  
  			/* queue pthread for a FDR_WAIT */
! 			pthread_run->next = fd_wait_read;
! 			fd_wait_read = pthread_run;
! 			pthread_run->fd = fd;
  			SEMAPHORE_RESET(lock);
  			reschedule(PS_FDR_WAIT);
  		} else {
--- 288,298 ----
  			}
  
  			/* queue pthread for a FDR_WAIT */
! 			pthread_run->next = fd_wait;
! 			fd_wait = pthread_run;
! 			pthread_run->fd_cnt = 1;
! 			pthread_run->fds[0] = fd;
! 			pthread_run->fd_types[0] = FD_READ;
  			SEMAPHORE_RESET(lock);
  			reschedule(PS_FDR_WAIT);
  		} else {
***************
*** 330,338 ****
  			}
  
  			/* queue pthread for a FDW_WAIT */
! 			pthread_run->next = fd_wait_write;
! 			fd_wait_write = pthread_run;
! 			pthread_run->fd = fd;
  			SEMAPHORE_RESET(lock);
  			reschedule(PS_FDW_WAIT);
          } else {
--- 330,340 ----
  			}
  
  			/* queue pthread for a FDW_WAIT */
! 			pthread_run->next = fd_wait;
! 			fd_wait = pthread_run;
! 			pthread_run->fd_cnt = 1;
! 			pthread_run->fds[0] = fd;
! 			pthread_run->fd_types[0] = FD_WRITE;
  			SEMAPHORE_RESET(lock);
  			reschedule(PS_FDW_WAIT);
          } else {
***************
*** 369,377 ****
  			}
  
  			/* queue pthread for a FDW_WAIT */
! 			pthread_run->next = fd_wait_write;
! 			fd_wait_write = pthread_run;
! 			pthread_run->fd = fd;
  			SEMAPHORE_RESET(lock);
  			reschedule(PS_FDW_WAIT);
          } else {
--- 371,381 ----
  			}
  
  			/* queue pthread for a FDW_WAIT */
! 			pthread_run->next = fd_wait;
! 			fd_wait = pthread_run;
! 			pthread_run->fd_cnt = 1;
! 			pthread_run->fds[0] = fd;
! 			pthread_run->fd_types[0] = FD_WRITE;
  			SEMAPHORE_RESET(lock);
  			reschedule(PS_FDW_WAIT);
          } else {
***************
*** 919,927 ****
  				}
  
  				/* queue pthread for a FDW_WAIT */
! 				pthread_run->fd = fd_table[fd]->fd.i;
! 				pthread_run->next = fd_wait_write;
! 				fd_wait_write = pthread_run;
  				SEMAPHORE_RESET(lock);
  				reschedule(PS_FDW_WAIT);
  
--- 923,933 ----
  				}
  
  				/* queue pthread for a FDW_WAIT */
! 				pthread_run->fd_cnt = 1;
! 				pthread_run->fds[0] = fd_table[fd]->fd.i;
! 				pthread_run->fd_types[0] = FD_READ;
! 				pthread_run->next = fd_wait;
! 				fd_wait = pthread_run;
  				SEMAPHORE_RESET(lock);
  				reschedule(PS_FDW_WAIT);
  
***************
*** 969,978 ****
  				}
  
  				/* queue pthread for a FDR_WAIT */
! 				pthread_run->fd = fd_table[fd]->fd.i;
! 				pthread_run->next = fd_wait_write;
! 				pthread_run->next = fd_wait_read;
! 				fd_wait_read = pthread_run;
  				SEMAPHORE_RESET(lock);
  				reschedule(PS_FDR_WAIT);
              } else {
--- 975,985 ----
  				}
  
  				/* queue pthread for a FDR_WAIT */
! 				pthread_run->fd_cnt = 1;
! 				pthread_run->fds[0] = fd_table[fd]->fd.i;
! 				pthread_run->fd_types[0] = FD_READ;
! 				pthread_run->next = fd_wait;
! 				fd_wait = pthread_run;
  				SEMAPHORE_RESET(lock);
  				reschedule(PS_FDR_WAIT);
              } else {
***************
*** 1038,1046 ****
  				}
  
  				/* queue pthread for a FDW_WAIT */
! 				pthread_run->fd = fd_table[fd]->fd.i;
! 				pthread_run->next = fd_wait_write;
! 				fd_wait_write = pthread_run;
  				SEMAPHORE_RESET(lock);
  				reschedule(PS_FDW_WAIT);
  
--- 1045,1055 ----
  				}
  
  				/* queue pthread for a FDW_WAIT */
! 				pthread_run->fd_cnt = 1;
! 				pthread_run->fds[0] = fd_table[fd]->fd.i;
! 				pthread_run->fd_types[0] = FD_WRITE;
! 				pthread_run->next = fd_wait;
! 				fd_wait = pthread_run;
  				SEMAPHORE_RESET(lock);
  				reschedule(PS_FDW_WAIT);
  
***************
*** 1083,1091 ****
  				}
  
  				/* queue pthread for a FDW_WAIT */
! 				pthread_run->fd = fd_table[fd]->fd.i;
! 				pthread_run->next = fd_wait_write;
! 				fd_wait_write = pthread_run;
  				SEMAPHORE_RESET(lock);
  				reschedule(PS_FDW_WAIT);
  
--- 1092,1102 ----
  				}
  
  				/* queue pthread for a FDW_WAIT */
! 				pthread_run->fd_cnt = 1;
! 				pthread_run->fds[0] = fd_table[fd]->fd.i;
! 				pthread_run->fd_types[0] = FD_WRITE;
! 				pthread_run->next = fd_wait;
! 				fd_wait = pthread_run;
  				SEMAPHORE_RESET(lock);
  				reschedule(PS_FDW_WAIT);
  
***************
*** 1152,1160 ****
  				}
  
  				/* queue pthread for a FDR_WAIT */
! 				pthread_run->fd = fd_table[fd]->fd.i;
! 				pthread_run->next = fd_wait_read;
! 				fd_wait_write = pthread_run;
  				SEMAPHORE_RESET(lock);
  				reschedule(PS_FDW_WAIT);
              } else {
--- 1163,1173 ----
  				}
  
  				/* queue pthread for a FDR_WAIT */
! 				pthread_run->fd_cnt = 1;
! 				pthread_run->fds[0] = fd_table[fd]->fd.i;
! 				pthread_run->fd_types[0] = FD_WRITE;
! 				pthread_run->next = fd_wait;
! 				fd_wait = pthread_run;
  				SEMAPHORE_RESET(lock);
  				reschedule(PS_FDW_WAIT);
              } else {
***************
*** 1194,1203 ****
  				}
  
  				/* queue pthread for a FDR_WAIT */
! 				pthread_run->fd = fd_table[fd]->fd.i;
! 				pthread_run->next = fd_wait_write;
! 				pthread_run->next = fd_wait_read;
! 				fd_wait_read = pthread_run;
  				SEMAPHORE_RESET(lock);
  				reschedule(PS_FDR_WAIT);
              } else {
--- 1207,1217 ----
  				}
  
  				/* queue pthread for a FDR_WAIT */
! 				pthread_run->fd_cnt = 1;
! 				pthread_run->fds[0] = fd_table[fd]->fd.i;
! 				pthread_run->fd_types[0] = FD_READ;
! 				pthread_run->next = fd_wait;
! 				fd_wait = pthread_run;
  				SEMAPHORE_RESET(lock);
  				reschedule(PS_FDR_WAIT);
              } else {
***************
*** 1239,1247 ****
  				}
  
  				/* queue pthread for a FDR_WAIT */
! 				pthread_run->fd = fd_table[fd]->fd.i;
! 				pthread_run->next = fd_wait_read;
! 				fd_wait_read = pthread_run;
  				SEMAPHORE_RESET(lock);
  				reschedule(PS_FDR_WAIT);
              } else {
--- 1253,1263 ----
  				}
  
  				/* queue pthread for a FDR_WAIT */
! 				pthread_run->fd_cnt = 1;
! 				pthread_run->fds[1] = fd_table[fd]->fd.i;
! 				pthread_run->fd_types[1] = FD_READ;
! 				pthread_run->next = fd_wait;
! 				fd_wait = pthread_run;
  				SEMAPHORE_RESET(lock);
  				reschedule(PS_FDR_WAIT);
              } else {
***************
*** 1280,1288 ****
  				}
  
  				/* queue pthread for a FDR_WAIT */
! 				pthread_run->fd = fd_table[fd]->fd.i;
! 				pthread_run->next = fd_wait_read;
! 				fd_wait_read = pthread_run;
  				SEMAPHORE_RESET(lock);
  				reschedule(PS_FDR_WAIT);
              } else {
--- 1296,1306 ----
  				}
  
  				/* queue pthread for a FDR_WAIT */
! 				pthread_run->fd_cnt = 1;
! 				pthread_run->fds[0] = fd_table[fd]->fd.i;
! 				pthread_run->fd_types[0] = FD_READ;
! 				pthread_run->next = fd_wait;
! 				fd_wait = pthread_run;
  				SEMAPHORE_RESET(lock);
  				reschedule(PS_FDR_WAIT);
              } else {
***************
*** 1356,1363 ****
  		}
  	default:
  		pthread_run->error = EBADF;
! 		ret = -EBADF;
  		break;
  	}
  	return(ret);
  }
--- 1374,1589 ----
  		}
  	default:
  		pthread_run->error = EBADF;
! 		ret = EBADF;
  		break;
  	}
  	return(ret);
+ }
+ 
+ /* ==========================================================================
+  * select(), timeout not implemented
+  */
+ 
+ int select(int numfds,fd_set *readfds,fd_set *writefds,
+            fd_set *exceptfds,struct timeval *timeout)
+ {
+   int i,j,ret = 0,blocking_select;
+   /* save locked fd for easy cleanup */
+   fd_set read_locks,write_locks,rdwr_locks;
+   fd_set real_exceptfds,real_readfds,real_writefds; /* mapped fd_sets */
+   fd_set save_real_exceptfds,save_real_readfds,save_real_writefds;
+   fd_set *real_readfds_p,*real_writefds_p,*real_exceptfds_p;
+   int got_all_locks = 1;
+   int nonblock_flags = __FD_NONBLOCK;
+   semaphore *lock,*plock;
+   struct timeval zero_timeout = {0,0};
+ 
+   FD_ZERO(&read_locks);
+   FD_ZERO(&write_locks);
+   FD_ZERO(&rdwr_locks);
+   FD_ZERO(&real_readfds);
+   FD_ZERO(&real_writefds);
+   FD_ZERO(&real_exceptfds);
+   
+   /* lock readfds */
+   if (readfds != NULL)
+     for (i = 0; i < numfds; i++)
+       if (FD_ISSET(i,readfds) || (exceptfds != NULL && FD_ISSET(i,exceptfds)))
+       {
+ 	if (writefds != NULL && FD_ISSET(i,writefds))
+         {
+           if ((ret = fd_lock(i,FD_RDWR)) != OK)
+           {
+             got_all_locks = 0;
+             break;
+           }
+           FD_SET(i,&rdwr_locks);
+         }
+         else
+         {
+           if ((ret = fd_lock(i,FD_READ)) != OK)
+           {
+             got_all_locks = 0;
+             break;
+           }
+           FD_SET(i,&read_locks);
+         }
+         if (FD_ISSET(i,readfds))
+           FD_SET(fd_table[i]->fd.i,&real_readfds);
+         else
+           FD_SET(fd_table[i]->fd.i,&real_exceptfds);
+         nonblock_flags &= fd_table[i]->flags;
+       }
+   if (got_all_locks && writefds != NULL)
+     /* lock writefds */
+     for (i = 0; i < numfds; i++)
+       if (FD_ISSET(i,writefds))
+       {
+         if (!(readfds != NULL && FD_ISSET(i,readfds)) &&
+             !(exceptfds != NULL && FD_ISSET(i,exceptfds)))
+         {                       /* only lock if no FD_RDWR lock */
+           if ((ret = fd_lock(i,FD_WRITE)) != OK)
+           {
+             got_all_locks = 0;
+             break;
+           }
+           FD_SET(i,&write_locks);
+         }
+         FD_SET(fd_table[i]->fd.i,&real_writefds);
+         nonblock_flags &= fd_table[i]->flags;
+       }
+ 
+   if (got_all_locks)
+   {
+     memcpy(&save_real_readfds,&real_readfds,sizeof(fd_set));
+     memcpy(&save_real_writefds,&real_writefds,sizeof(fd_set));
+     memcpy(&save_real_exceptfds,&real_exceptfds,sizeof(fd_set));
+     real_readfds_p = (readfds == NULL) ? NULL : &real_readfds;
+     real_writefds_p = (writefds == NULL) ? NULL : &real_writefds;
+     real_exceptfds_p = (exceptfds == NULL) ? NULL : &real_exceptfds;
+     while ((ret = machdep_sys_select(dtablesize,
+                                      real_readfds_p,real_writefds_p,
+                                      real_exceptfds_p,&zero_timeout)) <= OK)
+     {
+       memcpy(&real_readfds,&save_real_readfds,sizeof(fd_set));
+       memcpy(&real_writefds,&save_real_writefds,sizeof(fd_set));
+       memcpy(&real_exceptfds,&save_real_exceptfds,sizeof(fd_set));
+       if (!nonblock_flags && (ret == 0) && timeout == NULL)
+       {
+         /* lock queue */
+         lock = &fd_wait_lock;
+         while (SEMAPHORE_TEST_AND_SET(lock))
+           pthread_yield();
+ 
+         /* lock pthread */
+         plock = &(pthread_run->lock);
+         while (SEMAPHORE_TEST_AND_SET(plock))
+           pthread_yield();
+ 
+         /* queue pthread for a FDW_WAIT */
+         j = 0;
+         for (i = 0; i < dtablesize; i++)
+           if (FD_ISSET(i,&real_writefds) || FD_ISSET(i,&real_readfds) ||
+               FD_ISSET(i,&real_exceptfds))
+           {
+             if (FD_ISSET(i,&real_readfds))
+                 pthread_run->fd_types[j] = FD_READ;
+             if (FD_ISSET(i,&real_writefds))
+                 pthread_run->fd_types[j] |= FD_WRITE;
+             if (FD_ISSET(i,&real_writefds))
+                 pthread_run->fd_types[j] |= FD_EXCP;
+             pthread_run->fds[j] = i;
+             j++;
+           }
+         pthread_run->fd_cnt = j;
+         pthread_run->next = fd_wait;
+ 	fd_wait = pthread_run;
+         SEMAPHORE_RESET(lock);
+         reschedule(PS_FDR_WAIT);
+       }
+       else
+       {
+         pthread_run->error = -ret;
+         break;
+       }
+     }
+   }
+   /* clean up the locks */
+   for (i = 0; i < numfds; i++)
+     if (FD_ISSET(i,&read_locks)) fd_unlock(i,FD_READ);
+   for (i = 0; i < numfds; i++)
+     if (FD_ISSET(i,&rdwr_locks)) fd_unlock(i,FD_RDWR);
+   for (i = 0; i < numfds; i++)
+     if (FD_ISSET(i,&write_locks)) fd_unlock(i,FD_WRITE);
+ 
+   if (ret > 0)
+   {
+     if (readfds != NULL)
+       for (i = 0; i < numfds; i++)
+         if (! (FD_ISSET(i,readfds) &&
+                FD_ISSET(fd_table[i]->fd.i,&real_readfds)))
+           FD_CLR(i,readfds);
+     if (writefds != NULL)
+       for (i = 0; i < numfds; i++)
+         if (! (FD_ISSET(i,writefds) &&
+                FD_ISSET(fd_table[i]->fd.i,&real_writefds)))
+           FD_CLR(i,writefds);
+     if (exceptfds != NULL)
+       for (i = 0; i < numfds; i++)
+         if (! (FD_ISSET(i,exceptfds) &&
+                FD_ISSET(fd_table[i]->fd.i,&real_exceptfds)))
+           FD_CLR(i,exceptfds);
+   }
+   else
+   {
+     if (readfds != NULL) FD_ZERO(readfds);
+     if (writefds != NULL) FD_ZERO(writefds);
+     if (exceptfds != NULL) FD_ZERO(exceptfds);
+   }
+   
+   return ret;
+ }
+ 
+ int setsockopt (int fd, int level, int optname,
+ 		const void *optval, int optlen)
+ {
+   int ret;
+   if ((ret = fd_lock(fd, FD_WRITE)) == OK)
+   {
+     if ((ret = machdep_sys_setsockopt(fd_table[fd]->fd.i,level,optname,
+                                       optval,optlen)) < OK) {
+       pthread_run->error = -ret;
+     }
+     fd_unlock(fd, FD_WRITE);
+   }
+   return ret;
+ }
+ 
+ int getsockopt (int fd, int level, int optname,
+                 void *optval, int *optlen)
+ {
+   int ret;
+   if ((ret = fd_lock(fd, FD_READ)) == OK)
+   {
+     if ((ret = machdep_sys_getsockopt(fd_table[fd]->fd.i,level,optname,
+                                       optval,optlen)) < OK) {
+       pthread_run->error = -ret;
+     }
+     fd_unlock(fd, FD_READ);
+   }
+   return ret;
+ }
+ 
+ int getpeername (int fd, struct sockaddr *peer,int *paddrlen)
+ {
+   int ret;
+   if ((ret = fd_lock(fd, FD_READ)) == OK)
+   {
+     if ((ret = machdep_sys_getpeername(fd_table[fd]->fd.i,peer,paddrlen))
+         < OK) {
+       pthread_run->error = -ret;
+     }
+     fd_unlock(fd, FD_READ);
+   }
+   return ret;
  }
*** syscall-sparc-sunos-4.1.3.S	Sat Aug 27 06:05:13 1994
--- /home/peter/tmp/pthreads/machdep/syscall-sparc-sunos-4.1.3.S	Thu Oct  6 13:04:56 1994
***************
*** 269,274 ****
--- 269,279 ----
  SYSCALL(shutdown)
  
  /* ==========================================================================
+  * machdep_sys_setsockopt()
+  */
+ SYSCALL(setsockopt)
+ 
+ /* ==========================================================================
   * machdep_sys_getpgrp()
   *
   * POSIX-compliant getpgrp() takes no arguments.  The SunOS syscall wants
*** pthread.h	Mon Aug  8 05:39:12 1994
--- /home/peter/tmp/pthreads/include/pthread.h	Mon Oct  3 00:12:18 1994
***************
*** 111,117 ****
  	struct pthread			*next;		/* Standard for mutexes, etc ... */
  	/* struct pthread			*fd_next;	 For kernel fd operations */
  
! 	int						fd;			/* Used when thread waiting on fd */
  
  	semaphore				lock;
  
--- 111,119 ----
  	struct pthread			*next;		/* Standard for mutexes, etc ... */
  	/* struct pthread			*fd_next;	 For kernel fd operations */
  
! 	int                             fds[64];	/* Used when thread waiting on fd */
!         int                             fd_types[64];
!         int                             fd_cnt;         /* number of fds */
  
  	semaphore				lock;
  
*** fd.h	Wed Aug 24 08:01:36 1994
--- /home/peter/tmp/pthreads/include/pthread/fd.h	Mon Oct  3 00:12:20 1994
***************
*** 56,61 ****
--- 56,62 ----
  #define FD_READ				0x1
  #define FD_WRITE			0x2
  #define FD_RDWR				(FD_READ | FD_WRITE)
+ #define FD_EXCP                         0x4
  
  struct fd_ops {
  	ssize_t 				(*write)();

-- 
Peter Hofmann                     e-mail: peterh@prz.tu-berlin.de
Technical University Berlin
Str. des 17. Juni 135             Tel. ++49-(0)30-314-21701
D-10623 Berlin, Germany

