#!/usr/athena/bin/perl
use warnings;
use strict;
use Text::Wrap;
use Text::Tabs;

sub center ($@) {
  my ($wid, @lines) = @_;
  map ' ' x (($wid - length)/2) . $_ . "\n", @lines;
}
sub spread ($$$) {
  my ($wid, $left, $right) = @_;
  return $left . "\n" unless length $right;
  my $lleft = length $left;
  my $lright = length $right;
  $lleft + $lright > $wid
    ? $left . "\n" . ' ' x ($wid - $lright) . $right . "\n"
      : $left . ' ' x ($wid - $lleft - $lright) . $right . "\n";
}

sub textify ($) {
  my ($text) = @_;

  # should also convert \v{c}, \'{c}, \v{s}, \v{z} into ISO 8859-2.
  $text =~ s@ \\ [/-] @@gx;
  $text =~ s/ { \\tsl \s* ( (?: [^{}] | { [^{}]* } )*?) ( [,:;.!?]? ) }
            /_$1_$2/gxm;
  $text =~ s/ \\bullet /*/gx;
  $text =~ s/ ~ / /gx;           $text =~ s/ \\kern \s* \d+ \s* \w+ / /gx;
  $text =~ s/ \\ \w+ \s* //gx;   $text =~ s/ [\${}] //gx;

  $text =~ s/ ^ \s+ //sx;  $text =~ s/ \s+ $ //sx;  $text =~ s/\.\n/.  /g;
  $text =~ s/ (?: \n | \s{3,} )+ / /gsx;
  $text;
}

use constant WIDTH => 75;
local($Text::Wrap::columns) = WIDTH + 1;
local($/) = '';

my $start = 1;

my $tex_arg = qr/ { ( (?: [^{}] | { [^{}]* } )* ) } /x;
my $no_arg = qr/ () /x;

while (<>) {
  s/ (?<! \\) % .* $ \n? //gxm;  s/ \\% /%/gx;
  / \S /x || next;
  if ($start) {
    / \\centerline \b/x or next;
    $start = 0;

    foreach my $cl (/ \\centerline{ ( (?: [^{}] | { [^{}]+ } )+ ) } /xg) {
      print center WIDTH, textify $cl;
    }
    next;
  }

  if (my ($extra, $sec, $rest) = / ^ \\(d?)ident { ([^{}]*) } (.*) $ /sx) {

    print "\n", textify $sec, "\n" if $sec;

    my $time_arg = $extra ? $tex_arg : $no_arg;
    my ($who, $where, $when, $body) =
      ($rest =~ / ^ $tex_arg \s* $tex_arg \s* $time_arg \s* (.*) $ /sx)
	or die "Bad frag `$rest'";

    print "\n";
    print spread WIDTH, textify $who, textify $where;
    print textify $when, "\n" if $when;

    $_ = $body;
  }

  my $text = expand wrap '', '', textify $_;
  $text =~ s/ \s+ $ //gxm;
  print "\n", $text, "\n" if length $text;
}
