// Copyright 1995 Barbara Liskov

#ifndef _FILE_H
#define _FILE_H

#include "6170.h"

class file {
    // Overview:
    //  A "file" represents a single item in a database describing files.

  public:

    file(string line);
    // checks   The line is in the format produced by the Unix command 
    //          "ls -lLd" on DecStations (assuming leftmost char is 0th): 
    //          chars 14-21: owner
    //          chars 22-30: size
    //          chars 32-43: time
    //          chars 45-EOL: name
    // effects  Parse an input line and create a new "file" from it.

    string owner();
    // effects  Return the "owner" attribute.

    int size();
    // effects  Return the "size" attribute.
    
    string time();
    // effects  Return the time stamp on the file, in either
    //          "MM/DD/YYYY" or "MM/DD/HH:MM" format.
    
    string name();
    // effects  Return the "name attribute".

    string line();
    // effects  Return the string that the file was parsed from
    //          originally.

  private:

    // The representation
    string file_line;    // The full file info
    int file_size;       // Size of the file
    string file_owner, file_time, file_name; // Other attributes
};

#endif /* _FILE_H */
