// Copyright 1995 Massachusetts Institute of Technology

#include "6170.h"
#include "database.h"
#include "file.h"
#include <stdlib.h>
#include <errno.h>

static void check_input(bool ok, string &key) {
    if (!ok) {
	cerr << "Unexpected end of user input.\n";
	exit(EXIT_FAILURE);
    }
    if (key == "quit") {
	cerr << "Done.\n";
	exit(EXIT_SUCCESS);
    }
}

int main(int argc, char *argv[]) {
    if (argc != 2) {
	cerr << "Usage: " << argv[0] << " <database-file>\n";
	exit(EXIT_FAILURE);
    }
    ifstream inp(argv[1]);
    if (!inp) {
	perror(argv[1]);
	exit(EXIT_FAILURE);
    }
    database *d = new database(inp);

    for (;;) {
	string name;
	string owner;
	string times;
	string minsize_s;
	cout << "Filename: ";
	check_input(read_line(cin, name), name);
	cout << "Owner: ";
	check_input(read_line(cin, owner), owner);
	cout << "Time range: ";
	check_input(read_line(cin, times), times);
	cout << "Minimum size: ";
	check_input(read_line(cin, minsize_s), minsize_s);
	int minsize = atoi(minsize_s.get_chars());
	string errmsg;
	generator<file *> *files = d->satisfiers(name, owner, times, minsize,
						 errmsg);
	if (!files) {
	    cerr << errmsg << "\n";
	} else {
	    file *f;
	    while (files->get(f)) {
		cout << f->line() << "\n";
	    }
	}
    }
}
