/* All the defines used by our code.  Because the preprocessor sucks/is lame, 
   defines are global, so put them all together */

#define ENGINE1       0
#define ENGINE2       2
#define GRASPER_GRASP 1
#define GRASPER_VERT  3
#define ROTATOR_SPIN  4
#define SPEAR_MOTOR   5

#define FULL_AHEAD 100
#define HALF_AHEAD 50
#define QUARTER_AHEAD 25
#define STOP 0
#define QUARTER_REVERSE -25
#define HALF_REVERSE -50
#define FULL_REVERSE -100

/* Turns */
#define CENTER 75.0
#define STRAIGHT CENTER
#define HARD_RIGHT (CENTER+20.0)
#define RIGHT (CENTER+15.0)
#define SOFT_RIGHT (CENTER+10.0)
#define SOFT_LEFT (CENTER-10.0)
#define LEFT (CENTER-15.0)
#define HARD_LEFT (CENTER-20.0)

#define TRUE 1
#define FALSE 0
#define ON 1
#define OFF 0
#define BLACK 0
#define WHITE 1
#define UNKNOWN 2
#define OPEN 1
#define CLOSED 0
#define RAISED 1
#define LOWERED 0

#define FRONT 0
#define MID 1
#define BACK 2

/* Misc */
#define TIMEOUT_TO_MID 15.0
#define TIMEOUT_FOR_SEARCH 1

#define NORTH 0
#define EAST  1
#define SOUTH 2
#define WEST  3

/* DIGITAL sensors 0-7 */
/* Encoders must be on 0-1 */
#define DRIVE_ENCODER 0
#define ROTATOR_ENCODER 1
#define LIMIT_CLAMP_IN 2
#define LIMIT_CLAMP_OUT 3

/* Sharp IR must be on 4-7 */
#define NORTH_IR 4
#define EAST_IR  5
#define SOUTH_IR 6
#define WEST_IR  7

/* 8-11 are dip switches */
/* ANALOG sensors 12-27 */

/* Note that the next 4 are flipped from what the physical wires say */
#define SOUTH_PHOTO 12
#define NORTH_PHOTO 13
#define WEST_PHOTO 14
#define EAST_PHOTO 15
#define FRONT_LEFT_REFL 16
#define FRONT_RIGHT_REFL 17
#define MID_LEFT_REFL 	18
#define MID_MID_REFL 	19
#define MID_RIGHT_REFL 	20
#define BACK_LEFT_REFL 	21
#define BACK_RIGHT_REFL 22
#define LIMIT_CLAMP_TOP 23
#define LIMIT_CLAMP_BOTTOM 24
#define FRONT_BUMPER 27

/* Locations */
#define STARTING_SQUARE 0
#define SQUARE_EDGE 1
#define SEGMENT_ONE 2
#define CROSS 3

#define FR 0
#define FL 1
#define MR 2
#define MM 3
#define ML 4
#define BR 5
#define BL 6

#define DISTANCE_TO_CROSS 1000 /* by trial and error */
#define NEAR_CROSS 700
#define NEAR_FIRST_BLOCK 450
#define GRASPER_TIMEOUT 50000L
#define RAISE_SPEAR_TIME 50L
#define SPEAR_BLOCK_TIME 200L
#define LIMIT_CLAMP_THRESHOLD 128
#define BUMP_SENSOR_THRESHOLD 128
#define RIGHT_ANGLE_DISTANCE 90
#define HALF_TURN_DISTANCE 180

#define GRASPER_RAISE 100
#define GRASPER_LOWER -100
#define GRASPER_OPEN  25
#define GRASPER_CLOSE -10
#define ROTATOR_CLOCKWISE 100
#define ROTATOR_COUNTER_CLOCKWISE -100
