int MAX(int a, int b) {
    if (a>b)
	return(a);
    else
	return(b);
}

int MIN(int a, int b) {
    if (a<b)
	return(a);
    else
	return(b);
}

int abs(int a) {
    if (a >= 0)
	return(a);
    else
	return(-a);
}

float fabs(float a) {
    if (a >= 0.0)
	return(a);
    else
	return(-a);
}

void InitReflGrid() {
    int x;
    
    for(x=FR; x<=BL; x++)
	Refl_Grid[x].Value = WHITE;
    
    Refl_Grid[FR].Sensor = FRONT_RIGHT_REFL;
    Refl_Grid[FL].Sensor = FRONT_LEFT_REFL;
    Refl_Grid[MR].Sensor = MID_RIGHT_REFL;
    Refl_Grid[MM].Sensor = MID_MID_REFL;
    Refl_Grid[ML].Sensor = MID_LEFT_REFL;
    Refl_Grid[BR].Sensor = BACK_RIGHT_REFL;
    Refl_Grid[BL].Sensor = BACK_LEFT_REFL;
}

void CalibrateRefls() {
    int fr, fl, mr, mm, ml, br, bl; /* diffs on all the sensors */
    
    printf("C to Recal, E to skip\n");
    while(1) {
      if(escape_button()) {
	while(escape_button());
	return;
      }
      if(choose_button()) {
	while(choose_button());
	break;
      }
    }
    printf("FR & FL on BLACK\n");
    while(!choose_button());
    while(choose_button());
    Refl_Grid[FR].BlackThreshold = analog(Refl_Grid[FR].Sensor);
    Refl_Grid[FL].BlackThreshold = analog(Refl_Grid[FL].Sensor);
    printf("MR, MM & ML on BLACK\n");
    while(!choose_button());
    while(choose_button());
    Refl_Grid[MR].BlackThreshold = analog(Refl_Grid[MR].Sensor);
    Refl_Grid[MM].BlackThreshold = analog(Refl_Grid[MM].Sensor);
    Refl_Grid[ML].BlackThreshold = analog(Refl_Grid[ML].Sensor);
/*    printf("BR & BL on BLACK\n");
    while(!choose_button());
    while(choose_button()); */
    Refl_Grid[BR].BlackThreshold = analog(Refl_Grid[BR].Sensor);
    Refl_Grid[BL].BlackThreshold = analog(Refl_Grid[BL].Sensor);

    printf("ALL on WHITE\n");
    while(!choose_button());
    while(choose_button());
    Refl_Grid[FR].WhiteThreshold = analog(Refl_Grid[FR].Sensor);
    Refl_Grid[FL].WhiteThreshold = analog(Refl_Grid[FL].Sensor);
    Refl_Grid[MR].WhiteThreshold = analog(Refl_Grid[MR].Sensor);
    Refl_Grid[MM].WhiteThreshold = analog(Refl_Grid[MM].Sensor);
    Refl_Grid[ML].WhiteThreshold = analog(Refl_Grid[ML].Sensor);
    Refl_Grid[BR].WhiteThreshold = analog(Refl_Grid[BR].Sensor);
    Refl_Grid[BL].WhiteThreshold = analog(Refl_Grid[BL].Sensor);
/*
    printf("%d %d %d %d %d %d %d %d\n", Refl_Grid[FR].BlackThreshold,
	   Refl_Grid[FL].BlackThreshold, Refl_Grid[MR].BlackThreshold ,
	   Refl_Grid[ML].BlackThreshold , Refl_Grid[FR].WhiteThreshold ,
	   Refl_Grid[FL].WhiteThreshold , Refl_Grid[MR].WhiteThreshold ,
	   Refl_Grid[ML].WhiteThreshold);
    while(!choose_button());
    while(choose_button());
    */  
	/* Now divide middle area in thReflds */

    fr = Refl_Grid[FR].BlackThreshold - Refl_Grid[FR].WhiteThreshold;
    fl = Refl_Grid[FL].BlackThreshold - Refl_Grid[FL].WhiteThreshold;
    mr = Refl_Grid[MR].BlackThreshold - Refl_Grid[MR].WhiteThreshold;
    mm = Refl_Grid[MM].BlackThreshold - Refl_Grid[MM].WhiteThreshold;
    ml = Refl_Grid[ML].BlackThreshold - Refl_Grid[ML].WhiteThreshold;
    br = Refl_Grid[BR].BlackThreshold - Refl_Grid[BR].WhiteThreshold;
    bl = Refl_Grid[BL].BlackThreshold - Refl_Grid[BL].WhiteThreshold;

    Refl_Grid[FR].BlackThreshold = Refl_Grid[FR].BlackThreshold - (fr /3);
    Refl_Grid[FL].BlackThreshold = Refl_Grid[FL].BlackThreshold - (fl /3);
    Refl_Grid[MR].BlackThreshold = Refl_Grid[MR].BlackThreshold - (mr /3);
    Refl_Grid[MM].BlackThreshold = Refl_Grid[MM].BlackThreshold - (mm /3);
    Refl_Grid[ML].BlackThreshold = Refl_Grid[ML].BlackThreshold - (ml /3);
    Refl_Grid[BR].BlackThreshold = Refl_Grid[BR].BlackThreshold - (br /3);
    Refl_Grid[BL].BlackThreshold = Refl_Grid[BL].BlackThreshold - (bl /3);

    Refl_Grid[FR].WhiteThreshold = Refl_Grid[FR].WhiteThreshold + (fr /3);
    Refl_Grid[FL].WhiteThreshold = Refl_Grid[FL].WhiteThreshold + (fl /3);
    Refl_Grid[MR].WhiteThreshold = Refl_Grid[MR].WhiteThreshold + (mr /3);
    Refl_Grid[MM].WhiteThreshold = Refl_Grid[MM].WhiteThreshold + (mm /3);
    Refl_Grid[ML].WhiteThreshold = Refl_Grid[ML].WhiteThreshold + (ml /3);
    Refl_Grid[BR].WhiteThreshold = Refl_Grid[BR].WhiteThreshold + (br /3);
    Refl_Grid[BL].WhiteThreshold = Refl_Grid[BL].WhiteThreshold + (bl /3);
/*
    printf("%d %d %d %d %d %d %d %d\n", Refl_Grid[FR].BlackThreshold,
	   Refl_Grid[FL].BlackThreshold, Refl_Grid[MR].BlackThreshold ,
	   Refl_Grid[ML].BlackThreshold , Refl_Grid[FR].WhiteThreshold ,
	   Refl_Grid[FL].WhiteThreshold , Refl_Grid[MR].WhiteThreshold ,
	   Refl_Grid[ML].WhiteThreshold);
    while(!choose_button());
    while(choose_button());
    */  

    printf("Thank you.  Calibration done\n");
    sleep(0.2);
}

