#define DEF_CLICKS 90
#define DEF_SPEED 100

void main() {
    int clicks, speed, tqspeed, oclicks, nclicks;
    int lbreak = 0;
    
    led_out0(ON);
    led_out1(ON);
    
    clicks = DEF_CLICKS;
    speed = DEF_SPEED;


    enable_encoder(ROTATOR_ENCODER);
    while(1) {
	
	printf("C for default, E for new\n");
	while(1) {
	    if(choose_button()) {
		while(choose_button());
		break;
	    }
	    if(escape_button()) {
		while(escape_button());
		
		while(!choose_button()) {
		    printf("Frob dist [%d], then Choose\n",
			   clicks);
		    clicks = 50 + frob_knob()/5;
		    sleep(.2);
		}
		while(choose_button());
		break;
	    }
	}
	
	printf("Choose to orient at S:%d D:%d\n",speed, clicks);
	while(!choose_button());
	while(choose_button());
	
	reset_encoder(ROTATOR_ENCODER);
	
	oclicks = clicks / 10;
	nclicks = 9*oclicks;
	tqspeed = (speed * 3)/4;

#if(0)
	oclicks*=2;
	nclicks*=2;
	clicks*=2;
#endif

	motor(ROTATOR_SPIN, tqspeed);
	while(read_encoder(ROTATOR_ENCODER) < oclicks);

	motor(ROTATOR_SPIN, speed);
	while(read_encoder(ROTATOR_ENCODER) < nclicks);

	motor(ROTATOR_SPIN, tqspeed);
	while(read_encoder(ROTATOR_ENCODER) < clicks);
	
	motor(ROTATOR_SPIN, STOP);
	
	printf("dist=%d\n",read_encoder(ROTATOR_ENCODER));
	sleep(2.0);
	
	printf("C to continue, E to retract\n");
	while(1) {
	    if(choose_button()) {
		while(choose_button());
		break;
	    }
	    if(escape_button()) {
		while(escape_button());
		lbreak = 1;
		break;
	    }
	}
	if (lbreak)
	    break;
    }
    disable_encoder(ROTATOR_ENCODER);

    RaiseGrasper();
    
}

int RaiseGrasper() {
    long x = 0L;
    motor(GRASPER_VERT, GRASPER_RAISE);
    while((analog(LIMIT_CLAMP_TOP) > LIMIT_CLAMP_THRESHOLD)
	  && (x < GRASPER_TIMEOUT))
	x++;
    motor(GRASPER_VERT, STOP);
    return RAISED;
}
