#include "types.h"
#include "memblock.h"
#include "ether.h"
#include "ipv4.h"
#include <memory.h>
#include <malloc.h>


/* Unpacks only the IP fields relative to routing, desktination,
   TTL and checksum. */

ipv4_packet *unpack_ipv4_packet(ether_packet *data)
{
  ipv4_packet *result;

  /* payload_offset is always 14 or 22, so these offsets are all
     within the first memblock, i.e. 64 bytes */

  result = (ipv4_packet *) malloc(sizeof(ipv4_packet));
  result->data = data;
  result->ttl = data->payload_start[8];

  result->cksum = SWAP16(*((u16*)(data->payload_start+10)));
  result->dest = SWAP32(*((u32 *)(data->payload_start+16)));
  return result;
}


ether_packet *pack_ipv4_packet(ipv4_packet *ipp)
{
  ether_packet *result=ipp->data;

  result->payload_start[8] = ipp->ttl;

  *((u16*)(result->payload_start+10)) = SWAP16(ipp->cksum);

  *((u32 *)(result->payload_start+16)) = SWAP32(ipp->dest);

  return result;
}
