.\"
.\" %nmhwarning%
.\" $Id: mh-sequence.man,v 1.1.1.1 1999-02-07 18:14:20 danw Exp $
.\"
.\" include the -mh macro file
.so %etcdir%/tmac.h
.\"
.TH MH-SEQUENCE %manext5% MH.6.8 [%nmhversion%]
.SH NAME
mh-sequence \- sequence specification for nmh message system
.SH SYNOPSIS
.in +.5i
.ti -.5i
most \fInmh\fR commands
.in -.5i
.SH DESCRIPTION
A sequence (or sequence set) is a symbolic name representing a
message or collection of messages.  \fInmh\fP has several internally
defined sequences, as well as allowing users to define their own
sequences.

.Uh "Message Specification and Pre\-Defined Message Sequences"
Most \fInmh\fP commands accept a `msg' or `msgs' specification, where
`msg' indicates one message and `msgs' indicates one or more messages.
To designate a message, you may use either its number (e.g., 1, 10, 234)
or one of these \*(lqreserved\*(rq message names:
.in +.5i
.sp 1
.nf
.ta +\w'\fIName\fP      'u
\fIName\fP	\fIDescription\fR
first	the first message in the folder
last	the last message in the folder
cur	the most recently accessed message
prev	the message numerically preceding \*(lqcur\*(rq
next	the message numerically following \*(lqcur\*(rq
.re
.fi
.in -.5i

In commands that take a `msg' argument, the default is \*(lqcur\*(rq.
As a shorthand, \*(lq\&.\*(rq is equivalent to \*(lqcur\*(rq.

For example: In a folder containing five messages numbered 5, 10, 94, 177
and 325, \*(lqfirst\*(rq is 5 and \*(lqlast\*(rq is 325.  If \*(lqcur\*(rq
is 94, then \*(lqprev\*(rq is 10 and \*(lqnext\*(rq is 177.

The word `msgs' indicates that one or more messages may be specified.
Such a specification consists of one message designation or of several
message designations separated by spaces.  A message designation consists
either of a message name as defined above, or a message range.

A message range is specified as \*(lqname1\-name2\*(rq or
\*(lqname:n\*(rq, where `name', `name1' and `name2' are message names,
and `n' is an integer.

The specification \*(lqname1\-name2\*(rq designates all currently existing
messages from `name1' to `name2' inclusive.  The \*(lqreserved\*(rq
message name \*(lqall\*(rq is a shorthand for the message range
\*(lqfirst\-last\*(rq.

The specification \*(lqname:n\*(rq designates up to `n' messages.
These messages start with `name' if `name' is a message number or one of
the reserved names \*(lqfirst\*(rq \*(lqcur\*(rq, or \*(lqnext\*(rq, The
messages end with `name' if `name' is \*(lqprev\*(rq or \*(lqlast\*(rq.
The interpretation of `n' may be overridden by preceding `n' with a
plus or minus sign; `+n' always means up to `n' messages starting with
`name', and `\-n' always means up to `n' messages ending with `name'.

In commands which accept a `msgs' argument, the default is either
\*(lqcur\*(rq or \*(lqall\*(rq, depending on which makes more sense
for each command (see the individual man pages for details).  Repeated
specifications of the same message have the same effect as a single
specification of the message.

There is also a special \*(lqreserved\*(rq message name \*(lqnew\*(rq
which is used by the \fImhpath\fR command.

.Uh "User\-Defined Message Sequences"
In addition to the \*(lqreserved\*(rq (pre-defined) message names given
above, \fInmh\fP supports user-defined sequence names.  User-defined
sequences allow the \fInmh\fR user a tremendous amount of power in dealing
with groups of messages in the same folder by allowing the user to bind
a group of messages to a meaningful symbolic name.

The name used to denote a message sequence must consist of an alphabetic
character followed by zero or more alphanumeric characters, and can not
be one of the \*(lqreserved\*(rq message names above.  After defining a
sequence, it can be used wherever an \fInmh\fR command expects a `msg' or
`msgs' argument.

Some forms of message ranges are allowed with user-defined sequences.
The specification \*(lqname:n\*(rq may be used, and it designates up
to the first `n' messages (or last `n' messages for `\-n') which are
elements of the user-defined sequence `name'.

The specifications \*(lqname:next\*(rq and \*(lqname:prev\*(rq may also
be used, and they designate the next or previous message (relative to the
current message) which is an element of the user-defined sequence `name'.
The specifications \*(lqname:first\*(rq and \*(lqname:last\*(rq are
equivalent to \*(lqname:1\*(rq and \*(lqname:\-1\*(rq, respectively.  The
specification \*(lqname:cur\*(rq is not allowed (use just \*(lqcur\*(rq
instead).  The syntax of these message range specifications is subject
to change in the future.

User-defined sequence names are specific to each folder.  They are
defined using the \fIpick\fP and \fImark\fP commands.

.Uh "Public and Private User-Defined Sequences"
There are two varieties of user-defined sequences: \fIpublic\fR and
\fIprivate\fR.  \fIPublic\fR sequences of a folder are accessible to any
\fInmh\fR user that can read that folder.  They are kept in each folder
in the file determined by the \*(lqmh\-sequences\*(rq profile entry
(default is \&.mh\(rusequences).  \fIPrivate\fR sequences are accessible
only to the \fInmh\fR user that defined those sequences and are kept in
the user's \fInmh\fR context file.

In general, the commands that create sequences (such as \fIpick\fR and
\fImark\fR) will create \fIpublic\fR sequences if the folder for which
the sequences are being defined is writable by the \fInmh\fR user.
For most commands, this can be overridden by using the switches
`\-public' and `\-private'.  But if the folder is read\-only, or if
the \*(lqmh\-sequences\*(rq profile entry is defined but empty, then
\fIprivate\fR sequences will be created instead.

.Uh "Sequence Negation"
\fInmh\fP provides the ability to select all messages not elements of a
user-defined sequence.  To do this, the user should define the entry
\*(lqSequence\-Negation\*(rq in the \fInmh\fR profile file; its value
may be any string.  This string is then used to preface an existing
user-defined sequence name.  This specification then refers to those
messages not elements of the specified sequence name.  For example, if
the profile entry is:

.ti +.5i
Sequence\-Negation:\^ not

then anytime an \fInmh\fR command is given \*(lqnotfoo\*(rq as a `msg' or
`msgs' argument, it would substitute all messages that are not elements
of the sequence \*(lqfoo\*(rq.

Obviously, the user should beware of defining sequences with names that
begin with the value of the \*(lqSequence\-Negation\*(rq profile entry.

.Uh "The Previous Sequence"
\fInmh\fR provides the ability to remember the `msgs' or `msg' argument
last given to an \fInmh\fR command.  The entry \*(lqPrevious\-Sequence\*(rq
should be defined in the \fInmh\fR profile; its value should be a sequence
name or multiple sequence names separated by spaces.  If this entry
is defined, when when an \fInmh\fP command finishes, it will define the
sequence(s) named in the value of this entry to be those messages that
were specified to the command.  Hence, a profile entry of

.ti +.5i
Previous\-Sequence:\^ pseq

directs any \fInmh\fR command that accepts a `msg' or `msgs' argument to
define the sequence \*(lqpseq\*(rq as those messages when it finishes.

\fBNote:\fP there can be a performance penalty in using the
\*(lqPrevious\-Sequence\*(rq facility.  If it is used, \fBall\fP
\fInmh\fR programs have to write the sequence information to the
\&.mh\(rusequences file for the folder each time they run.  If the
\*(lqPrevious\-Sequence\*(rq profile entry is not included, only
\fIpick\fR and \fImark\fR will write to the \&.mh\(rusequences file.

.Uh "The Unseen Sequence"
Finally, many users like to indicate which messages have not been
previously seen by them.  The commands \fIinc\fR, \fIrcvstore\fR,
\fIshow\fR, \fImhshow\fR, and \fIflist\fR honor the profile entry
\*(lqUnseen\-Sequence\*(rq to support this activity.  This entry
in the \&.mh\(ruprofile should be defined as one or more sequence
names separated by spaces.  If there is a value for
\*(lqUnseen\-Sequence\*(rq in the profile, then whenever new messages
are placed in a folder (using \fIinc\fR or \fIrcvstore\fR), the
new messages will also be added to all the sequences named in this
profile entry.  For example, a profile entry of

.ti +.5i
Unseen\-Sequence:\^ unseen

directs \fIinc\fR to add new messages to the sequence \*(lqunseen\*(rq.
Unlike the behavior of the \*(lqPrevious\-Sequence\*(rq entry in the
profile, however, the sequence(s) will \fBnot\fR be zeroed by \fIinc\fP.

Similarly, whenever \fIshow\fR, \fImhshow\fR, \fInext\fR, or
\fIprev\fR\^ displays a message, that message will be removed from
any sequences named by the \*(lqUnseen\-Sequence\*(rq entry in the
profile.

.Fi
^$HOME/\&.mh\(ruprofile~^The user profile
^<mh\-dir>/context~^The user context
^<folder>/\&.mh\(rusequences~^File for public sequences
.Pr
^mh-sequences:~^Name of file to store public sequences
.Ps
^Sequence\-Negation:~^To designate messages not in a sequence
.Ps
^Previous\-Sequence:~^The last message specification given
.Ps
^Unseen\-Sequence:~^Those messages not yet seen by the user
.Sa
flist(1), mark(1), pick(1), mh-profile(5)
.De
None
.Co
All
.En
