/*
 * cslota.c - A slot for holding one card.
 */

#include <stdlib.h>

#include "fc.h"
#include "area.h"
#include "err.h"

#include "card.h"
#include "cslot.h"
#include "cslota.h"

/* ---------- Method declarations ---------- */
void cslota_term(struct area *);
int cslota_mouse(struct area *, XButtonEvent *);
int cslota_draw(struct area *, Region);
int cslota_resize(struct area *, XConfigureEvent *);
int cslota_key(struct area *, XKeyEvent *);
int cslota_activate(struct area *, XMapEvent *);
int cslota_deactivate(struct area *, XUnmapEvent *);

/* ---------- Ops structure ---------- */
struct area_ops cslota_ops = {
     cslota_term,
     cslota_mouse,
     cslota_draw,
     cslota_resize,
     cslota_key,
     cslota_activate,
     cslota_deactivate
};

/* ---------------------------------------------------------------------- */
struct area *
cslota_create(struct cslot *ctp, struct aop *aop)
{
     struct area *ret;
     struct cslota_data *ctdp;
     
     aop->aops = &cslota_ops;
     
     ret = area_create(aop, sizeof(struct cslota_data));
     if (!ret) return ret;
     
     ctdp = ret->data;
     ctdp->ctp = ctp;
     
     cslot_setarea(ctp, ret);
     
     return ret;
}

/* ---------------------------------------------------------------------- */
void cslota_term(struct area *ap)
{
     struct cslota_data *ctdp = ap->data;

     if (ctdp->ctp) cslot_destroy(ctdp->ctp);
}

/* ---------------------------------------------------------------------- */
int cslota_mouse(struct area *ap, XButtonEvent *xevp)
{
     struct cslota_data *ctdp = ap->data;
     struct cslot *ctp = ctdp->ctp;
     
     /* Ignore button up events for now. */
     if (xevp->type == ButtonRelease) return(0);

     if (!cslot_isempty(ctp)) {
	  cslota_setinvert(ap, !cslot_getinvert(ctp));
     }

     return(0);
}

/* ---------------------------------------------------------------------- */
int
cslota_setinvert(struct area *ap, int invert)
{
     clear_rect(dpy, ap->owner, &ap->bounds, TRUE);
     return(0);
}

/* ---------------------------------------------------------------------- */
int cslota_draw(struct area *ap, Region rgn)
{
     struct cslota_data *ctdp = ap->data;
     struct cslot *ctp;

     if (!ctdp->ctp) return(0);

     ctp = ctdp->ctp;

     card_draw(cslot_getcard(ctp), ap->owner, ap->bounds.x, ap->bounds.y);

     return(0);
}

/* ---------------------------------------------------------------------- */
int cslota_resize(struct area *ap, XConfigureEvent *xevp)
{
     return(0);
}

/* ---------------------------------------------------------------------- */
int cslota_key(struct area *ap, XKeyEvent *xevp)
{
     return(0);
}

/* ---------------------------------------------------------------------- */
int cslota_activate(struct area *ap, XMapEvent *xevp)
{
     return(0);
}

/* ---------------------------------------------------------------------- */
int cslota_deactivate(struct area *ap, XUnmapEvent *xevp)
{
     return(0);
}

