/* xgrav
 * Gravity Wars game, for up to 5 players on an X network.
 *
 * Many thanks to Andy Plotkin for code and advice, and to
 * JT Traub for help and inspiration.  Also thanks to Eeyore
 * for bitmaps.  And, of course, Ed Bartz, who wrote the
 * Amiga version that this is based on.
 */

#include <stdio.h>
#include <ctype.h>
#include <unistd.h>
#include "xgrav.h"

planettype planet[ABSMAXPLANETS];
playertype player[MAXPLAYERS];
char *shipname[MAXPLAYERS];
int   numplayers, maxplanets, minplanets, numplanets;
int    scribble, planetsurf;
/* end of global stuff */




void bye(numplayers)
  int numplayers;
{
  int temp;
  
  for (temp=0;temp<numplayers;temp++)
    XCloseDisplay(player[temp].dpy);
}

void flushall(int numplayers)
{
  int temp;
  for (temp=0; temp<numplayers; temp++)
    XFlush(player[temp].dpy);
}

int main(int argc, char **argv)
{
  int temp, temp2, shipnum;
  char *dvname[MAXPLAYERS];
  static char defshipname[MAXPLAYERS][512];
  
  srandom(getpid() + current_usec()); 
  scribble = 0;
  planetsurf = 1;
  maxplanets = 15;   /* reasonable default values */
  minplanets = 5;    /* note: using 1 and ABSMAXPLANETS here would */
                     /*       not be good, since they're extreme.  */
  for (temp = 0; temp<MAXPLAYERS; temp++) {
    sprintf(defshipname[temp], "%sship%d.bm", BITMAPDIR, temp+1);
    shipname[temp] = defshipname[temp];
  }
  
  dvname[0]=NULL; /*open window for first player, on this machine*/
  temp2 = 0;
  shipnum = 0;
  for (temp=1;temp<argc;temp++)
    {
      if (argv[temp][0]=='-') {
	switch (argv[temp][1]) {
	case 'M': {
	  maxplanets = atoi(argv[temp]+2); /*hopefully, a pointer to the part after "-M" */
	  if (!isdigit(*(argv[temp]+2))) {
	    printf("xgrav: -M switch must be followed by a digit\n");
	    exit(-1);
	  };
	  if (maxplanets < 1 || maxplanets > ABSMAXPLANETS) {
	    printf("Maximum number of planets is limited to %d.\n", ABSMAXPLANETS);
	    exit(-1);
	  }
	  break;
	}
	case  'm': {
	  minplanets = atoi(argv[temp]+2);
	  if (!isdigit(*(argv[temp]+2))) {
	    printf("xgrav: -m switch must be followed by a digit\n");
	    exit(-1);
	  };
	  if (minplanets < 1 || minplanets > ABSMAXPLANETS) {
	    printf("Minimum number of planets is limited to a maximum of %d.\n", ABSMAXPLANETS);
	    exit(-1);
	  }
	  break;
	}
	case 's': {
	  shipname[shipnum] = argv[temp]+2; /*hopefully, the part after "-s"*/ 
	  shipnum++;
	  break;
	} 
	case 'S': {
	  shipnum++; /*give next player a default ship*/
	  break;
	}
	case 't': {
	  scribble = 1;
	  break;
	}
	case 'p': {
	  planetsurf = 0;
	  break;
	}
	default: {
	  printf("usage: xgrav [-t] [-p] [-M <maximum # of planets>] [-m <minimum # of planets>] [-s<filename for custom ship (one -s for each custom ship)>] <displays for players 2...n (max %d)>\n", MAXPLAYERS);
	  exit(-1);
	}
	}
      }
      else {
	temp2++;
	if (temp2<MAXPLAYERS) {
	  dvname[temp2]=argv[temp];
	}
	else {
	  printf("xgrav: too many players\n");
	  exit (-1);
	}
	
      }
    }
  if (minplanets > maxplanets) {
    printf("Minimum # of planets may not be greater than maximum.\n");
    exit (-1);
  }
  numplayers = temp2 + 1;
  for (temp2=0; temp2<numplayers; temp2++) {
    initwindow(temp2, dvname[temp2]);
    XFlush(player[temp2].dpy);
  }
  
  for (;;) {
    pregame();
    flushall(numplayers);
    for (temp = 0; temp < numplayers; temp++) {
      vector[temp].flag = 0;
      player[temp].alive = 1;
    }
    temp2 = 0;
    for (temp = 0; temp < numplayers; temp++) 
      if (player[temp].alive)
	temp2++;
    while (temp2 > 1 || (temp2 > 0 && numplayers == 1)) {
      game();
      missiles();
      temp2 = 0;
      for (temp = 0; temp < numplayers; temp++) 
	if (player[temp].alive)
	  temp2++;
    }
  }
  
  
  bye(numplayers);
  exit (1);
} /*main*/


/* notes
 * backburner: zoom in/out.  In = cluster plus border.  Out = limits. (galaxy/universe)
 * fire button
 * any player can quit (self-destruct?).  No option to add or remove players except on command line.
 * how set options? Command line! backburner: Vote?
 * keep score
 * game loop:
 * create a setup.
 * wait fr veto or ready from each player.
 * allow data entry.  Wait fr quit or fire from all players.
 * launch missiles, watching fr kills, crashes, departures, and quits.
 * calculate scores. (scoring system?  point fr kill? point fr survival? point fr kill before killed?)
 * use perror fr "xgrav:" error messages
 */
