#include "xgrav.h"

void drawplanet (playernum, planetnum)
int playernum, planetnum;

{
    int tempx, tempy, tempw, temph, temp;
    int surf;
    
    tempx = (int)((planet[planetnum].x)+(player[playernum].winw/2) - (planet[planetnum].diameter / 2));
    tempy = (int)((planet[planetnum].y)+(player[playernum].winh/2) - (planet[planetnum].diameter / 2));
    temph = (int)(planet[planetnum].diameter);
    tempw = (int)(planet[planetnum].diameter);
    surf = planet[planetnum].surface;
    XFillArc(player[playernum].dpy, player[playernum].win, player[playernum].planetpen[surf], tempx, tempy, tempw, temph, 0, (360*64));
}

void drawplanetz (playernum, planetnum)
int playernum, planetnum;

{
    int tempx, tempy, tempw, temph, temp;
    
    tempx = (int)((ZOOMFACTOR*(float)planet[planetnum].x)+(player[playernum].winw/2) - (ZOOMFACTOR*(float)planet[planetnum].diameter / 2.0));
    tempy = (int)((ZOOMFACTOR*(float)planet[planetnum].y)+(player[playernum].winh/2) - (ZOOMFACTOR*(float)planet[planetnum].diameter / 2.0));
    temph = (int)(ZOOMFACTOR*(float)planet[planetnum].diameter);
    tempw = (int)(ZOOMFACTOR*(float)planet[planetnum].diameter);
    XFillArc(player[playernum].dpy, player[playernum].win, player[playernum].whitepen, tempx, tempy, tempw, temph, 0, (360*64));
}

void drawship (playernum, shipnum)
int playernum, shipnum;

{
    int tempx, tempy, tempw, temph, temp;

    tempx = (int)((player[shipnum].shipx)+(player[playernum].winw/2));
    tempy = (int)((player[shipnum].shipy)+(player[playernum].winh/2));
    temph = (int)(player[shipnum].shipheight);
    tempw = (int)(player[shipnum].shipwidth);
    /* the ship is a one-plane bitmap read from a file. */
    XCopyPlane(player[playernum].dpy,
            player[playernum].shipbm[shipnum], player[playernum].win,
            player[playernum].copypen, 0, 0, tempw, temph, tempx, tempy, 0x1);
}

void drawshipz (playernum, shipnum)
int playernum, shipnum;

{
    int tempx, tempy, tempw, temph, temp;

    tempx = (int)((int)(ZOOMFACTOR*(float)player[shipnum].shipx)+(player[playernum].winw/2));
    tempy = (int)((int)(ZOOMFACTOR*(float)player[shipnum].shipy)+(player[playernum].winh/2));
    temph = (int)(ZOOMFACTOR*(float)player[shipnum].shipheight);
    tempw = (int)(ZOOMFACTOR*(float)player[shipnum].shipwidth);
    XDrawRectangle(player[playernum].dpy, player[playernum].win, player[playernum].whitepen, tempx, tempy, tempw, temph);

}

void drawhulk (playernum, shipnum)
int playernum, shipnum;

{
    int tempx, tempy, tempw, temph, temp;

    tempx = (int)((player[shipnum].shipx)+(player[playernum].winw/2));
    tempy = (int)((player[shipnum].shipy)+(player[playernum].winh/2));
    temph = (int)(player[shipnum].shipheight);
    tempw = (int)(player[shipnum].shipwidth);
    XCopyArea(player[playernum].dpy, player[playernum].hulkbm, player[playernum].win, player[playernum].whitepen, 0, 0, tempw, temph, tempx, tempy);

}

void redrawpg1(playernum)
int playernum;

{
    int temp;

    XClearWindow(player[playernum].dpy, player[playernum].win);
    for (temp=0; temp<numplanets; temp++)
	drawplanet(playernum, temp); /*draw all the planets*/
    XCopyArea(player[playernum].dpy, player[playernum].readybuttonbm, player[playernum].win, player[playernum].whitepen, 0, 0, BUTWIDTH, BUTHEIGHT, player[playernum].readybuttonminx, player[playernum].readybuttonminy);
    XCopyArea(player[playernum].dpy, player[playernum].vetobuttonbm, player[playernum].win, player[playernum].whitepen, 0, 0, BUTWIDTH, BUTHEIGHT, player[playernum].vetobuttonminx, player[playernum].vetobuttonminy);
    XCopyArea(player[playernum].dpy, player[playernum].blankbuttonbm, player[playernum].win, player[playernum].whitepen, 0, 0, BUTWIDTH, BUTHEIGHT, player[playernum].firebuttonminx, player[playernum].firebuttonminy);
    if (player[playernum].ready) {
	XCopyArea(player[playernum].dpy, player[playernum].readybutton2bm, player[playernum].win, player[playernum].whitepen, 0, 0, BUTWIDTH, BUTHEIGHT, player[playernum].readybuttonminx, player[playernum].readybuttonminy);
    }
    for (temp = 0; temp < numplayers; temp++)
	drawship(playernum, temp);
}



void redrawpg()

{
    int temp;

    for (temp=0; temp<numplayers; temp++) {
	redrawpg1(temp);
    }
}

void redrawg1(playernum)
int playernum;

{
    int temp;

    XClearWindow(player[playernum].dpy, player[playernum].win);
    for (temp=0; temp<numplanets; temp++)
	drawplanet(playernum, temp); /*draw all the planets*/
    XCopyArea(player[playernum].dpy, player[playernum].trails, player[playernum].win, player[playernum].andpen, 0, 0, HIGH, WIDE, 0, 0);
    for (temp = 0; temp < numplayers; temp++) {
	if (player[temp].alive)
	    drawship(playernum, temp);
	else
	    drawhulk(playernum, temp);
    }
    XCopyArea(player[playernum].dpy, player[playernum].blankbuttonbm, player[playernum].win, player[playernum].whitepen, 0, 0, BUTWIDTH, BUTHEIGHT, player[playernum].readybuttonminx, player[playernum].readybuttonminy);
    XCopyArea(player[playernum].dpy, player[playernum].blankbuttonbm, player[playernum].win, player[playernum].whitepen, 0, 0, BUTWIDTH, BUTHEIGHT, player[playernum].vetobuttonminx, player[playernum].vetobuttonminy);
    XCopyArea(player[playernum].dpy, player[playernum].velocitybuttonbm, player[playernum].win, player[playernum].whitepen, 0, 0, BUTWIDEWIDTH, BUTHEIGHT, player[playernum].velocitybuttonminx, player[playernum].velocitybuttonminy);
    XCopyArea(player[playernum].dpy, player[playernum].anglebuttonbm, player[playernum].win, player[playernum].whitepen, 0, 0, BUTWIDEWIDTH, BUTHEIGHT, player[playernum].anglebuttonminx, player[playernum].anglebuttonminy);
    if (player[playernum].ready) {
	XCopyArea(player[playernum].dpy, player[playernum].firebutton2bm, player[playernum].win, player[playernum].whitepen, 0, 0, BUTWIDTH, BUTHEIGHT, player[playernum].firebuttonminx, player[playernum].firebuttonminy);
    }
    else {
	XCopyArea(player[playernum].dpy, player[playernum].firebuttonbm, player[playernum].win, player[playernum].whitepen, 0, 0, BUTWIDTH, BUTHEIGHT, player[playernum].firebuttonminx, player[playernum].firebuttonminy);
    }	
    if (vector[playernum].flag)
	vectordraw(playernum);



}

void redrawg()

{
    int temp;

    for (temp=0; temp<numplayers; temp++) {
	redrawg1(temp);
    }
}

void redrawm1(playernum)
int playernum;

{
    int temp;

    XClearWindow(player[playernum].dpy, player[playernum].win);
    XCopyArea(player[playernum].dpy, player[playernum].trails, player[playernum].win, player[playernum].andpen, 0, 0, HIGH, WIDE, 0, 0);
    for (temp=0; temp<numplanets; temp++)
	drawplanet(playernum, temp); /*draw all the planets*/
    for (temp = 0; temp < numplayers; temp++) {
	if (player[temp].alive)
	    drawship(playernum, temp);
	else
	    drawhulk(playernum, temp);
    }
/* 
    XCopyArea(player[playernum].dpy, player[playernum].blankbuttonbm, player[playernum].win, player[playernum].whitepen, 0, 0, BUTWIDTH, BUTHEIGHT, player[playernum].readybuttonminx, player[playernum].readybuttonminy);
    XCopyArea(player[playernum].dpy, player[playernum].blankbuttonbm, player[playernum].win, player[playernum].whitepen, 0, 0, BUTWIDTH, BUTHEIGHT, player[playernum].vetobuttonminx, player[playernum].vetobuttonminy);
*/
    XCopyArea(player[playernum].dpy, player[playernum].velocitybuttonbm, player[playernum].win, player[playernum].whitepen, 0, 0, BUTWIDEWIDTH, BUTHEIGHT, player[playernum].velocitybuttonminx, player[playernum].velocitybuttonminy);
    XCopyArea(player[playernum].dpy, player[playernum].anglebuttonbm, player[playernum].win, player[playernum].whitepen, 0, 0, BUTWIDEWIDTH, BUTHEIGHT, player[playernum].anglebuttonminx, player[playernum].anglebuttonminy);
    XCopyArea(player[playernum].dpy, player[playernum].firebutton2bm, player[playernum].win, player[playernum].whitepen, 0, 0, BUTWIDTH, BUTHEIGHT, player[playernum].firebuttonminx, player[playernum].firebuttonminy);
    XCopyArea(player[playernum].dpy, player[playernum].zoombuttonbm, player[playernum].win, player[playernum].whitepen, 0, 0, BUTWIDTH, BUTHEIGHT, player[playernum].zoombuttonminx, player[playernum].zoombuttonminy);
}

void redrawm1z(playernum)
int playernum;

{
    int temp, temp2;
    int offsetx, offsety;

    /* XClearWindow(player[playernum].dpy, player[playernum].win); */
    XFillRectangle(player[playernum].dpy, player[playernum].win, player[playernum].blackpen, 0, 0, HIGH, WIDE);
    for (temp = 0; temp < numplayers; temp++) 
	drawshipz(playernum, temp);
    for (temp=0; temp<numplanets; temp++)
	drawplanetz(playernum, temp); 
    XCopyArea(player[playernum].dpy, player[playernum].zoombutton2bm, player[playernum].win, player[playernum].whitepen, 0, 0, BUTWIDTH, BUTHEIGHT, player[playernum].zoombuttonminx, player[playernum].zoombuttonminy);
    XDrawArc(player[playernum].dpy, player[playernum].win, player[playernum].whitepen, player[playernum].winw/2-(int)(ZOOMFACTOR*ESCAPERADIUS), player[playernum].winh/2-(int)(ZOOMFACTOR*ESCAPERADIUS), 2*(int)(ZOOMFACTOR*ESCAPERADIUS), 2*(int)(ZOOMFACTOR*ESCAPERADIUS), 0, 360*64);
    offsetx = player[playernum].winw/2;
    offsety = player[playernum].winh/2;
    for (temp = 0; temp < numplayers; temp++) {
	XDrawPoint(player[playernum].dpy, player[playernum].win, player[playernum].invertpen, (int) (ZOOMFACTOR*missile[temp].x) + offsetx, (int) (ZOOMFACTOR*missile[temp].y) + offsety);
    } 
}


void redrawm()

{
    int temp;
    
    for (temp=0; temp<numplayers; temp++) {
	if (!player[temp].zoomed)
	    redrawm1(temp);
	else
	    redrawm1z(temp);
    }
}

int distance (x1,y1,x2,y2)
int x1,y1,x2,y2;

{
    return (int)sqrt((double)(x1-x2)*(double)(x1-x2) + (double)(y1-y2)*(double)(y1-y2));
}

int sqrdistance (x1, y1, x2, y2) /*returns square of distance*/
int x1,y1,x2,y2;
{
    return (int)((double)(x1-x2)*(double)(x1-x2) + (double)(y1-y2)*(double)(y1-y2));
}

float floatdistance (x1,y1,x2,y2)
float x1,y1,x2,y2;

{
    return (float)sqrt((double)(x1-x2)*(double)(x1-x2) + (double)(y1-y2)*(double)(y1-y2));
}

float floatsqrdistance (x1, y1, x2, y2) /*returns square of distance*/
float x1,y1,x2,y2;
{
    return (float)((double)(x1-x2)*(double)(x1-x2) + (double)(y1-y2)*(double)(y1-y2));
}
