#include "xgrav.h"

#define MISSILEPAUSE 7000
#define GRAVCONST 0.5 /* this is about right */


missiletype missile[MAXPLAYERS]; 
long lastmissiletime;

void drawmissiles()

{
    int temp, temp2, offsetx, offsety;

    for (temp = 0; temp < numplayers; temp++) {
	offsetx = player[temp].winw/2;
	offsety = player[temp].winh/2;
	for (temp2 = 0; temp2 < numplayers; temp2++) {
	    if (player[temp].zoomed) {
		XDrawPoint(player[temp].dpy, player[temp].win, player[temp].invertpen, (int) (ZOOMFACTOR*missile[temp2].oldx) + offsetx, (int) (ZOOMFACTOR*missile[temp2].oldy) + offsety);
		XDrawPoint(player[temp].dpy, player[temp].win, player[temp].invertpen, (int) (ZOOMFACTOR*missile[temp2].x) + offsetx, (int) (ZOOMFACTOR*missile[temp2].y) + offsety);
	    }
	    if ((fabs(missile[temp2].x) < 400 && fabs(missile[temp2].oldx) < 400) || (fabs(missile[temp2].y) < 400 && fabs(missile[temp2].oldy) < 400)) {
		if (!player[temp].zoomed) {
		    XDrawLine(player[temp].dpy, player[temp].win, player[temp].andpen, (int) missile[temp2].oldx + offsetx, (int) missile[temp2].oldy + offsety, (int) missile[temp2].x + offsetx, (int) missile[temp2].y + offsety);
		}
		XDrawLine(player[temp].dpy, player[temp].trails, player[temp].andpen, (int) missile[temp2].oldx + offsetx, (int) missile[temp2].oldy +offsety, (int) missile[temp2].x + offsetx, (int) missile[temp2].y + offsety);
	    }
	}
    }
}

void startmissiles()

{
    int temp;
    float d;
    float vectx, vecty;

    for (temp = 0; temp < numplayers; temp++) {
	missile[temp].flag = 0;
	if (player[temp].alive) {
	    vectx = (float)cos(vector[temp].theta) * vector[temp].r;
	    vecty = (float)sin(vector[temp].theta) * vector[temp].r;
	    missile[temp].vx = (vectx / 40.0);
	    missile[temp].vy = (vecty / 40.0);
	    d = floatdistance(missile[temp].vx, missile[temp].vy, 0.0, 0.0);
	    missile[temp].x = (missile[temp].vx/d) *((float)player[temp].shipheight/1.7) + (float) ( player[temp].shipx + (player[temp].shipheight/2));
	    missile[temp].y = (missile[temp].vy/d) *((float)player[temp].shipheight/1.7) + (float) ( player[temp].shipy + (player[temp].shipheight/2));
	    missile[temp].oldx = missile[temp].x;
	    missile[temp].oldy = missile[temp].y;
	    missile[temp].flag = 1;
	}
    }
    lastmissiletime = current_usec();
}

void calcgrav(playernum)
int playernum;

{
    register int temp;
    float sqd, sqdcube;
    float acx, acy;

    acx = 0.0;
    acy = 0.0;

    for (temp = 0; temp < numplanets; temp++) {
	sqd = floatdistance (missile[playernum].x, missile[playernum].y, (float)planet[temp].x, (float)planet[temp].y);
	sqdcube = sqd * sqd * sqd;
	acx += (((float)planet[temp].x - missile[playernum].x) * GRAVCONST * (float)planet[temp].mass)/(sqdcube);
	acy += (((float)planet[temp].y - missile[playernum].y) * GRAVCONST * (float)planet[temp].mass)/(sqdcube);

    };
    if (floatsqrdistance(missile[playernum].x, missile[playernum].y, 0.0, 0.0) < SQUARECOARSELIMIT) {
	missile[playernum].vx += acx;
	missile[playernum].vy += acy;
	missile[playernum].oldx = missile[playernum].x;
	missile[playernum].x += missile[playernum].vx;
	missile[playernum].oldy = missile[playernum].y;
	missile[playernum].y += missile[playernum].vy;
    }
    else {
	missile[playernum].vx += acx*2;
	missile[playernum].vy += acy*2;
	missile[playernum].oldx = missile[playernum].x;
	missile[playernum].x += missile[playernum].vx*2;
	missile[playernum].oldy = missile[playernum].y;
	missile[playernum].y += missile[playernum].vy*2;
    }
    lastmissiletime = current_usec();
}

void collide(playernum) 
int playernum;

{
    int temp, temp2;

    if (floatsqrdistance(missile[playernum].x, missile[playernum].y, 0.0, 0.0) > ESCAPERADIUSSQUARED)
	missile[playernum].flag =0;

    for (temp = 0; temp < numplanets; temp++)
	if (floatsqrdistance((float)planet[temp].x, (float)planet[temp].y, missile[playernum].x, missile[playernum].y) < ((float)(planet[temp].diameter/2) * (float)(planet[temp].diameter / 2))) {
	    missile[playernum].flag = 0;
	}
    for (temp = 0; temp < numplayers; temp++)
	if (floatsqrdistance((float)(player[temp].shipx + (player[temp].shipheight / 2)), (float)(player[temp].shipy + (player[temp].shipheight / 2)), missile[playernum].x, missile[playernum].y) < ((float)(player[temp].shipheight / 2) * (float)(player[temp].shipheight / 2))) {
	    missile[playernum].flag = 0;
	    player[temp].alive = 0;
	    for (temp2 = 0; temp2 < numplayers; temp2++) {
		if (!player[temp2].zoomed)
		    drawhulk(temp2, temp);
	    }
	    /*player[playernum].score += 10; or something like that*/
	}
}

void missiles()
{
    int temp, temp2;
    Bool eventp;
    XEvent event, nextevent;

    if (!scribble)
	for (temp = 0; temp < numplayers; temp++)
	    XFillRectangle(player[temp].dpy, player[temp].trails, player[temp].blackpen, 0,0,WIDE,HIGH);
    for (temp = 0; temp < numplayers; temp++) {
	player[temp].zoomed = 0;
    };
    redrawm();
    startmissiles();
    temp2 = 0;
    for (temp = 0; temp < numplayers; temp++) 
	if (missile[temp].flag)
	    temp2++;
    while (temp2) {
	for (temp = 0; temp < numplayers; temp++) {
	    eventp = XCheckWindowEvent(player[temp].dpy, player[ temp].win, GAME_EVENT_MASKS, &event);
	    if (eventp) switch (event.type) {
		case Expose:
		    eventp = XCheckWindowEvent(player[temp].dpy, player[temp].win, GAME_EVENT_MASKS, &nextevent);
		    while (eventp && nextevent.type == Expose) {
			eventp = XCheckWindowEvent(player[temp].dpy, player[temp].win, GAME_EVENT_MASKS, &nextevent);
		    };
		    if (eventp) {
			XPutBackEvent(player[temp].dpy, &nextevent);
		    };
		    if (!player[temp].zoomed) 
			redrawm1(temp);
		    else 
			redrawm1z(temp);
		    break;
		case ButtonPress:
		    if (event.xbutton.button == 1) {
			if (event.xbutton.x > player[temp].zoombuttonminx && event.xbutton.x < player[temp].zoombuttonmaxx && event.xbutton.y > player[temp].zoombuttonminy && event.xbutton.y < player[temp].zoombuttonmaxy) {
			    /*zoom*/
			    if (!player[temp].zoomed) {
				player[temp].zoomed = 1;
				/* XCopyArea(player[temp].dpy, player[temp].zoombutton2bm, player[temp].win, player[temp].whitepen, 0, 0, BUTWIDTH, BUTHEIGHT, player[temp].zoombuttonminx, player[temp].zoombuttonminy); */
				redrawm1z(temp);
			    }
			    else {
				player[temp].zoomed = 0;
				redrawm1(temp);
			    }
			}  /* else click was not in zoom */
		    }
		    break;
		default:
		    break;
	    }
	}
	if (elapsed(lastmissiletime, MISSILEPAUSE)) {
	    for (temp = 0; temp < numplayers; temp++) {
		if (missile[temp].flag)
		    calcgrav(temp);
	    }
	    drawmissiles();
	    for (temp = 0; temp < numplayers; temp++) {
		if (missile[temp].flag)
		    collide(temp);
	    }
	    temp2 = 0;
	    for (temp = 0; temp < numplayers; temp++) 
		if (missile[temp].flag)
		    temp2++;
	}

    }
}
