/*
 * Copyright (c) 2007 SDG Systems
 *
 * Use consistent with the GNU GPL is permitted,
 * provided that this copyright notice is
 * preserved in its entirety in all copies and derived works.
 *
 */

#include <linux/init.h>
#include <linux/kernel.h>
#include <linux/ioport.h>
#include <linux/platform_device.h>
#include <linux/input.h>
#include <linux/input_pda.h>
#include <linux/interrupt.h>
#include <linux/gpio_keys.h>

#include <asm/mach-types.h>
#include <asm/io.h>
#include <asm/hardware.h>
#include <asm/mach/arch.h>
#include <asm/mach/map.h>

#include <asm/arch/ghi270.h>
#include <asm/arch/pxa-regs.h>
#include <asm/arch/serial.h>

#include "generic.h"


static void __init ghi270_map_io(void)
{
	pxa_map_io();
#if 0
	iotable_init( ghi270_io_desc, ARRAY_SIZE(ghi270_io_desc) );
#endif
	// pxa_set_stuart_info(&ghi270_pxa_irda_funcs);
	// pxa_set_btuart_info(&ghi270_pxa_bt_funcs);
}

static void __init ghi270_init_irq(void)
{
	pxa_init_irq();
}

static struct gpio_keys_button ghi270_pxa_buttons[] = {
	{ _KEY_POWER,	 GPIO_GHI270_KEY_nON, 1, "Power button" },
};

static struct gpio_keys_platform_data ghi270_pxa_keys_data = {
	.buttons = ghi270_pxa_buttons,
	.nbuttons = ARRAY_SIZE(ghi270_pxa_buttons),
};

static struct platform_device ghi270_pxa_keys = {
	.name = "gpio-keys",
	.dev = {
		.platform_data = &ghi270_pxa_keys_data,
	},
};

static struct platform_device ghi270_flash = {
	.name = "ghi270-flash",
	.id = -1,
};

static struct platform_device *devices[] __initdata = {
	&ghi270_pxa_keys,
	&ghi270_flash,
};

static void __init ghi270_init( void )
{
	platform_add_devices( devices, ARRAY_SIZE(devices) );
}

MACHINE_START(GHI270, "Grayhill 270 (H/HG)")
        /* Maintainer SDG Systems */
	.phys_io	= 0x40000000,
	.io_pg_offst	= (io_p2v(0x40000000) >> 18) & 0xfffc,
        .boot_params	= 0xa0000100,
        .map_io		= ghi270_map_io,
        .init_irq	= ghi270_init_irq,
        .timer		= &pxa_timer,
        .init_machine	= ghi270_init,
MACHINE_END

