

/*  Copyright (c) 1993 by Kenneth Duda <kkkken@athena.mit.edu>.  
 *  All rights reserved.
 *
 *  This program is distributed in the hope that it will be useful.
 *  Use and copying of this software and preparation of derivative works
 *  based upon this software are permitted, so long as the following
 *  conditions are met:
 *       o credit to the author is acknowledged 
 *       o no fees or compensation are charged for use, copies, or
 *         access to this software
 *       o this copyright notice is included intact.
 *  This software is made available AS IS, and no warranty is made about 
 *  the software or its performance. 
 * 
 *  Bug descriptions, use reports, comments or suggestions are welcome.
 *  Send them to <kkkken@athena.mit.edu>.
 */

#include <X11/Intrinsic.h>

#include "AsciiTty.h"

#include "output.h"
#include "kgo.h"
#include "games.h"

static Widget outputSink = NULL;

void SetOutputSink (w)
     Widget w;
{
    outputSink = w;
}

Widget FindOutputSink ()
{
    return FindGameKibitz();
}
	

void CancelOutputSink (w)
     Widget w;
{
    if (w == outputSink) {
	outputSink = FindOutputSink();
    }
}

void OutputToSink (sink, text)
     Widget sink;
     char *text;
{
    XawAsciiTtyOutput (sink, text, strlen(text));
}


void ServerOutput (text)
     char *text;
{
    OutputToSink (outputSink, text);
    if (debug) {
	printf ("==> %s", text);
    }
}
