#ifndef __MACROS_H__
#define __MACROS_H__

#include <iostream>

#include <stdlib.h>					//for rand()

#define ABS(x) ((x)<0 ? (-(x)) : (x))
//returns a random integer r such that low <= r <= hi
#define RANDINT(low,hi) ((rand() % ABS(((int)((hi)-(low)+1)))) + (low))

//returns a random float 0 <= RAND <= 1
#define RAND (((float)rand())/RAND_MAX)
//returns a random float x <= f <= y
#define RANDFLOAT(x,y) (RAND * ABS((y)-(x)) + x)

#define CASE(c,a) case c: a; break;

#ifdef DEBUG_ON
#define PRINT(x) std::cout << #x << ":\t" << x << std::endl;
#define DEBUG(x) std::cout << x << std::endl;
#else
#define PRINT(x)
#define DEBUG(x)
#endif
			
typedef unsigned char byte;
typedef unsigned short word;
#endif
