// -*- mode: java; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*-

package antichess;

import java.util.List;

/**
 * A MoveGenerator is an abstract representation of the types of moves
 * allowed by a piece. A MoveGenerator encapsulates local knowledge
 * about the patterns of movement allowed by a piece (straight-line,
 * finite distance or unlimited, whether the piece can move through
 * other pieces, and so on), but not higher-order knowledge such as
 * ``Would this move cause the player to be in check?'' The Board
 * class is responsible for maintaining that information.
 **/
public interface MoveGenerator<M extends Move>
{
    /**
     * @requires p.type == this
     * @return an interator of moves the given piece can perform on
     * the board
     **/
    public List<M> getMoves(Piece p, Board b);

    /**
     * @requires m.piece.type == this
     * @return true iff the given move is allowed by its piece's
     * movement types
     **/
    public boolean isMoveLegal(M m, Board b);
}
