// -*- mode: java; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*-

package antichess.movegen;

import antichess.*;
import java.util.*;

/**
 * A PawnMoveGenerator represents the movement of a chess pawn
 **/
public class PawnMoveGenerator extends ChessMoveGenerator
{

	public List<ChessMove> getMoves(Piece piece, Board board) {
		List<ChessMove> moves = new ArrayList<ChessMove>();
		int dr = 1;
		if(piece.getPlayer() == Player.BLACK)
			dr = -1;
		if(piece.getRow() <= 0 || piece.getRow() >= board.getRows() + 1)
			throw new RuntimeException("Invalid pawn position: " + piece);
		if(board.getPieceAt(piece.getRow()+dr, piece.getColumn()) == null) {
			moves.add(new ChessMove(piece,
									piece.getRow()+dr,
									piece.getColumn(),
									null));
			if((piece.getPlayer() == Player.WHITE && piece.getRow() == 1)
			   || (piece.getPlayer() == Player.BLACK
				   && piece.getRow() == board.getRows()-2)) {
				if(board.getPieceAt(piece.getRow()+2*dr,
									piece.getColumn()) == null)
					moves.add(new ChessMove(piece,
									piece.getRow()+2*dr,
									piece.getColumn(),
									null));
			}
		}
		for(int dc=-1;dc<=1;dc++) {
			if(dc == 0) continue;
			int column = piece.getColumn() + dc;
			if(column < 0 || column >= board.getColumns())
				continue;
			Piece otherPiece = board.getPieceAt(piece.getRow()+dr,
												piece.getColumn()+dc);
			if(otherPiece != null && otherPiece.getPlayer() != piece.getPlayer())
				moves.add(new ChessMove(piece,
										piece.getRow()+dr,
										piece.getColumn()+dc,
										otherPiece));
		}
		return moves;
	}

	public boolean isChessMoveLegal(ChessMove cm, Board board) {
		Piece piece = cm.getPiece();

		int dr = cm.getRow() - piece.getRow();
		int dc = cm.getColumn() - piece.getColumn();
		if(dc == 0) {
			if(board.getPieceAt(cm.getRow(),
								cm.getColumn()) != null)
				return false;
			if(dr == 1 && cm.getPlayer() == Player.WHITE
			   || dr == -1 && cm.getPlayer() == Player.BLACK)
				return true;
			if((dr == 2 && cm.getPlayer() == Player.WHITE && piece.getRow() == 1)
			   || (dr == -2 && cm.getPlayer() == Player.BLACK && piece.getRow() == 6)) {
				return board.getPieceAt(piece.getRow() + dr/2, piece.getColumn()) == null;
			}
			return false;
		} else if(dc == -1 || dc == 1){
			if((cm.getPlayer() == Player.WHITE && dr == 1)
			   || (cm.getPlayer() == Player.BLACK && dr == -1)) {
				return board.getPieceAt(cm.getRow(), cm.getColumn()) != null;
			}
		}
		return false;
	}
}
