;******************************************************************************
;* This file contains  the functions of 10  bit ADC library module for 
;* polled option
;******************************************************************************
;*File name:    ADCPol.asm
;*Dependencies: ADCPol.inc
;*Processors:   PIC18
;*Assembler:    MPASMWIN 02.70.02 or higher
;*Linker:       MPLINK 2.33.00 or Higher
;*Company:      Microchip Technology, Inc.
;*
;* Software License Agreement
;*
;* The software supplied herewith by Microchip Technology Incorporated
;* (the "Company") for its PICmicro Microcontroller is intended and
;* supplied to you, the Company's customer, for use solely and
;* exclusively on Microchip PICmicro Microcontroller products. The
;* software is owned by the Company and/or its supplier, and is
;* protected under applicable copyright laws. All rights are reserved.
;* Any use in violation of the foregoing restrictions may subject the
;* user to criminal sanctions under applicable laws, as well as to
;* civil liability for the breach of the terms and conditions of this
;* license.
;*
;* THIS SOFTWARE IS PROVIDED IN AN "AS IS" CONDITION. NO WARRANTIES,
;* WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT NOT LIMITED
;* TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
;* PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. THE COMPANY SHALL NOT,
;* IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL OR
;* CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.
;*
;*
;*
;* Author               Date            Comment
;*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
;* B.K. Anantha Ramu    Mar 12, 2003    Initial Release 
;* B.K. Anantha Ramu    Mar 26, 2003    (V1.0)
;                                       Scaling factor D'1000000' removed in the formula
;                                       to calculate _N2 in the function ADCPolAcquisitionTime
;********************************************************************/
    #define A2D_10BIT_MODULE            ;With this definition, availability of
                                        ;module features will be known.
    #define _GEN_MODULE_ERROR           ;If ADC module is not available this 
                                        ;enables to generate error.
    #define _ADD_PROC_INC_FILE          ;This enables to include processor.inc file.
    #include    <P18xxx.INC>            ;This defines module features for different
                                        ;processors.
    #define ADCPol_Source               ;This definition is required where the variables
                                        ;are defined.

    #include <ADCPol.inc>               ;ADCPol.inc mainly contains macros of ADCPol
                                        ;library module


 
_ADCPOLDATA    UDATA_ACS

                       
vADCPolChannelNumber_A      RES     1   ;This location stores ADC channel number                              

                              
_vADCPolAcquisitionCount_A    RES     1   ;This location is used in delay routine used to
                                        ;provide acquisition time
;-------------------------------------------------------------------------------

_ADCPOLCODE    CODE


;******************************************************************************
; Function:     _ADCPolChannelSelect
;
; PreCondition: None
;
; Overview:     This function sets the bits of ADCON0 according to the channel  
;               number supplied through WREG.
; Input:        WREG contains the channel number.

; Output:       ADCON0

; Side Effects: WREG changes
;
; Stack requirement: 1 level deep
;
;****************************************************************************
_ADCPolChannelSelect:
        movwf   vADCPolChannelNumber_A

    IFDEF _ADCPOL_PIC181                ;10 bit ADC with ADCON0 & ADCON1
                                        ;registers. No ADCON2 register
        movlw   0xC7
        andwf   ADCON0,F                ;Channel bits in ADCON0 occupy bit
        rlncf   vADCPolChannelNumber_A,W  ;positions 3,4 & 5. Hence  value in  
        rlncf   WREG                    ;vADCPolChannelNumber_A is shifted left by 8.
        rlncf   WREG
        iorwf   ADCON0,F

    ENDIF

    IFDEF _ADCPOL_PIC182                ;10 bit ADC with ADCON0, ADCON1 & ADCON2
                                        ;register.
        movlw   0xC3                    ;Channel bits in ADCON0 occupy bit
        andwf   ADCON0,F                ;positions 2,3,4 & 5. Hence value                             
        rlncf   vADCPolChannelNumber_A,W  ;in vADCPolChannelNumber_A  is multiplied by 4.
        rlncf   WREG
        iorwf   ADCON0,F
    ENDIF

        return

;******************************************************************************
; Function:     ADCPolAcquisitionTime
;
; PreCondition: None
;
; Overview:     This function gives a delay of 
;               3*(_vADCPolAcquisitionCount_A-1)+2+4 instructions and  
;               it is  used to give acquisition delay time. 
;
; Input:        _vADCPolAcquisitionCount_A       
;
; Output:       None
;
; Side Effects: WREG
;
; Stack requirement: 1 level deep
;
;****************************************************************************

ADCPolAcquisitionTime:

_N2=(CLOCK_FREQ/D'4000000')*_ACQTIME                ;Number of instructions for
                                                    ;_ACQTIME.
_N1=(_N2-8)/D'3'+1                                  ;Count required for the routine
                                                    ;ADCPolAcquisitionTime to give 
        movlw   _N1                                 ;a delay of _ACQTIME.
        movwf   _vADCPolAcquisitionCount_A
Loop1         
        decfsz  _vADCPolAcquisitionCount_A,F
        bra     Loop1
        return


;******************************************************************************

    END
