/*****************************************************************************
 *
 * Microchip DeviceNet Stack (User level connection events)
 *
 *****************************************************************************
 * FileName:        UsrConn.h
 * Dependencies:    
 * Processor:       PIC18F with CAN
 * Compiler:       	C18 02.10.02 or higher
 * Linker:          MPLINK 03.20.01 or higher
 * Company:         Microchip Technology Incorporated
 *
 * Software License Agreement
 *
 * The software supplied herewith by Microchip Technology Incorporated
 * (the "Company") is intended and supplied to you, the Company's
 * customer, for use solely and exclusively with products manufactured
 * by the Company. 
 *
 * The software is owned by the Company and/or its supplier, and is 
 * protected under applicable copyright laws. All rights are reserved. 
 * Any use in violation of the foregoing restrictions may subject the 
 * user to criminal sanctions under applicable laws, as well as to 
 * civil liability for the breach of the terms and conditions of this 
 * license.
 *
 * THIS SOFTWARE IS PROVIDED IN AN "AS IS" CONDITION. NO WARRANTIES, 
 * WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT NOT LIMITED 
 * TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A 
 * PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. THE COMPANY SHALL NOT, 
 * IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL OR 
 * CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.
 *
 *
 * This file contains the Connection object described in section 5-4 of 
 * volume 1 of the DeviceNet specification.
 * 
 *
 *
 * Author               Date        Comment
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * Ross Fosler			06/17/03	...	
 * 
 *****************************************************************************/







// A connection creation event has occured, the application
// must handle creation events to handle application
// setup. Valid instances are 2, 3, 4, and 5.
unsigned char UsrConnCreateEvent(unsigned char hInstance);



// A close event has occured.
void UsrConnCloseEvent(unsigned char hInstance);




// Notify the user that data has been received
void UsrConnRxDataEvent(unsigned char hInstance);



// Notify the user that data has been sent
void UsrConnTxDataEvent(unsigned char hInstance);



// Notify the user that a set attribute has been requested that 
// cannot be handled internally
void UsrConnSetAttribEvent(unsigned char hInstance);
						










