
/*****************************************************************************
 *
 * Microchip DeviceNet Stack (Connection Object Header)
 *
 *****************************************************************************
 * FileName:        conn.h
 * Dependencies:    
 * Processor:       PIC18F with CAN
 * Compiler:       	C18 02.20.00 or higher
 * Linker:          MPLINK 03.40.00 or higher
 * Company:         Microchip Technology Incorporated
 *
 * Software License Agreement
 *
 * The software supplied herewith by Microchip Technology Incorporated
 * (the "Company") is intended and supplied to you, the Company's
 * customer, for use solely and exclusively with products manufactured
 * by the Company. 
 *
 * The software is owned by the Company and/or its supplier, and is 
 * protected under applicable copyright laws. All rights are reserved. 
 * Any use in violation of the foregoing restrictions may subject the 
 * user to criminal sanctions under applicable laws, as well as to 
 * civil liability for the breach of the terms and conditions of this 
 * license.
 *
 * THIS SOFTWARE IS PROVIDED IN AN "AS IS" CONDITION. NO WARRANTIES, 
 * WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT NOT LIMITED 
 * TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A 
 * PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. THE COMPANY SHALL NOT, 
 * IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL OR 
 * CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.
 *
 *
 * This file contains the Connection object described in section 5-4 of 
 * volume 1 of the DeviceNet specification.
 * 
 *
 *
 * Author               Date        Comment
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * Ross Fosler			04/28/03	...	
 * 
 *****************************************************************************/

#ifndef	__CONN_H__
#define	__CONN_H__


#define		INST_EXPL					1
#define		INST_POLL					2
#define		INST_STROBE					3
#define		INST_CYC_COS				4
#define		INST_MULTICAST				5



#define		CONN_ATTRIB_STATE					1
#define		CONN_ATTRIB_INSTANCE_TYPE			2
#define		CONN_ATTRIB_CLASS_TRIGGER			3
#define		CONN_ATTRIB_PRODUCED_CID			4
#define		CONN_ATTRIB_CONSUMED_CID			5
#define		CONN_ATTRIB_INITIAL_COMM_CHAR		6
#define		CONN_ATTRIB_PRODUCED_CONN_SIZE		7
#define		CONN_ATTRIB_CONSUMED_CONN_SIZE		8
#define 	CONN_ATTRIB_EXPECTED_RATE			9
#define		CONN_ATTRIB_WDT_ACTION				12
#define		CONN_ATTRIB_PRODUCED_CONN_PATH_LEN	13
#define		CONN_ATTRIB_PRODUCED_CONN_PATH		14
#define		CONN_ATTRIB_CONSUMED_CONN_PATH_LEN	15
#define		CONN_ATTRIB_CONSUMED_CONN_PATH		16
#define		CONN_ATTRIB_PRODUCTION_INHIBIT		17



#define		_ATTRIB_STATE					1
#define		_ATTRIB_INSTANCE_TYPE			2
#define		_ATTRIB_CLASS_TRIGGER			3
#define		_ATTRIB_PRODUCED_CID			4
#define		_ATTRIB_CONSUMED_CID			5
#define		_ATTRIB_INITIAL_COMM_CHAR		6
#define		_ATTRIB_PRODUCED_CONN_SIZE		7
#define		_ATTRIB_CONSUMED_CONN_SIZE		8
#define 	_ATTRIB_EXPECTED_RATE			9
#define		_ATTRIB_WDT_ACTION				12
#define		_ATTRIB_PRODUCED_CONN_PATH_LEN	13
#define		_ATTRIB_PRODUCED_CONN_PATH		14
#define		_ATTRIB_CONSUMED_CONN_PATH_LEN	15
#define		_ATTRIB_CONSUMED_CONN_PATH		16
#define		_ATTRIB_PRODUCTION_INHIBIT		17	


#define		_STATE_NON_EXISTENT		0
#define		_STATE_CONFIGURING		1
#define		_STATE_WAITING FOR_CID	2
#define		_STATE_ESTABLISHED		3
#define		_STATE_TIMED_OUT 		4
#define		_STATE_DEFERED_DELETE	5

#define		_WDT_ACTION_TIME_OUT	0
#define		_WDT_ACTION_AUTO_DELETE	1
#define		_WDT_ACTION_AUTO_RESET	2
#define		_WDT_ACTION_DEFERRED	3


/*********************************************************************
 * This defines the CONN_ATTRIB type attributes used by all regular
 * connection objects.
 ********************************************************************/
typedef struct T_ATTRIB
{
	USINT 	state;
	BYTE	transportClass;
	UINT	produced_cid;
	UINT	consumed_cid;
	UINT	produced_con_size;
	UINT	consumed_con_size;
	UINT	expected_packet_rate;
	UINT	produced_path_len;
	USINT *	produced_path;
	UINT	consumed_path_len;
	USINT *	consumed_path;
}ATTRIB;

typedef struct T_ATTRIB_COS
{
	USINT 	state;
	BYTE	transportClass;
	UINT	produced_cid;
	UINT	consumed_cid;
	BYTE	initial_comm_char;
	UINT	produced_con_size;
	UINT	consumed_con_size;
	UINT	expected_packet_rate;
	UINT	produced_path_len;
	USINT *	produced_path;
	UINT	consumed_path_len;
	USINT *	consumed_path;
//	UINT	production_inhibit_time;
}ATTRIB_COS;

typedef struct T_ATTRIB_EXPL
{
	USINT 	state;
	UINT	produced_cid;
	UINT	consumed_cid;
	UINT	expected_packet_rate;
	USINT	wdt_action;
}ATTRIB_EXPL;


typedef struct T_ATTRIB_PRIV
{
	UINT	produced_cid;
	UINT	consumed_cid;
}ATTRIB_PRIV;


/*********************************************************************
 * This defines the CONN_FLAGS type structure used to map a single bit
 * to a static connection object.
 ********************************************************************/
typedef union T_FLAGS
{
	unsigned char byte;
	struct S_FLAG_BITS
	{		
		unsigned 	expl:1;
		unsigned 	poll:1;
		unsigned 	strobe:1;
		unsigned 	cos:1;
		unsigned 	multi:1;
		unsigned	uexpl:1;
		unsigned	dupid:1;
		unsigned	:1;
	}bits;
}FLAGS;



/*********************************************************************
 * This defines the T_CONTYPE type structure used to identify the
 * type of connection to create.
 ********************************************************************/
 
 /*
typedef enum T_CONTYPE 
{
	CONTYPE_EXPLICIT = 1, 
	CONTYPE_POLL, 
	CONTYPE_BIT_STROBE,
	CONTYPE_COS_CYCLIC,
	CONTYPE_MULTICAST,
	CONTYPE_UNC_EXPLICIT,
	CONTYPE_DUPLICATE_ID,
}CONTYPE;





typedef struct T_MSG_DATA
{
	unsigned char	D0;
	unsigned char	D1;
	unsigned char	D2;
	unsigned char	D3;
	unsigned char	D4;
	unsigned char	D5;
	unsigned char	D6;
	unsigned char	D7;
}_MSG_DATA;


typedef struct T_MSG_DATA_EXPL_FRAG
{	
	unsigned char	D0;
	unsigned char	D1;
	unsigned char	D2;
	unsigned char	D3;
	unsigned char	D4;
	unsigned char	D5;
}_MSG_DATA_EXPL_FRAG;


typedef struct T_MSG_DATA_IO_FRAG
{	
	unsigned char	D0;
	unsigned char	D1;
	unsigned char	D2;
	unsigned char	D3;
	unsigned char	D4;
	unsigned char	D5;
	unsigned char	D6;
}_MSG_DATA_IO_FRAG;


*/

/*********************************************************************
 * This defines the CONN_INFO type structure used to hold information
 * about the connection.
 ********************************************************************/
typedef struct T_CONN_INFO
{
	USINT 		*pMsg;
	USINT		index;
	USINT 		len;
	USINT 		lenMax;
	USINT 		oldFrag;
	USINT		fragState;
	BYTE		fragFlags;
}INFO;

typedef struct T_CONN_INFO_EXPL
{
	USINT 		*pMsg;
	USINT		index;
	USINT 		len;
	USINT 		lenMax;
	USINT 		oldFrag;
	USINT		header;
	USINT		fragState;
	BYTE		fragFlags;
}INFO_EXPL;

typedef struct T_CONN_INFO_STROBE 
{
	USINT 		*pMsg;
	USINT 		len;
	USINT 		lenMax;
}INFO_STROBE;


typedef struct T_CONN_INFO_PRIV
{
	USINT 		*pMsg;
	USINT 		len;
	USINT 		lenMax;
	BYTE		flags;
}INFO_PRIV;


/*********************************************************************
 * This defines the CONN type structure used to hold information
 * about the connection.
 ********************************************************************/
typedef struct T_CONN
{
	ATTRIB	attrib;
	INFO	rx;
	INFO	tx;
	UINT	timer;
}CONN;

typedef struct T_CONN_COS
{
	ATTRIB_COS		attrib;
	INFO		rx;
	INFO		tx;
	UINT		timer;
//	UINT		inhTimer;
}CONN_COS;

typedef struct T_CONN_STROBE
{
	ATTRIB		attrib;
	INFO_STROBE	rx;
	INFO_STROBE	tx;
	UINT		timer;
}CONN_STROBE;

typedef struct T_CONN_EXPL
{
	ATTRIB_EXPL	attrib;
	INFO_EXPL		rx;
	INFO		tx;
	UINT		timer;			// Connection timer
	UINT		ack_tmr;		// Acknowledge timer
}CONN_EXPL;


typedef struct T_CONN_PRIV
{
	ATTRIB_PRIV	attrib;
	INFO_PRIV	rx;
	INFO_PRIV	tx;
}CONN_PRIV;


typedef struct T_FRAG
{
	NEAR INFO rx;
	NEAR INFO tx;
}FRAG;


#if SUPPORT_EXPLICIT
#include	"conn1.h"
#endif

#if SUPPORT_POLLED || SUPPORT_COS_BOTH_DIR
#include	"conn2.h"
#endif

#if SUPPORT_BIT_STROBED
#include	"conn3.h"
#endif

#if SUPPORT_COS	|| SUPPORT_CYCLIC
#include	"conn4.h"
#endif

#if SUPPORT_MULTICAST_POLL
#include	"conn5.h"
#endif

#include	"conn6.h"
#include	"conn7.h"

#include	"UsrConn.h"





/*********************************************************************
 * Flags indicating reception and transmission.
 ********************************************************************/
extern NEAR FLAGS _txFlag;
extern NEAR FLAGS _rxFlag;
extern NEAR FLAGS _txFinFlags;
extern NEAR FLAGS _existentFlags;
extern NEAR FLAGS _establishFlags;





/*********************************************************************
 * Function:        void _ConnInit(void)
 *
 * PreCondition:    
 *
 * Input:       		
 *                  
 * Output:      	
 *
 * Side Effects:    
 *
 * Overview:        Initialize the connection object 
 *
 * Note:            None
 ********************************************************************/
void _ConnInit(void);
#define mConnInit()		  _ConnInit()


/*********************************************************************
 * Function:        unsigned char _ConnCreate(enum T_CONTYPE connType)
 *
 * PreCondition:    
 *
 * Input:       		
 *                  
 * Output:      	
 *
 * Side Effects:    
 *
 * Overview:        Returns a handle to the connection 
 *
 * Note:            None
 ********************************************************************/
//unsigned char _ConnCreate(CONTYPE connType);



/*********************************************************************
 * Function:        void _ConnClose(void)
 *
 * PreCondition:    
 *
 * Input:       		
 *                  
 * Output:      	
 *
 * Side Effects:    
 *
 * Overview:        Closes the specified connection 
 *
 * Note:            None
 ********************************************************************/
//void _ConnClose(unsigned char hInstance);


/*********************************************************************
 * Function:        unsigned char _ConnReadRdy(unsigned char hInstance)
 *
 * PreCondition:    
 *
 * Input:       	unsigned char handle to the instance
 *                  
 * Output:      	unsigned char 
 *
 * Side Effects:    none
 *
 * Overview:        Returns true if there is data in the read buffer 
 *					and the connection is established.
 *
 * Note:            None
 ********************************************************************/
unsigned char _ConnReadRdy(unsigned char hInstance);
#define mConnReadRdy(instance)	_ConnReadRdy(instance)


/*********************************************************************
 * Function:        unsigned char _ConnWriteRdy(unsigned char hInstance)
 *
 * PreCondition:    
 *
 * Input:       	unsigned char handle to instance
 *                  
 * Output:      	unsigned char
 *
 * Side Effects:    
 *
 * Overview:        Returns true if the buffer is available. 
 *
 * Note:            The application must call this function prior to 
 *					loading the buffer. Otherwise any message already
 *					queued to send will be corrupted.
 ********************************************************************/
unsigned char _ConnWriteRdy(unsigned char hInstance);
#define mConnWriteRdy(instance)	_ConnWriteRdy(instance)


/*********************************************************************
 * Function:        unsigned char _ConnWriteFin(unsigned char hInstance)
 *
 * PreCondition:    
 *
 * Input:       	unsigned char handle to instance	
 *                  
 * Output:      	unsigned char
 *
 * Side Effects:    
 *
 * Overview:        Returns true if the buffer has placed data on the bus. 
 *
 * Note:            None
 ********************************************************************/
unsigned char _ConnWriteFin(unsigned char hInstance);
#define	mConnWriteFin(instance)	_ConnWriteFin(instance)



/*********************************************************************
 * Function:        void _ConnRead(unsigned char hInstance)
 *
 * PreCondition:  	Function _ConnReadRdy() should be executed prior
 *					to calling this function to determine if data has
 *					been received.  
 *
 * Input:       	unsigned char handle to instance		
 *                  
 * Output:      	none	
 *
 * Side Effects:    
 *
 * Overview:        Indicates to the Connection Object that the data 
 *					has been read and the buffer is free to take 
 *					another message.
 *
 * Note:            The function is only executed successfully if
 *					the connection is established.
 ********************************************************************/
void _ConnRead(unsigned char hInstance);
#define	mConnRead(instance)	_ConnRead(instance)


/*********************************************************************
 * Function:        void _ConnWrite(unsigned char hInstance)
 *
 * PreCondition:	Execute _ConnWriteRdy() to determine if the buffer
 *					is available before executing this function. Also
 *					load the buffer prior to sending.     
 *
 * Input:       	unsigned char handle to instance	
 *                  
 * Output:      	none
 *
 * Side Effects:    
 *
 * Overview:        Indicates to the Connection object instance that 
 * 					all data has been loaded and the connection
 *					is free to transmit. 
 *
 * Note:            The queue bit for the specified connection is set.
 *					
 ********************************************************************/
void _ConnWrite(unsigned char hInstance);
#define	mConnWrite(instance)	_ConnWrite(instance)


/*********************************************************************
 * Function:        unsigned char _ConnBusOffErr(void)
 *
 * PreCondition:    
 *
 * Input:       	none	
 *                  
 * Output:      	unsigned char 
 *
 * Side Effects:    
 *
 * Overview:        If a bus-off event has occured then return TRUE
 *
 * Note:            None
 ********************************************************************/
unsigned char _ConnBusOffErr(void);





/*********************************************************************
 * Function:        unsigned char _ConnRxManager(void)
 *
 * PreCondition:    CAN (or other I/O) driver must be ready
 *
 * Input:       	none	
 *                  
 * Output:      	unsigned char
 *
 * Side Effects:    
 *
 * Overview:        This function handles any received data events
 *					from the driver and dispaches them to the 
 *					appropriate instance.
 *
 * Note:            This function filters through the identifiers.
 *					Any messages that cannot be processed are ignored.
 *					This function also returns true if an event was
 *					generated in an instance.
 ********************************************************************/
unsigned char _ConnRxManager(void);


/*********************************************************************
 * Function:        void _ConnTxOpenManager(void)
 *
 * PreCondition:   	The connection must be open and available.
 *
 * Input:       	none		
 *                  
 * Output:      	none
 *
 * Side Effects:    
 *
 * Overview:        If a message is queued from any connection and
 *					the output buffer is available, then this function
 *					issues an event to the connection instance queued 
 *					to transmit.
 *
 * Note:            The queue is deserialized to eliminate software
 *					imposed priority on the messages.
 ********************************************************************/
void _ConnTxOpenManager(void);


/*********************************************************************
 * Function:        void _ConnTxManager(void)
 *
 * PreCondition:  	This function assumes the connection instance has
 *					been created (enabled). 	
 *
 * Input:       	none	
 *                  
 * Output:      	none
 *
 * Side Effects:    
 *
 * Overview:        If a message has finished transmitting, then the 
 *					initiator is traced and notified about the 
 *					transmission.
 *
 * Note:            None
 ********************************************************************/
void _ConnTxManager(void);


/*********************************************************************
 * Function:        void _ConnErrorManager(void)
 *
 * PreCondition:    
 *
 * Input:       	none	
 *                  
 * Output:      	none
 *
 * Side Effects:    
 *
 * Overview:        This function captures any bus-off errors from
 *					the driver.
 *
 * Note:            None
 ********************************************************************/
void _ConnErrorManager(void);


/*********************************************************************
 * Function:        void _ConnTimeManager(void)
 *
 * PreCondition:    This function must be called periodically 
 *					according to the specified tick rate.
 *
 * Input:       	none
 *                  
 * Output:      	none
 *
 * Side Effects:    
 *
 * Overview:        Process timer events. 
 *
 * Note:            Each connection manages there own timer.
 ********************************************************************/
void _ConnTimeManager(void);



/*********************************************************************
 * Function:        void _ConnStateManager(void)
 *
 * PreCondition:    
 *
 * Input:   		none    		
 *                  
 * Output:      	none
 *
 * Side Effects:    
 *
 * Overview:        Synchronize all connection states.
 *
 * Note:            Connections may be deleted.
 ********************************************************************/
void _ConnStateManager(void);



/*********************************************************************
 * Function:        unsigned char _ConnExplicitEvent()
 *
 * PreCondition:    This function is called from the router.
 *
 * Input:       	none
 *                  
 * Output:      	unsigned char
 *
 * Side Effects:    
 *
 * Overview:        Handle explicit messaging. 
 *
 * Note:            None
 ********************************************************************/
unsigned char _ConnExplMsgHandler(void);



/*********************************************************************
 * Function:        unsigned char _ConnInst0GetAttrib(void)
 *
 * PreCondition:    
 *
 * Input:       	none
 *                  
 * Output:      	unsigned char
 *
 * Side Effects:    
 *
 * Overview:        Handle explicit messaging get attribute.
 *
 * Note:            None
 ********************************************************************/			   
unsigned char _ConnInst0GetAttrib(void);




#endif	/*__CONN_H__*/
