#include <math.h>
#include "rt.h"

void Surface::Load(const XMLNode * sn)
{
	DEBUG("Loading Surface");
	for(NodeIterator itr=sn->Children.begin();
	 itr != sn->Children.end();itr++)
	{
		PRINT((*itr)->Content);
		if((*itr)->Name == "Color")
		{
			ParseColor((*itr)->Content,Color);
			PRINT(Color);
		}
		else if((*itr)->Name == "Diffuse")
		{
			Diffuse = ParseDouble((*itr)->Content);
			PRINT(Diffuse);
		}
		else if((*itr)->Name == "Reflect")
		{
			Reflect = ParseDouble((*itr)->Content);
			PRINT(Reflect);
		}
		else if((*itr)->Name == "Specular")
		{
			Specular = ParseDouble((*itr)->Content);
			PRINT(Specular);
		}
		else if((*itr)->Name == "Gloss")
		{
			Gloss = ParseDouble((*itr)->Content);
			PRINT(Gloss);
		}
		else if((*itr)->Name == "Texture")
		{
			Textured = true;
			DEBUG("Textured");
			if((*itr)->Properties["type"] == "Checkerboard")
			{
				//cout << "Loading Checkerboard texture" << endl;
				Tex = new CheckerboardTexture;
				//ParseCheckerboardTexture(*itr,(CheckerboardTexture*)Tex);
				Tex->Load(*itr);
			}
		}
		else if((*itr)->Name == "TexMap")
		{
			if((*itr)->Properties["type"] == "Planar")
			{
				//cout << "Loading planar texture map" << endl;
				TexMap = new PlanarMapping;
				//ParsePlanarTexMap(*itr,(PlanarMapping*)TexMap);
				TexMap->Load(*itr);
			}
		}
	}
}

Color4 Surface::ColorAt(Vector3D<> ISect, Vector3D<> Normal)
{
	if(Textured)
		return Tex->ColorAt(
				TexMap->GetCoords(ISect,Normal));
	else
		return Color;
}

double Sphere::ISection(Ray & r)
{
	Vector3D<> ToCenter = Center - r.Start;
	double d2c2 = ToCenter.dot(ToCenter);
	double r2 = Radius*Radius;
	if(!Outward && d2c2 > r2)
		return -1;
	//Gemetrically calulate the closest approach to the sphere
	double ToClosest = r.Dir.dot(ToCenter);
	double CD2 =  d2c2 - ToClosest*ToClosest;
	if(CD2 < 0 || CD2 > r2)
	{
		return -1;
	}
	//then use the pythagorean formula.
	if(Outward)
		return (ToClosest - sqrt(r2 - CD2));
	else
 		return (ToClosest + sqrt(r2 - CD2));
}

void Sphere::Load(const XMLNode * sn)
{
	DEBUG("Loading Sphere");
	for(NodeIterator itr=sn->Children.begin();
	 itr != sn->Children.end();itr++)
	{
		PRINT((*itr)->Content);
		if((*itr)->Name == "Center")
		{
			ParseVector((*itr)->Content,Center);
			PRINT(Center);
		}
		else if((*itr)->Name == "Radius")
		{
			Radius = ParseDouble((*itr)->Content);
			PRINT(Radius);
		}
		else if((*itr)->Name == "Surface")
			Surf.Load(*itr);
	}
	
}

void Sphere::Flip()
{
	Outward = !Outward;
}

Obj3D * Sphere::NewCopy()
{
	return new Sphere(*this);
}

Vector3D<> Sphere::NormalAt(const Vector3D<> & Point)
{
	//Normal depends on if we're outward or inward facing
	return (Outward)?((Point - Center)/Radius):((Center - Point)/Radius);
}

double Plane::ISection(Ray &r)
{
	//Algorithm from nehe.gamedev.net:
	//t= (Xn dot (PointOnPlane - Raystart)) / (Xn dot Raydirection)
	
	double d = Normal.dot(r.Dir);
	if(d == 0) return -1;
	return Normal.dot(Point-r.Start)/d;
}

void Plane::Load(const XMLNode * pn)
{
	DEBUG("Loading Plane");
	for(NodeIterator itr=pn->Children.begin();
	 itr != pn->Children.end();itr++)
	{
		PRINT((*itr)->Content);
		if((*itr)->Name == "Point")
		{
			ParseVector((*itr)->Content,Point);
			PRINT(Point);
		}
		else if((*itr)->Name == "Normal")
		{
			ParseVector((*itr)->Content,Normal);
			PRINT(Normal);
		}
		else if((*itr)->Name == "Surface")
			Surf.Load(*itr);
	}
}

Vector3D<> Plane::NormalAt(const Vector3D<> & Point)
{
	return Normal;
}

void Plane::Flip()
{
	Normal *= -1;
}

Obj3D * Plane::NewCopy()
{
	return new Plane(*this);
}
