/*
 * Decompiled with CFR 0.152.
 */
package com.opera;

import com.opera.PluginClassLoader;
import com.opera.PluginContextManager;
import com.opera.PluginPanel;
import com.opera.StreamHandlerFactory;
import java.applet.Applet;
import java.applet.AppletContext;
import java.applet.AudioClip;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class PluginContext
implements AppletContext {
    private static boolean useImageCache;
    private static boolean useAudioCache;
    private static String clipImplName;
    protected static Object opera_mutex;
    private HashSet panels = new HashSet();
    private Hashtable audioCache = new Hashtable();
    private Hashtable imageCache = new Hashtable();
    protected int document_ptr = 0;
    protected int lf_document_ptr = 0;
    private PluginClassLoader loader = null;
    private PluginClassLoader lcClassLoader = null;
    private static Thread mainThread;
    private int refMac = 0;

    protected PluginContext(int n) {
        this.document_ptr = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Applet getApplet(String string) {
        Iterator iterator;
        string = string.toLowerCase();
        HashSet hashSet = this.panels;
        synchronized (hashSet) {
            iterator = this.panels.iterator();
        }
        while (iterator.hasNext()) {
            PluginPanel pluginPanel = (PluginPanel)iterator.next();
            String string2 = pluginPanel.getParameter("name");
            if (string2 != null) {
                string2 = string2.toLowerCase();
            }
            if (!string.equals(string2)) continue;
            return pluginPanel.getApplet();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Enumeration getApplets() {
        Iterator iterator;
        Vector<Applet> vector = new Vector<Applet>();
        HashSet hashSet = this.panels;
        synchronized (hashSet) {
            iterator = this.panels.iterator();
        }
        while (iterator.hasNext()) {
            vector.addElement(((PluginPanel)iterator.next()).getApplet());
        }
        return vector.elements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AudioClip getAudioClip(final URL uRL) {
        PluginContext.checkConnect(uRL);
        Hashtable hashtable = this.audioCache;
        synchronized (hashtable) {
            AudioClip audioClip = null;
            if (useAudioCache) {
                audioClip = (AudioClip)this.audioCache.get(uRL);
            }
            if (audioClip == null) {
                audioClip = (AudioClip)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        try {
                            Class<?> clazz = Class.forName(clipImplName);
                            Class[] classArray = new Class[]{Class.forName("java.net.URL")};
                            Object[] objectArray = new Object[]{uRL};
                            Constructor<?> constructor = clazz.getConstructor(classArray);
                            AudioClip audioClip = (AudioClip)constructor.newInstance(objectArray);
                            if (useAudioCache) {
                                PluginContext.this.audioCache.put(uRL, audioClip);
                            }
                            return audioClip;
                        }
                        catch (Exception exception) {
                            exception.printStackTrace(System.err);
                            return null;
                        }
                    }
                });
            }
            return audioClip;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image getImage(URL uRL) {
        Hashtable hashtable = this.imageCache;
        synchronized (hashtable) {
            Image image = null;
            if (useImageCache) {
                image = (Image)this.imageCache.get(uRL);
            }
            if (image == null) {
                try {
                    String string;
                    InputStream inputStream;
                    String string2 = this.loader.getCodeBase().toString();
                    String string3 = uRL.toString();
                    int n = string3.indexOf(string2);
                    if (n == 0 && (inputStream = this.loader.getResourceAsStream(string = string3.charAt(string2.length()) == '/' ? string3.substring(string2.length() + 1) : string3.substring(string2.length()))) != null) {
                        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                        byte[] byArray = new byte[8192];
                        int n2 = 0;
                        while ((n2 = bufferedInputStream.read(byArray, 0, 8192)) != -1) {
                            byteArrayOutputStream.write(byArray, 0, n2);
                        }
                        bufferedInputStream.close();
                        byte[] byArray2 = byteArrayOutputStream.toByteArray();
                        if (byArray2 != null && byArray2.length > 0) {
                            return Toolkit.getDefaultToolkit().createImage(byArray2);
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace(System.err);
                }
                image = Toolkit.getDefaultToolkit().createImage(uRL);
                if (useImageCache) {
                    this.imageCache.put(uRL, image);
                }
            }
            return image;
        }
    }

    public void showDocument(URL uRL) {
        this.showDocument(uRL, "_top");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showDocument(URL uRL, String string) {
        Object object = opera_mutex;
        synchronized (object) {
            String string2 = uRL.toString();
            this.showDocument(string2, string);
        }
    }

    private native void showDocument(String var1, String var2);

    public native void showStatus(String var1);

    public void setStream(String string, InputStream inputStream) throws IOException {
    }

    public InputStream getStream(String string) {
        return null;
    }

    public Iterator getStreamKeys() {
        return null;
    }

    static boolean isInMainThread() {
        return Thread.currentThread() == mainThread;
    }

    static void init(String[] stringArray) throws SecurityException {
        Object object;
        Object object2;
        mainThread = Thread.currentThread();
        try {
            Class<?> clazz = Class.forName("sun.plugin.security.JDK11ClassFileTransformer");
            object2 = clazz.getMethod("init", null);
            ((Method)object2).invoke(null, null);
            object = Class.forName("sun.plugin.security.Broken11ClassFixer");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        int n = 0;
        while (n < stringArray.length / 2) {
            System.setProperty(stringArray[n * 2], stringArray[n * 2 + 1]);
            ++n;
        }
        object2 = new SecurityManager();
        System.setSecurityManager((SecurityManager)object2);
        object = System.getSecurityManager();
        if (object != null) {
            ((SecurityManager)object).checkPermission(new AllPermission());
        }
        if (System.getProperty("browser.opera.useStreamHandler").equals("true")) {
            URL.setURLStreamHandlerFactory(new StreamHandlerFactory());
        }
        useImageCache = Boolean.valueOf(System.getProperty("browser.opera.useImageCache", "true"));
        System.out.println("Image cache " + (useImageCache ? "enabled" : "disabled"));
        useAudioCache = Boolean.valueOf(System.getProperty("browser.opera.useAudioCache", "true"));
        System.out.println("Audio cache: " + (useAudioCache ? "enabled" : "disabled"));
        try {
            PluginPanel.setClassLoaderCacheSize(Integer.parseInt(System.getProperty("browser.opera.classLoaderCacheSize", "10")));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        clipImplName = System.getProperty("browser.opera.audioClipClassName");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PluginPanel newPanel(String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4, String string, int n, boolean bl) {
        try {
            if (string.startsWith("file://localhost/")) {
                string = "file://" + string.substring(16);
            }
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            int n2 = 0;
            while (n2 < stringArray3.length) {
                if (!hashtable.containsKey(stringArray3[n2].toLowerCase())) {
                    hashtable.put(stringArray3[n2].toLowerCase(), stringArray4[n2]);
                }
                ++n2;
            }
            Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
            int n3 = 0;
            while (n3 < stringArray.length) {
                if (!hashtable2.containsKey(stringArray[n3].toLowerCase())) {
                    hashtable2.put(stringArray[n3].toLowerCase(), stringArray2[n3]);
                }
                ++n3;
            }
            PluginPanel pluginPanel = new PluginPanel(this, hashtable2, hashtable, new URL(string), n, bl);
            HashSet hashSet = this.panels;
            synchronized (hashSet) {
                this.panels.add(pluginPanel);
                return pluginPanel;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            return null;
        }
    }

    void destroyPanel(PluginPanel pluginPanel) {
        try {
            if (pluginPanel != null) {
                Frame frame = (Frame)pluginPanel.getParent();
                if (frame != null) {
                    frame.removeAll();
                    frame.dispose();
                }
                pluginPanel.destroyApplet();
                this.panels.remove(pluginPanel);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    native int getJSWindow();

    native int getESRuntime();

    private static void checkConnect(URL uRL) {
        block3: {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager == null) break block3;
            try {
                Permission permission = uRL.openConnection().getPermission();
                if (permission != null) {
                    securityManager.checkPermission(permission);
                    break block3;
                }
                securityManager.checkConnect(uRL.getHost(), uRL.getPort());
            }
            catch (IOException iOException) {
                securityManager.checkConnect(uRL.getHost(), uRL.getPort());
            }
        }
    }

    protected void setClassLoader(PluginClassLoader pluginClassLoader) {
        if (this.loader == null) {
            this.loader = pluginClassLoader;
        }
    }

    protected void cleanup() {
        if (this.loader != null) {
            ThreadGroup threadGroup = this.loader.getThreadGroup();
            this.loader = null;
        }
    }

    int getDocumentPtr() {
        return this.document_ptr;
    }

    void documentDeleted() {
        this.lf_document_ptr = this.document_ptr;
        this.document_ptr = 0;
        if (this.lcClassLoader != null) {
            this.lcClassLoader.release();
            this.lcClassLoader = null;
        }
    }

    protected void setDocumentPtr(int n) {
        this.document_ptr = n;
    }

    protected void setLoadingFinished(int n) {
        if ((this.document_ptr != 0 || this.lf_document_ptr != 0) && n != 0) {
            this.nativeSetLoadingFinished(this.document_ptr == 0 ? this.lf_document_ptr : this.document_ptr, n);
        }
    }

    private native void nativeSetLoadingFinished(int var1, int var2);

    void incRefMac() {
        ++this.refMac;
    }

    void decRefMac() {
        if (--this.refMac == 0) {
            PluginContextManager.deleteContext(this);
        }
    }

    PluginClassLoader getLCClassLoader(URL uRL) {
        try {
            if (this.lcClassLoader == null) {
                this.lcClassLoader = PluginPanel.getClassLoader(uRL, uRL, null);
                this.lcClassLoader.grab();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
        return this.lcClassLoader;
    }

    static {
        opera_mutex = new Object();
    }
}

