/*
 * Decompiled with CFR 0.152.
 */
package com.opera;

import com.opera.PluginClassLoader;
import com.opera.PluginContext;
import com.opera.PluginContextManager;
import com.opera.ReleaseLoaderThread;
import java.applet.Applet;
import java.applet.AppletContext;
import java.applet.AppletStub;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Panel;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;

public class PluginPanel
extends Panel
implements AppletStub,
Runnable {
    private static final int APPSTATE_UNKNOWN = 0;
    private static final int APPSTATE_LOADING = 1;
    private static final int APPSTATE_NOTFOUND = 2;
    private static final int APPSTATE_STOPPED = 3;
    private static final int APPSTATE_RUNNING = 4;
    private static final int APPSTATE_CRASHED = 5;
    private static final int APPSTATE_DESTROYED = 6;
    private static final int APPSTATE_INTERRUPTED = 7;
    private static final int APPSTATE_CLASSFORMATERROR = 8;
    private static final int APPSTATE_SUPPRESSED = 9;
    private int appletState = 0;
    private boolean suppressExternal;
    private boolean isSuppressed = false;
    private Applet applet;
    private PluginContext context;
    private int inline_elm;
    private URL codeBase;
    private URL docBase;
    private Hashtable params;
    private Hashtable attr;
    private PluginClassLoader loader;
    private Thread loaderThread = null;
    private Thread destroyThread = null;
    private static Hashtable classLoaders = new Hashtable();
    private static int noRefMax = 10;
    private static Vector noRefLoaders = new Vector();

    protected static void setClassLoaderCacheSize(int n) {
        if (n < 0) {
            n = 0;
        }
        noRefMax = n;
        System.out.println("ClassLoader cache size: " + noRefMax);
    }

    private int getWidthParam() {
        String string;
        if (this.attr != null && (string = (String)this.attr.get("width")) != null) {
            return new Integer(string);
        }
        return 150;
    }

    private int getHeightParam() {
        String string;
        if (this.attr != null && (string = (String)this.attr.get("height")) != null) {
            return new Integer(string);
        }
        return 150;
    }

    public PluginPanel(PluginContext pluginContext, Hashtable hashtable, Hashtable hashtable2, URL uRL, int n, boolean bl) {
        try {
            String string;
            this.suppressExternal = bl;
            this.setBackground(new Color(200, 200, 200));
            this.setLayout(new BorderLayout());
            this.context = pluginContext;
            this.attr = hashtable;
            this.params = hashtable2;
            this.docBase = uRL;
            this.inline_elm = n;
            String string2 = this.getParameter("java_codebase");
            if (string2 == null) {
                string2 = this.getParameter("codebase");
            }
            if (string2 != null) {
                if (string2.startsWith("file://localhost/")) {
                    string2 = "file://" + string2.substring(16);
                }
                if (!string2.endsWith("/")) {
                    string2 = string2 + "/";
                }
                try {
                    this.codeBase = new URL(this.docBase, string2);
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            String string3 = this.docBase.getFile();
            URL uRL2 = null;
            int n2 = string3.lastIndexOf(47);
            if (n2 >= 0 && n2 < string3.length() - 1) {
                try {
                    uRL2 = new URL(this.docBase, string3.substring(0, n2 + 1));
                }
                catch (MalformedURLException malformedURLException) {
                    malformedURLException.printStackTrace(System.err);
                }
            }
            if (uRL2 == null) {
                uRL2 = this.docBase;
            }
            if (this.codeBase == null) {
                this.codeBase = uRL2;
            }
            if ((string = this.getParameter("java_archive")) == null) {
                string = this.getParameter("archive");
            }
            if (this.getParameter("cache_archive") != null) {
                string = string != null ? string + "," + this.getParameter("cache_archive") : this.getParameter("cache_archive");
            }
            this.loader = PluginPanel.getClassLoader(this.codeBase, uRL2, string);
            this.loader.grab();
            if (this.suppressExternal) {
                URL[] uRLArray = this.loader.getURLs();
                int n3 = 0;
                while (n3 < uRLArray.length) {
                    if (uRLArray[n3] != null && uRLArray[n3].getProtocol() != "file") {
                        this.isSuppressed = true;
                        break;
                    }
                    ++n3;
                }
            }
            if (pluginContext != null) {
                pluginContext.setClassLoader(this.loader);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    static PluginClassLoader getClassLoader(URL uRL, URL uRL2, String string) {
        PluginClassLoader pluginClassLoader;
        String string2 = uRL.toString();
        if (string != null) {
            string2 = string2 + "," + string.trim();
        }
        if ((pluginClassLoader = (PluginClassLoader)classLoaders.get(string2)) == null) {
            pluginClassLoader = new PluginClassLoader(uRL, string2);
            if (string != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ",", false);
                while (stringTokenizer.hasMoreTokens()) {
                    String string3 = stringTokenizer.nextToken().trim();
                    try {
                        pluginClassLoader.addJar(new URL(uRL, string3));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        illegalArgumentException.printStackTrace(System.err);
                    }
                    catch (MalformedURLException malformedURLException) {
                        malformedURLException.printStackTrace(System.err);
                    }
                }
            }
            classLoaders.put(string2, pluginClassLoader);
        } else {
            noRefLoaders.remove(pluginClassLoader);
        }
        return pluginClassLoader;
    }

    static void cacheClassLoader(PluginClassLoader pluginClassLoader) {
        if (noRefMax <= 0) {
            classLoaders.remove(pluginClassLoader.getKey());
        } else {
            if (noRefLoaders.size() >= noRefMax) {
                classLoaders.remove(((PluginClassLoader)noRefLoaders.get(0)).getKey());
                noRefLoaders.remove(0);
            }
            noRefLoaders.add(pluginClassLoader);
        }
    }

    static void clearClassLoaderCache() {
        Iterator iterator = classLoaders.values().iterator();
        while (iterator.hasNext()) {
            PluginClassLoader pluginClassLoader = (PluginClassLoader)iterator.next();
            if (pluginClassLoader.getUsageCount() != 0) continue;
            iterator.remove();
        }
    }

    static void printClassLoaders() {
        System.out.println("Classloaders:");
        Iterator iterator = classLoaders.values().iterator();
        while (iterator.hasNext()) {
            PluginClassLoader pluginClassLoader = (PluginClassLoader)iterator.next();
            System.out.println(pluginClassLoader.getKey());
        }
    }

    void resizeEmbedBox(int n, int n2) {
        Dimension dimension = this.getSize();
        if (dimension.getWidth() == (double)n && dimension.getHeight() == (double)n2) {
            return;
        }
        Frame frame = (Frame)this.getParent();
        if (frame != null) {
            frame.setSize(n, n2);
        }
        this.setSize(n, n2);
        if (this.applet != null) {
            this.applet.setSize(n, n2);
        }
        this.validate();
        this.attr.put("width", String.valueOf(n));
        this.attr.put("height", String.valueOf(n2));
    }

    public void appletResize(int n, int n2) {
        this.setSize(n, n2);
    }

    public AppletContext getAppletContext() {
        return this.context;
    }

    public URL getCodeBase() {
        return this.codeBase;
    }

    public URL getDocumentBase() {
        return this.docBase;
    }

    public String getParameter(String string) {
        String string2 = (String)this.params.get(string.toLowerCase());
        if (string2 == null) {
            string2 = (String)this.attr.get(string.toLowerCase());
        }
        return string2;
    }

    public boolean isActive() {
        return this.appletState == 4;
    }

    public void loadApplet() {
        try {
            ThreadGroup threadGroup = this.loader.getThreadGroup();
            this.loaderThread = new Thread(threadGroup, this);
            this.loaderThread.setContextClassLoader(this.loader);
            this.loaderThread.start();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    public void startApplet() {
        block3: {
            try {
                if (this.applet != null && this.appletState == 3) {
                    this.applet.resize(this.getWidthParam(), this.getHeightParam());
                    this.applet.start();
                    this.appletState = 4;
                    this.applet.validate();
                    this.applet.setVisible(true);
                    this.context.showStatus("Applet started.");
                }
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
                if (this.appletState == 4) break block3;
                this.appletState = 5;
                this.getParent().repaint();
                this.repaint();
            }
        }
    }

    public void stopApplet() {
        if (this.applet != null && this.appletState == 4) {
            try {
                this.applet.stop();
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
            this.appletState = 3;
        }
    }

    public void destroy() {
        if (this.context != null) {
            this.context.destroyPanel(this);
        }
    }

    public void destroyApplet() {
        try {
            if (this.loaderThread != null) {
                try {
                    this.loaderThread.interrupt();
                }
                catch (Exception exception) {
                    exception.printStackTrace(System.err);
                }
                this.loaderThread = null;
            }
            if (this.loader != null) {
                this.destroyThread = new Thread(this.loader.getThreadGroup(), this);
                this.destroyThread.setContextClassLoader(this.loader);
                this.destroyThread.start();
                ReleaseLoaderThread releaseLoaderThread = new ReleaseLoaderThread(this.loader);
                releaseLoaderThread.start();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
        catch (Error error) {
            error.printStackTrace(System.err);
        }
    }

    public Applet getApplet() {
        return this.applet;
    }

    public void run() {
        if (Thread.currentThread() == this.destroyThread) {
            if (this.applet != null) {
                if (this.appletState == 4) {
                    this.stopApplet();
                }
                try {
                    this.applet.destroy();
                }
                catch (Exception exception) {
                    exception.printStackTrace(System.err);
                }
                this.applet = null;
                this.appletState = 6;
            }
            this.destroyThread = null;
        } else {
            if (this.isSuppressed) {
                this.appletState = 9;
                this.getParent().repaint();
                this.repaint();
            } else {
                try {
                    String string = this.getParameter("java_code");
                    if (string == null) {
                        string = this.getParameter("code");
                    }
                    if (string != null) {
                        string = string.replace('/', '.');
                        int n = string.length();
                        String string2 = string;
                        if (n > 6 && string.startsWith(".class", n - 6)) {
                            string2 = string.substring(0, n - 6);
                        }
                        this.appletState = 1;
                        this.getParent().repaint();
                        this.repaint();
                        Class<?> clazz = this.loader.loadClass(string2);
                        if (clazz != null) {
                            this.applet = (Applet)clazz.newInstance();
                            if (this.applet != null) {
                                this.appletState = 3;
                                this.getParent().repaint();
                                this.repaint();
                                this.applet.setStub(this);
                                this.applet.setVisible(false);
                                this.add("Center", this.applet);
                                this.getParent().validate();
                                this.getParent().setSize(this.getWidthParam(), this.getHeightParam());
                                this.setSize(this.getWidthParam(), this.getHeightParam());
                                this.applet.resize(this.getWidthParam(), this.getHeightParam());
                                this.context.showStatus("Initializing applet.");
                                try {
                                    this.applet.init();
                                    this.getParent().validate();
                                    this.getParent().setVisible(true);
                                    this.setVisible(true);
                                    this.startApplet();
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace(System.err);
                                    this.appletState = 5;
                                    this.getParent().repaint();
                                    this.repaint();
                                }
                            } else {
                                this.appletState = 2;
                                this.getParent().repaint();
                                this.repaint();
                            }
                        } else {
                            this.appletState = 2;
                            this.getParent().repaint();
                            this.repaint();
                        }
                    }
                    this.loaderThread = null;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    this.appletState = 2;
                    this.getParent().repaint();
                    this.repaint();
                    classNotFoundException.printStackTrace(System.err);
                    this.loaderThread = null;
                }
                catch (Exception exception) {
                    this.appletState = 5;
                    this.getParent().repaint();
                    this.repaint();
                    exception.printStackTrace(System.err);
                    this.loaderThread = null;
                }
                catch (ClassFormatError classFormatError) {
                    this.appletState = 8;
                    this.getParent().repaint();
                    this.repaint();
                    classFormatError.printStackTrace(System.err);
                }
                catch (Error error) {
                    this.appletState = 5;
                    this.getParent().repaint();
                    this.repaint();
                    error.printStackTrace(System.err);
                    this.loaderThread = null;
                }
            }
            if (this.context != null && this.inline_elm != 0) {
                this.context.setLoadingFinished(this.inline_elm);
                this.inline_elm = 0;
            }
        }
    }

    public void paint(Graphics graphics) {
        try {
            if (this.appletState != 0 && this.appletState != 4) {
                String string;
                FontMetrics fontMetrics = graphics.getFontMetrics();
                switch (this.appletState) {
                    case 1: {
                        string = "Loading applet...";
                        break;
                    }
                    case 2: {
                        string = "Applet not found.";
                        break;
                    }
                    case 3: {
                        string = "Applet loaded.";
                        break;
                    }
                    case 5: {
                        string = "Applet crashed.";
                        break;
                    }
                    case 6: {
                        string = "Applet destroyed.";
                        break;
                    }
                    case 7: {
                        string = "Loading interrupted.";
                        break;
                    }
                    case 8: {
                        string = "Invalid bytecode.";
                        break;
                    }
                    case 9: {
                        string = "Suppressed external.";
                        break;
                    }
                    default: {
                        string = "";
                    }
                }
                int n = fontMetrics.stringWidth(string);
                int n2 = (this.getWidth() - n) / 2;
                if (n2 < 0) {
                    n2 = 0;
                }
                graphics.drawString(string, n2, this.getHeight() / 2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    private static PluginPanel newPanel(int n, int n2, int n3, String string, String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4, boolean bl) {
        try {
            PluginContext pluginContext = PluginContextManager.getContext(n2);
            PluginPanel pluginPanel = pluginContext.newPanel(stringArray, stringArray2, stringArray3, stringArray4, string, n3, bl);
            String string2 = System.getProperty("browser.opera.frameClassName");
            Frame frame = PluginPanel.createNewFrame(string2.replace('.', '/'), n);
            frame.add(pluginPanel);
            pluginPanel.loadApplet();
            frame.setVisible(true);
            pluginPanel.setVisible(true);
            Graphics graphics = pluginPanel.getGraphics();
            graphics.setFont(new Font("sans-serif", 0, 10));
            pluginPanel.repaint();
            return pluginPanel;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            return null;
        }
    }

    private static native Frame createNewFrame(String var0, int var1);
}

