.TH ATHDIR 1 "1 January 1995"
.ds ]W MIT Athena
.SH NAME
athdir \- find machine specific directories using Athena conventions
.SH SYNOPSIS
.nf
athdir \fIlockerpath\fR [\fItype\fR]

athdir [-t \fItype\fR] [-p \fIlockerpath\fR ...] [-e] [-c] [-l] [-i | -d]
       [-r \fIrecsep\fR] [-f \fIformat\fR] [-s \fIsysname\fR] [-m \fImachtype\fR]
.fi
.SH DESCRIPTION
\fIathdir\fR provides the most reliable way to determine the location
in a locker of specific types of machine dependent files. While in C
shell scripts the shell variable \fIbindir\fR is typically available,
that information is not available in all environments (such as
makefiles) and not necessarily as reliable, as it contains no
intelligence. Similarly, while the environment variable
\fIATHENA_SYS\fR is widely available, attempting to use it in
makefiles or resource files may fail on older lockers that have not
yet been upgraded to use the new conventions. (See \fIlockers\fR(7)
for more information on locker directory conventions.)

In the first invocation shown above, \fIathdir\fR does not accept
command line options other than the two listed, and they must be in
the listed order. If \fItype\fR is not specified, ``bin'' is assumed.

In the second invocation above, no particular option is required,
though at least one option is.  \fItype\fR has no default value, and
the options may be specified in any order.
.SH EXAMPLES
\fIathdir\fR may be used to find directories for any sort of machine
dependent or potentially machine dependent files. In its most common
form, it should be used to replace \fImachtype\fR(1) (as in
``/mit/locker/`machtype`bin''). For example,

     set path=($path `athdir /mit/locker`)

will append ``/mit/locker/arch/pmax_ul4/bin'' to the user's search
path if the locker supports that as the machine specific binary
directory, or ``/mit/locker/decmipsbin'' otherwise. Note that in this
case, no type argument is specified, so ``bin'' is assumed. The
example is shorthand for using `athdir /mit/locker bin`. Similarly,
one might have in one's .twmrc file:

    "meow"   f.exec "`athdir /mit/sipb`/oneko &"

to replace:

    "meow"   f.exec "/mit/sipb/`machtype`bin/oneko &"

The rest of this manual page will probably not be of interest to most
users, but may be of interest to developers.

Another useful application for \fIathdir\fR is in makefiles. For
example, suppose you wish to build a program against the x11 locker.
You might start with

     INCLUDES = `athdir /mit/x11 include`
     LIBS = `athdir /mit/x11 lib`

to find the appropriate directories in the locker. For dependencies
on multiple lockers, you might have

     INCLUDES = `athdir -t include -p /mit/motif /mit/x11`
     LIBS = `athdir -t lib -p /mit/motif /mit/x11`

which might resolve to

     INCLUDES = /mit/motif/include /mit/x11/include
     LIBS = /mit/motif/sun4lib /mit/x11/arch/sun4m_53/lib

Note that this example allows for the possibility of machine dependent
include files as well as libraries.

In general, \fItype\fRs are treated as random strings by
\fIathdir\fR. \fIathdir\fR checks the locker first for
arch/$ATHENA_SYS/\fItype\fR, then for `machtype`\fItype\fR, then
finally for simply \fItype\fR. Exceptions to this rule are cases where
a convention is never expected to be used, or where a convention is
explicitly discouraged and has never been supported. Note that if any
future conventions arise, \fIathdir\fR will know about them and act
accordingly. Thus, in theory, the usage of \fIathdir\fR should be
forward compatible, and is encouraged.
.SH OPTIONS
\fIathdir\fR provides a few options for modifying its default behavior
and providing other useful information.
.TP 8
.B \-e
This option causes \fIathdir\fR to not engage in potentially annoying
editorial behavior. It will not implement the above mentioned
exceptions on conventions not expected or discouraged.
.TP 8
.B \-c
This option causes \fIathdir\fR to not check for the usage of
different possible conventions, and simply return output in the form
of currently favored convention (arch). This is useful, for example,
in makefiles that may wish to ``\fImkdir\fR -p'' target directories.
.TP 8
.B \-d
This option, when used with \-c, tells \fIathdir\fR that you wish it
to use the favored machine dependent directory convention when
returning a pathname. \fIathdir\fR makes assumptions, based on
\fItype\fR, what kind of directory should be returned. For example, if
the \fItype\fR were ``include,'' \fIathdir\fR would ordinarily return
something like ``/mit/locker/include.'' If you specify \-d, it would
return ``/mit/locker/arch/$ATHENA_SYS/include'' instead.
.TP 8
.B \-i
This option, when used with \-c, tells \fIathdir\fR that you wish it
to use the favored machine independent directory convention when
returning a pathname. This is basically the reverse of the \-d option.
\fIathdir\fR, when it does not recognize a \fItype\fR, assumes the
type to be machine dependent, so \-i may be used to override that.
.TP 8
.B \-l
This option causes \fIathdir\fR to list the locations it would look
for the \fItype\fR of directory requested, rather than looking in them
and returning a single value. If a directory path is not specified,
\fIathdir\fR will output a ``%p'' in its place; if a \fItype\fR is not
specified, a ``%t'' will be output in its place, and all three above
mentioned possibilities will be output.
.TP 8
.B \-f \fIformat\fR
This option passes a format string to \fIathdir\fR to be used as a
style for searching for directories. It is used as the preferred
path style, with the built-in styles as fallbacks. It makes the following
substitutions:

        %p   path (as passed by -p)
        %t   type (as passed by -t)
        %s   sysname
        %m   machtype value

For example, the arch convention uses the string %p/arch/%s/%t.
.TP 8
.B \-r \fIrecsep\fR
Specify the record separator when multiple paths are output. By default this
is a newline. It may be useful to specify it to be a space or colon on
various occasions.
.TP 8
.B \-s \fIsysname\fR
This option allows a command line override for the \fIATHENA_SYS\fR
value used in generating new style machine directories.
.TP 8
.B \-m \fImachtype\fR
This option allows a command line override for the \fImachtype\fR
value used in generating old style machine directories.
.SH SEE ALSO
machtype(1), lockers(7), mkdir(1)
.SH AUTHOR
Craig Fields, MIT Information Systems
.br
Copyright (c) 1995, Massachusetts Institute of Technology
