/*	Created by:	Robert French
 *
 *	$Id: mount.c,v 1.10 1995/12/22 08:31:47 ghudson Exp $
 *
 *	Copyright (c) 1988 by the Massachusetts Institute of Technology.
 */

static char *rcsid_mount_c = "$Header: /afs/sipb/project/sipb-athena/src/attach/RCS/mount.c,v 1.10 1995/12/22 08:31:47 ghudson Exp $";

#include "attach.h"

#ifdef _IBMR2
#include <sys/id.h>
#endif

mountfs(at, fsname, mopt, errorout)
	struct	_attachtab *at;
	char	*fsname;
	struct	mntopts *mopt;
	int errorout;
{
	int status;

	if (setreuid(0,0)) {
		fprintf(stderr, "Unable to change the uid to 0\n");
		return(FAILURE);
	}

	switch (fork()) {
	case -1:
		fprintf(stderr, "Unable to fork\n");
		return(FAILURE);
		/* NOTREACHED */
	case 0:
#ifdef linux
		/* Erase all groups for the mount.  XXX */
		setgroups(0,NULL);
#endif linux
		execl(MOUNT_CMD, MOUNT_CMD, "-o", stropt(*mopt), fsname,
		      at->mntpt, (char *)0);
		exit(1);
		/* NOTREACHED */
	default:
		wait(&status);
		break;
	}

	return(status ? FAILURE : SUCCESS);
}

