/* $Id: cleanup.h,v 2.11 1996/06/01 18:33:42 ghudson Exp $ */

#include <sys/types.h>
#include <sys/param.h>
#include <signal.h>

#ifdef __STDC__
#define P(x) x
#else
#define P(x) ()
#endif

#ifdef BSD4_4
#include <paths.h>
#define PATH_PASSWD		_PATH_MASTERPASSWD
#define PATH_GROUP		_PATH_GROUP
#else
#define PATH_PASSWD		"/etc/passwd"
#define PATH_GROUP		"/etc/group"
#endif
#define PATH_PASSWD_LOCK	"/etc/ptmp"
#define PATH_GROUP_LOCK		"/etc/gtmp"
#define PATH_NOLOGIN		"/etc/nologin"

struct cl_proc {
    pid_t pid;
    int uid;
};

struct cl_user {
    char name[9];
    int uid;
};

/* passwd.c */
struct cl_user *get_password_entries P((void));
int rewrite_passwd P((struct cl_user *users, FILE *passwdfile,
		      FILE *tempfile));
int begin_update_force P((const char *filename, const char *lockfilename,
			  FILE **fp, FILE **tempfp, sigset_t *mask));

/* utmp.c */
struct cl_user *get_logged_in P((void));

/* procs.c */
struct cl_proc *get_processes P((void));

